/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

public interface NodeOptions {
    public boolean isFlattenPackages();

    public boolean isAbbreviatePackageNames();

    public boolean isHideEmptyMiddlePackages();

    public boolean isShowLibraryContents();

    public static class Immutable
    implements NodeOptions {
        public static final NodeOptions DEFAULT = new Immutable(null);
        private final boolean myFlattenPackages;
        private final boolean myAbbreviatePackageNames;
        private final boolean myHideEmptyMiddlePackages;
        private final boolean myShowLibraryContents;

        public Immutable(NodeOptions options) {
            this.myFlattenPackages = options != null && options.isFlattenPackages();
            this.myAbbreviatePackageNames = options != null && options.isAbbreviatePackageNames();
            this.myHideEmptyMiddlePackages = options != null && options.isHideEmptyMiddlePackages();
            this.myShowLibraryContents = options != null && options.isShowLibraryContents();
        }

        @Override
        public boolean isFlattenPackages() {
            return this.myFlattenPackages;
        }

        @Override
        public boolean isAbbreviatePackageNames() {
            return this.myAbbreviatePackageNames;
        }

        @Override
        public boolean isHideEmptyMiddlePackages() {
            return this.myHideEmptyMiddlePackages;
        }

        @Override
        public boolean isShowLibraryContents() {
            return this.myShowLibraryContents;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null || !object.getClass().equals(this.getClass())) {
                return false;
            }
            NodeOptions options = (NodeOptions)object;
            return options.isFlattenPackages() == this.isFlattenPackages() && options.isAbbreviatePackageNames() == this.isAbbreviatePackageNames() && options.isHideEmptyMiddlePackages() == this.isHideEmptyMiddlePackages() && options.isShowLibraryContents() == this.isShowLibraryContents();
        }

        public int hashCode() {
            int result2 = this.getClass().hashCode();
            result2 = 31 * result2 + Boolean.hashCode(this.isFlattenPackages());
            result2 = 31 * result2 + Boolean.hashCode(this.isAbbreviatePackageNames());
            result2 = 31 * result2 + Boolean.hashCode(this.isHideEmptyMiddlePackages());
            result2 = 31 * result2 + Boolean.hashCode(this.isShowLibraryContents());
            return result2;
        }
    }
}

