/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.util;

import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.externalSystem.ExternalSystemAutoImportAware;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.service.ParametersEnhancer;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import com.intellij.openapi.externalSystem.util.ArtifactInfo;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.BooleanFunction;
import com.intellij.util.Consumer;
import com.intellij.util.NullableFunction;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.Stack;
import com.intellij.util.containers.TransferToEDTQueue;
import com.intellij.util.lang.UrlClassLoader;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemApiUtil {
    private static final String LAST_USED_PROJECT_PATH_PREFIX = "LAST_EXTERNAL_PROJECT_PATH_";
    @NotNull
    public static final String PATH_SEPARATOR = "/";
    @NotNull
    private static final Pattern ARTIFACT_PATTERN = Pattern.compile("(?:.*/)?(.+?)(?:-([\\d+](?:\\.[\\d]+)*))?(?:\\.[^.]+?)?");
    @NotNull
    public static final Comparator<Object> ORDER_AWARE_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(@NotNull Object o1, @NotNull Object o2) {
            if (o1 == null) {
                1.$$$reportNull$$$0(0);
            }
            if (o2 == null) {
                1.$$$reportNull$$$0(1);
            }
            int order1 = this.getOrder(o1);
            int order2 = this.getOrder(o2);
            return Integer.compare(order1, order2);
        }

        private int getOrder(@NotNull Object o) {
            if (o == null) {
                1.$$$reportNull$$$0(2);
            }
            ArrayDeque toCheck = new ArrayDeque();
            toCheck.add(o.getClass());
            while (!toCheck.isEmpty()) {
                Class clazz = (Class)toCheck.poll();
                Order annotation = clazz.getAnnotation(Order.class);
                if (annotation != null) {
                    return annotation.value();
                }
                Class c = clazz.getSuperclass();
                if (c != null) {
                    toCheck.add(c);
                }
                Class<?>[] interfaces = clazz.getInterfaces();
                Collections.addAll(toCheck, interfaces);
            }
            return 1000;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o2";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compare";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getOrder";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    @NotNull
    private static final NullableFunction<DataNode<?>, Key<?>> GROUPER = node -> node.getKey();
    @NotNull
    private static final TransferToEDTQueue<Runnable> TRANSFER_TO_EDT_QUEUE = new TransferToEDTQueue("External System queue", runnable -> {
        runnable.run();
        return true;
    }, Conditions.alwaysFalse());

    private ExternalSystemApiUtil() {
    }

    @NotNull
    public static String extractNameFromPath(@NotNull String path2) {
        String strippedPath;
        int i;
        if (path2 == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(0);
        }
        String result2 = (i = (strippedPath = ExternalSystemApiUtil.stripPath(path2)).lastIndexOf(PATH_SEPARATOR)) < 0 || i >= strippedPath.length() - 1 ? strippedPath : strippedPath.substring(i + 1);
        String string = result2;
        if (string == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    private static String stripPath(@NotNull String path2) {
        if (path2 == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(2);
        }
        String[] endingsToStrip = new String[]{PATH_SEPARATOR, "!", ".jar"};
        StringBuilder buffer = new StringBuilder(path2);
        for (String ending : endingsToStrip) {
            if (buffer.lastIndexOf(ending) != buffer.length() - ending.length()) continue;
            buffer.setLength(buffer.length() - ending.length());
        }
        String string = buffer.toString();
        if (string == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static String getLibraryName(@NotNull Library library) {
        String result2;
        if (library == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(4);
        }
        if ((result2 = library.getName()) != null) {
            String string = result2;
            if (string == null) {
                ExternalSystemApiUtil.$$$reportNull$$$0(5);
            }
            return string;
        }
        for (OrderRootType type : OrderRootType.getAllTypes()) {
            for (String url : library.getUrls(type)) {
                String candidate = ExternalSystemApiUtil.extractNameFromPath(url);
                if (StringUtil.isEmpty((String)candidate)) continue;
                String string = candidate;
                if (string == null) {
                    ExternalSystemApiUtil.$$$reportNull$$$0(6);
                }
                return string;
            }
        }
        assert (false);
        if ("unknown-lib" == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(7);
        }
        return "unknown-lib";
    }

    public static boolean isRelated(@NotNull Library library, @NotNull LibraryData libraryData) {
        if (library == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(8);
        }
        if (libraryData == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(9);
        }
        return ExternalSystemApiUtil.getLibraryName(library).equals(libraryData.getInternalName());
    }

    public static boolean isExternalSystemLibrary(@NotNull Library library, @NotNull ProjectSystemId externalSystemId) {
        if (library == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(10);
        }
        if (externalSystemId == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(11);
        }
        return library.getName() != null && StringUtil.startsWithIgnoreCase((String)library.getName(), (String)(externalSystemId.getId() + ": "));
    }

    @Nullable
    public static ArtifactInfo parseArtifactInfo(@NotNull String fileName) {
        Matcher matcher;
        if (fileName == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(12);
        }
        if (!(matcher = ARTIFACT_PATTERN.matcher(fileName)).matches()) {
            return null;
        }
        return new ArtifactInfo(matcher.group(1), null, matcher.group(2));
    }

    public static void orderAwareSort(@NotNull List<?> data) {
        if (data == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(13);
        }
        Collections.sort(data, ORDER_AWARE_COMPARATOR);
    }

    @NotNull
    public static String toCanonicalPath(@NotNull String path2) {
        if (path2 == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(14);
        }
        String p = ExternalSystemApiUtil.normalizePath(new File(path2).getAbsolutePath());
        assert (p != null);
        String string = PathUtil.getCanonicalPath(p);
        if (string == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public static String getLocalFileSystemPath(@NotNull VirtualFile file) {
        VirtualFile jar;
        if (file == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(16);
        }
        if (file.getFileType() == FileTypes.ARCHIVE && (jar = JarFileSystem.getInstance().getVirtualFileForJar(file)) != null) {
            String string = jar.getPath();
            if (string == null) {
                ExternalSystemApiUtil.$$$reportNull$$$0(17);
            }
            return string;
        }
        String string = ExternalSystemApiUtil.toCanonicalPath(file.getPath());
        if (string == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Nullable
    public static ExternalSystemManager<?, ?, ?, ?, ?> getManager(@NotNull ProjectSystemId externalSystemId) {
        if (externalSystemId == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(19);
        }
        for (ExternalSystemManager manager : (ExternalSystemManager[])ExternalSystemManager.EP_NAME.getExtensions()) {
            if (!externalSystemId.equals(manager.getSystemId())) continue;
            return manager;
        }
        return null;
    }

    @NotNull
    public static Collection<ExternalSystemManager<?, ?, ?, ?, ?>> getAllManagers() {
        ArrayList result2 = ContainerUtilRt.newArrayList();
        for (ExternalSystemManager manager : (ExternalSystemManager[])ExternalSystemManager.EP_NAME.getExtensions()) {
            result2.add(manager);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    public static MultiMap<Key<?>, DataNode<?>> recursiveGroup(@NotNull Collection<DataNode<?>> nodes) {
        if (nodes == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(21);
        }
        ContainerUtil.KeyOrderedMultiMap result2 = new ContainerUtil.KeyOrderedMultiMap();
        LinkedList queue = ContainerUtil.newLinkedList();
        queue.add(nodes);
        while (!queue.isEmpty()) {
            Collection _nodes = (Collection)queue.remove();
            result2.putAllValues(ExternalSystemApiUtil.group(_nodes));
            for (DataNode _node : _nodes) {
                queue.add(_node.getChildren());
            }
        }
        return result2;
    }

    @NotNull
    public static MultiMap<Key<?>, DataNode<?>> group(@NotNull Collection<DataNode<?>> nodes) {
        if (nodes == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(22);
        }
        MultiMap multiMap = ContainerUtil.groupBy(nodes, GROUPER);
        if (multiMap == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(23);
        }
        return multiMap;
    }

    @NotNull
    public static <K, V> MultiMap<DataNode<K>, DataNode<V>> groupBy(@NotNull Collection<DataNode<V>> nodes, Class<K> moduleDataClass) {
        if (nodes == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(24);
        }
        MultiMap multiMap = ContainerUtil.groupBy(nodes, node -> node.getParent(moduleDataClass));
        if (multiMap == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(25);
        }
        return multiMap;
    }

    @NotNull
    public static <K, V> MultiMap<DataNode<K>, DataNode<V>> groupBy(@NotNull Collection<DataNode<V>> nodes, @NotNull Key<K> key) {
        if (nodes == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(26);
        }
        if (key == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(27);
        }
        MultiMap multiMap = ContainerUtil.groupBy(nodes, node -> {
            if (key == null) {
                ExternalSystemApiUtil.$$$reportNull$$$0(105);
            }
            return node.getDataNode(key);
        });
        if (multiMap == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(28);
        }
        return multiMap;
    }

    @NotNull
    public static <T> Collection<DataNode<T>> getChildren(@NotNull DataNode<?> node, @NotNull Key<T> key) {
        if (node == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(29);
        }
        if (key == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(30);
        }
        ArrayList result2 = null;
        for (DataNode<?> child : node.getChildren()) {
            if (!key.equals(child.getKey())) continue;
            if (result2 == null) {
                result2 = ContainerUtilRt.newArrayList();
            }
            result2.add(child);
        }
        List<DataNode<Object>> list = result2 == null ? Collections.emptyList() : result2;
        if (list == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(31);
        }
        return list;
    }

    @Nullable
    public static <T> DataNode<T> find(@NotNull DataNode<?> node, @NotNull Key<T> key) {
        if (node == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(32);
        }
        if (key == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(33);
        }
        for (DataNode<?> child : node.getChildren()) {
            if (!key.equals(child.getKey())) continue;
            return child;
        }
        return null;
    }

    @Nullable
    public static <T> DataNode<T> find(@NotNull DataNode<?> node, @NotNull Key<T> key, BooleanFunction<DataNode<T>> predicate) {
        if (node == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(34);
        }
        if (key == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(35);
        }
        for (DataNode<?> child : node.getChildren()) {
            if (!key.equals(child.getKey()) || !predicate.fun(child)) continue;
            return child;
        }
        return null;
    }

    @Nullable
    public static <T> DataNode<T> findParent(@NotNull DataNode<?> node, @NotNull Key<T> key) {
        if (node == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(36);
        }
        if (key == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(37);
        }
        return ExternalSystemApiUtil.findParent(node, key, null);
    }

    @Nullable
    public static <T> DataNode<T> findParent(@NotNull DataNode<?> node, @NotNull Key<T> key, @Nullable BooleanFunction<DataNode<T>> predicate) {
        DataNode<?> parent;
        if (node == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(38);
        }
        if (key == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(39);
        }
        if ((parent = node.getParent()) == null) {
            return null;
        }
        return key.equals(parent.getKey()) && (predicate == null || predicate.fun(parent)) ? parent : ExternalSystemApiUtil.findParent(parent, key, predicate);
    }

    @NotNull
    public static <T> Collection<DataNode<T>> findAll(@NotNull DataNode<?> parent, @NotNull Key<T> key) {
        if (parent == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(40);
        }
        if (key == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(41);
        }
        Collection<DataNode<T>> collection = ExternalSystemApiUtil.getChildren(parent, key);
        if (collection == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(42);
        }
        return collection;
    }

    public static void visit(@Nullable DataNode node, @NotNull Consumer<DataNode<?>> consumer) {
        if (consumer == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(43);
        }
        if (node == null) {
            return;
        }
        Stack toProcess = ContainerUtil.newStack((Object[])new DataNode[]{node});
        while (!toProcess.isEmpty()) {
            DataNode node0 = (DataNode)toProcess.pop();
            consumer.consume((Object)node0);
            for (DataNode<?> child : node0.getChildren()) {
                toProcess.push(child);
            }
        }
    }

    @NotNull
    public static <T> Collection<DataNode<T>> findAllRecursively(@Nullable DataNode<?> node, @NotNull Key<T> key) {
        if (key == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(44);
        }
        if (node == null) {
            List<DataNode<T>> list = Collections.emptyList();
            if (list == null) {
                ExternalSystemApiUtil.$$$reportNull$$$0(45);
            }
            return list;
        }
        Collection<DataNode<?>> nodes = ExternalSystemApiUtil.findAllRecursively(node.getChildren(), node1 -> {
            if (key == null) {
                ExternalSystemApiUtil.$$$reportNull$$$0(104);
            }
            return node1.getKey().equals(key);
        });
        SmartList smartList = new SmartList(nodes);
        if (smartList == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(46);
        }
        return smartList;
    }

    @NotNull
    public static Collection<DataNode<?>> findAllRecursively(@NotNull Collection<DataNode<?>> nodes) {
        if (nodes == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(47);
        }
        Collection<DataNode<?>> collection = ExternalSystemApiUtil.findAllRecursively(nodes, null);
        if (collection == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(48);
        }
        return collection;
    }

    @NotNull
    public static Collection<DataNode<?>> findAllRecursively(@Nullable DataNode<?> node, @Nullable BooleanFunction<DataNode<?>> predicate) {
        if (node == null) {
            List<DataNode<?>> list = Collections.emptyList();
            if (list == null) {
                ExternalSystemApiUtil.$$$reportNull$$$0(49);
            }
            return list;
        }
        Collection<DataNode<?>> collection = ExternalSystemApiUtil.findAllRecursively(node.getChildren(), predicate);
        if (collection == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(50);
        }
        return collection;
    }

    @NotNull
    public static Collection<DataNode<?>> findAllRecursively(@NotNull Collection<DataNode<?>> nodes, @Nullable BooleanFunction<DataNode<?>> predicate) {
        if (nodes == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(51);
        }
        SmartList result2 = new SmartList();
        for (DataNode<?> node : nodes) {
            if (predicate != null && !predicate.fun(node)) continue;
            result2.add(node);
        }
        for (DataNode<?> node : nodes) {
            result2.addAll(ExternalSystemApiUtil.findAllRecursively(node.getChildren(), predicate));
        }
        SmartList smartList = result2;
        if (smartList == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(52);
        }
        return smartList;
    }

    @Nullable
    public static DataNode<?> findFirstRecursively(@NotNull DataNode<?> parentNode, @NotNull BooleanFunction<DataNode<?>> predicate) {
        if (parentNode == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(53);
        }
        if (predicate == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(54);
        }
        LinkedList queue = new LinkedList();
        queue.add(parentNode);
        return ExternalSystemApiUtil.findInQueue(queue, predicate);
    }

    @Nullable
    public static DataNode<?> findFirstRecursively(@NotNull Collection<DataNode<?>> nodes, @NotNull BooleanFunction<DataNode<?>> predicate) {
        if (nodes == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(55);
        }
        if (predicate == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(56);
        }
        return ExternalSystemApiUtil.findInQueue(new LinkedList(nodes), predicate);
    }

    @Nullable
    private static DataNode<?> findInQueue(@NotNull Queue<DataNode<?>> queue, @NotNull BooleanFunction<DataNode<?>> predicate) {
        if (queue == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(57);
        }
        if (predicate == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(58);
        }
        while (!queue.isEmpty()) {
            DataNode<?> node = queue.remove();
            if (predicate.fun(node)) {
                return node;
            }
            queue.addAll(node.getChildren());
        }
        return null;
    }

    public static void commitChangedModels(boolean synchronous, Project project, List<Library.ModifiableModel> models) {
        final List changedModels = ContainerUtil.findAll(models, model -> model.isChanged());
        if (!changedModels.isEmpty()) {
            ExternalSystemApiUtil.executeProjectChangeAction(synchronous, new DisposeAwareProjectChange(project){

                @Override
                public void execute() {
                    for (Library.ModifiableModel modifiableModel : changedModels) {
                        modifiableModel.commit();
                    }
                }
            });
        }
    }

    public static void disposeModels(@NotNull Collection<ModifiableRootModel> models) {
        if (models == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(59);
        }
        for (ModifiableRootModel model : models) {
            if (model.isDisposed()) continue;
            model.dispose();
        }
    }

    public static void commitModels(boolean synchronous, Project project, List<ModifiableRootModel> models) {
        final ArrayList changedModels = ContainerUtilRt.newArrayList();
        for (ModifiableRootModel modifiableRootModel : models) {
            if (modifiableRootModel.isDisposed()) continue;
            if (modifiableRootModel.isChanged()) {
                changedModels.add(modifiableRootModel);
                continue;
            }
            modifiableRootModel.dispose();
        }
        if (!changedModels.isEmpty()) {
            ExternalSystemApiUtil.executeProjectChangeAction(synchronous, new DisposeAwareProjectChange(project){

                @Override
                public void execute() {
                    for (ModifiableRootModel modifiableRootModel : changedModels) {
                        if (modifiableRootModel.isDisposed()) continue;
                        modifiableRootModel.commit();
                    }
                }
            });
        }
    }

    public static void executeProjectChangeAction(@NotNull DisposeAwareProjectChange task) {
        if (task == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(60);
        }
        ExternalSystemApiUtil.executeProjectChangeAction(true, task);
    }

    public static void executeProjectChangeAction(boolean synchronous, @NotNull DisposeAwareProjectChange task) {
        if (task == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(61);
        }
        TransactionGuard.getInstance().assertWriteSafeContext(ModalityState.defaultModalityState());
        ExternalSystemApiUtil.executeOnEdt(synchronous, () -> {
            if (task == null) {
                ExternalSystemApiUtil.$$$reportNull$$$0(103);
            }
            ApplicationManager.getApplication().runWriteAction(task);
        });
    }

    public static void executeOnEdt(boolean synchronous, @NotNull Runnable task) {
        Application app;
        if (task == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(62);
        }
        if ((app = ApplicationManager.getApplication()).isDispatchThread()) {
            task.run();
            return;
        }
        if (synchronous) {
            app.invokeAndWait(task);
        } else {
            app.invokeLater(task);
        }
    }

    public static <T> T executeOnEdt(@NotNull Computable<T> task) {
        if (task == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(63);
        }
        Application app = ApplicationManager.getApplication();
        Ref result2 = Ref.create();
        app.invokeAndWait(() -> {
            if (task == null) {
                ExternalSystemApiUtil.$$$reportNull$$$0(102);
            }
            result2.set(task.compute());
        });
        return (T)result2.get();
    }

    public static <T> T doWriteAction(@NotNull Computable<T> task) {
        if (task == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(64);
        }
        return ExternalSystemApiUtil.executeOnEdt(() -> {
            if (task == null) {
                ExternalSystemApiUtil.$$$reportNull$$$0(101);
            }
            return ApplicationManager.getApplication().runWriteAction(task);
        });
    }

    public static void doWriteAction(@NotNull Runnable task) {
        if (task == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(65);
        }
        ExternalSystemApiUtil.executeOnEdt(true, () -> {
            if (task == null) {
                ExternalSystemApiUtil.$$$reportNull$$$0(100);
            }
            ApplicationManager.getApplication().runWriteAction(task);
        });
    }

    public static void addToInvokeLater(Runnable runnable) {
        Application application = ApplicationManager.getApplication();
        boolean unitTestMode = application.isUnitTestMode();
        if (unitTestMode) {
            UIUtil.invokeLaterIfNeeded((Runnable)runnable);
        } else if (application.isHeadlessEnvironment() || application.isDispatchThread()) {
            runnable.run();
        } else {
            TRANSFER_TO_EDT_QUEUE.offer((Object)runnable);
        }
    }

    public static void addBundle(@NotNull PathsList classPath, @NotNull String bundlePath, @NotNull Class<?> contextClass) {
        String root;
        String pathToUse;
        if (classPath == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(66);
        }
        if (bundlePath == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(67);
        }
        if (contextClass == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(68);
        }
        if (!(pathToUse = bundlePath.replace('.', '/')).endsWith(".properties")) {
            pathToUse = pathToUse + ".properties";
        }
        if (!pathToUse.startsWith(PATH_SEPARATOR)) {
            pathToUse = '/' + pathToUse;
        }
        if ((root = PathManager.getResourceRoot(contextClass, (String)pathToUse)) != null) {
            classPath.add(root);
        }
    }

    @Nullable
    public static String normalizePath(@Nullable String s) {
        return StringUtil.isEmpty((String)s) ? null : s.replace('\\', '/');
    }

    public static boolean isOneToOneMapping(@NotNull Project ideProject, @NotNull ProjectData projectData) {
        if (ideProject == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(69);
        }
        if (projectData == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(70);
        }
        String linkedExternalProjectPath = null;
        for (ExternalSystemManager<?, ?, ?, ?, ?> manager : ExternalSystemApiUtil.getAllManagers()) {
            ProjectSystemId externalSystemId = manager.getSystemId();
            AbstractExternalSystemSettings systemSettings = ExternalSystemApiUtil.getSettings(ideProject, externalSystemId);
            Collection projectsSettings = systemSettings.getLinkedProjectsSettings();
            int linkedProjectsNumber = projectsSettings.size();
            if (linkedProjectsNumber > 1) {
                return false;
            }
            if (linkedProjectsNumber != 1) continue;
            if (linkedExternalProjectPath == null) {
                linkedExternalProjectPath = ((ExternalProjectSettings)projectsSettings.iterator().next()).getExternalProjectPath();
                continue;
            }
            return false;
        }
        if (linkedExternalProjectPath != null && !linkedExternalProjectPath.equals(projectData.getLinkedExternalProjectPath())) {
            return false;
        }
        for (Module module : ModuleManager.getInstance(ideProject).getModules()) {
            if (ExternalSystemApiUtil.isExternalSystemAwareModule(projectData.getOwner(), module)) continue;
            return false;
        }
        return true;
    }

    public static void storeLastUsedExternalProjectPath(@Nullable String path2, @NotNull ProjectSystemId externalSystemId) {
        if (externalSystemId == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(71);
        }
        if (path2 != null) {
            PropertiesComponent.getInstance().setValue(LAST_USED_PROJECT_PATH_PREFIX + externalSystemId.getReadableName(), path2);
        }
    }

    @NotNull
    public static String getProjectRepresentationName(@NotNull String targetProjectPath, @Nullable String rootProjectPath) {
        File targetProjectDir;
        if (targetProjectPath == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(72);
        }
        if (rootProjectPath == null) {
            File rootProjectDir = new File(targetProjectPath);
            if (rootProjectDir.isFile()) {
                rootProjectDir = rootProjectDir.getParentFile();
            }
            String string = rootProjectDir.getName();
            if (string == null) {
                ExternalSystemApiUtil.$$$reportNull$$$0(73);
            }
            return string;
        }
        File rootProjectDir = new File(rootProjectPath);
        if (rootProjectDir.isFile()) {
            rootProjectDir = rootProjectDir.getParentFile();
        }
        if ((targetProjectDir = new File(targetProjectPath)).isFile()) {
            targetProjectDir = targetProjectDir.getParentFile();
        }
        StringBuilder buffer = new StringBuilder();
        for (File f = targetProjectDir; f != null && !FileUtil.filesEqual((File)f, (File)rootProjectDir); f = f.getParentFile()) {
            buffer.insert(0, f.getName()).insert(0, ":");
        }
        buffer.insert(0, rootProjectDir.getName());
        String string = buffer.toString();
        if (string == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(74);
        }
        return string;
    }

    @Nullable
    public static String getRootProjectPath(@NotNull String externalProjectPath, @NotNull ProjectSystemId externalSystemId, @NotNull Project project) {
        ExternalSystemManager<?, ?, ?, ?, ?> manager;
        if (externalProjectPath == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(75);
        }
        if (externalSystemId == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(76);
        }
        if (project == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(77);
        }
        if ((manager = ExternalSystemApiUtil.getManager(externalSystemId)) == null) {
            return null;
        }
        if (manager instanceof ExternalSystemAutoImportAware) {
            return ((ExternalSystemAutoImportAware)((Object)manager)).getAffectedExternalProjectPath(externalProjectPath, project);
        }
        return null;
    }

    @NotNull
    public static String buildErrorMessage(@NotNull Throwable e) {
        if (e == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(78);
        }
        Throwable unwrapped = RemoteUtil.unwrap((Throwable)e);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            String string = ExternalSystemApiUtil.stacktraceAsString(unwrapped);
            if (string == null) {
                ExternalSystemApiUtil.$$$reportNull$$$0(79);
            }
            return string;
        }
        String reason = unwrapped.getLocalizedMessage();
        if (!StringUtil.isEmpty((String)reason)) {
            String string = reason;
            if (string == null) {
                ExternalSystemApiUtil.$$$reportNull$$$0(80);
            }
            return string;
        }
        if (unwrapped.getClass() == ExternalSystemException.class) {
            String string = String.format("exception during working with external system: %s", ((ExternalSystemException)unwrapped).getOriginalReason());
            if (string == null) {
                ExternalSystemApiUtil.$$$reportNull$$$0(81);
            }
            return string;
        }
        String string = ExternalSystemApiUtil.stacktraceAsString(unwrapped);
        if (string == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(82);
        }
        return string;
    }

    private static String stacktraceAsString(Throwable unwrapped) {
        StringWriter writer = new StringWriter();
        unwrapped.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    @NotNull
    public static AbstractExternalSystemSettings getSettings(@NotNull Project project, @NotNull ProjectSystemId externalSystemId) throws IllegalArgumentException {
        ExternalSystemManager<?, ?, ?, ?, ?> manager;
        if (project == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(83);
        }
        if (externalSystemId == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(84);
        }
        if ((manager = ExternalSystemApiUtil.getManager(externalSystemId)) == null) {
            throw new IllegalArgumentException(String.format("Can't retrieve external system settings for id '%s'. Reason: no such external system is registered", externalSystemId.getReadableName()));
        }
        AbstractExternalSystemSettings abstractExternalSystemSettings = (AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)project);
        if (abstractExternalSystemSettings == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(85);
        }
        return abstractExternalSystemSettings;
    }

    public static <S extends AbstractExternalSystemLocalSettings> S getLocalSettings(@NotNull Project project, @NotNull ProjectSystemId externalSystemId) throws IllegalArgumentException {
        ExternalSystemManager<?, ?, ?, ?, ?> manager;
        if (project == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(86);
        }
        if (externalSystemId == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(87);
        }
        if ((manager = ExternalSystemApiUtil.getManager(externalSystemId)) == null) {
            throw new IllegalArgumentException(String.format("Can't retrieve local external system settings for id '%s'. Reason: no such external system is registered", externalSystemId.getReadableName()));
        }
        return (S)((AbstractExternalSystemLocalSettings)manager.getLocalSettingsProvider().fun((Object)project));
    }

    public static <S extends ExternalSystemExecutionSettings> S getExecutionSettings(@NotNull Project project, @NotNull String linkedProjectPath, @NotNull ProjectSystemId externalSystemId) throws IllegalArgumentException {
        ExternalSystemManager<?, ?, ?, ?, ?> manager;
        if (project == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(88);
        }
        if (linkedProjectPath == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(89);
        }
        if (externalSystemId == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(90);
        }
        if ((manager = ExternalSystemApiUtil.getManager(externalSystemId)) == null) {
            throw new IllegalArgumentException(String.format("Can't retrieve external system execution settings for id '%s'. Reason: no such external system is registered", externalSystemId.getReadableName()));
        }
        return (S)((ExternalSystemExecutionSettings)manager.getExecutionSettingsProvider().fun((Object)Pair.create((Object)project, (Object)linkedProjectPath)));
    }

    public static boolean isInProcessMode(ProjectSystemId externalSystemId) {
        return Registry.is((String)(externalSystemId.getId() + ".system.in.process"), (boolean)false);
    }

    @NotNull
    public static <T extends ParametersEnhancer> T reloadIfNecessary(final @NotNull Class<T> clazz) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException, ClassNotFoundException {
        if (clazz == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(91);
        }
        ParametersEnhancer instance = (ParametersEnhancer)clazz.newInstance();
        ArrayList urls = ContainerUtilRt.newArrayList();
        instance.enhanceLocalProcessing(urls);
        if (urls.isEmpty()) {
            ParametersEnhancer parametersEnhancer = instance;
            if (parametersEnhancer == null) {
                ExternalSystemApiUtil.$$$reportNull$$$0(92);
            }
            return (T)parametersEnhancer;
        }
        final ClassLoader baseLoader = clazz.getClassLoader();
        Method method = baseLoader.getClass().getMethod("getUrls", new Class[0]);
        if (method != null) {
            urls.addAll((Collection)method.invoke((Object)baseLoader, new Object[0]));
        }
        UrlClassLoader loader = new UrlClassLoader(UrlClassLoader.build().urls((List)urls).parent(baseLoader.getParent())){

            protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                if (name.equals(clazz.getName())) {
                    return super.loadClass(name, resolve);
                }
                try {
                    return baseLoader.loadClass(name);
                }
                catch (ClassNotFoundException e) {
                    return super.loadClass(name, resolve);
                }
            }
        };
        ParametersEnhancer parametersEnhancer = (ParametersEnhancer)loader.loadClass(clazz.getName()).newInstance();
        if (parametersEnhancer == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(93);
        }
        return (T)parametersEnhancer;
    }

    public static ProjectModelExternalSource toExternalSource(@NotNull ProjectSystemId systemId) {
        if (systemId == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(94);
        }
        return ExternalProjectSystemRegistry.getInstance().getSourceById(systemId.getId());
    }

    @Contract(value="_, null -> false", pure=true)
    public static boolean isExternalSystemAwareModule(@NotNull ProjectSystemId systemId, @Nullable Module module) {
        if (systemId == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(95);
        }
        return module != null && !module.isDisposed() && systemId.getId().equals(ExternalSystemModulePropertyManager.getInstance(module).getExternalSystemId());
    }

    @Contract(value="_, null -> false", pure=true)
    public static boolean isExternalSystemAwareModule(@NotNull String systemId, @Nullable Module module) {
        if (systemId == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(96);
        }
        return module != null && !module.isDisposed() && systemId.equals(ExternalSystemModulePropertyManager.getInstance(module).getExternalSystemId());
    }

    @Nullable
    @Contract(pure=true)
    public static String getExternalProjectPath(@Nullable Module module) {
        return module != null && !module.isDisposed() ? ExternalSystemModulePropertyManager.getInstance(module).getLinkedProjectPath() : null;
    }

    @Nullable
    @Contract(pure=true)
    public static String getExternalRootProjectPath(@Nullable Module module) {
        return module != null && !module.isDisposed() ? ExternalSystemModulePropertyManager.getInstance(module).getRootProjectPath() : null;
    }

    @Nullable
    @Contract(pure=true)
    public static String getExternalProjectId(@Nullable Module module) {
        return module != null && !module.isDisposed() ? ExternalSystemModulePropertyManager.getInstance(module).getLinkedProjectId() : null;
    }

    @Nullable
    @Contract(pure=true)
    public static String getExternalProjectGroup(@Nullable Module module) {
        return module != null && !module.isDisposed() ? ExternalSystemModulePropertyManager.getInstance(module).getExternalModuleGroup() : null;
    }

    @Nullable
    @Contract(pure=true)
    public static String getExternalProjectVersion(@Nullable Module module) {
        return module != null && !module.isDisposed() ? ExternalSystemModulePropertyManager.getInstance(module).getExternalModuleVersion() : null;
    }

    @Nullable
    @Contract(pure=true)
    public static String getExternalModuleType(@Nullable Module module) {
        return module != null && !module.isDisposed() ? ExternalSystemModulePropertyManager.getInstance(module).getExternalModuleType() : null;
    }

    public static void subscribe(@NotNull Project project, @NotNull ProjectSystemId systemId, @NotNull ExternalSystemSettingsListener listener) {
        if (project == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(97);
        }
        if (systemId == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(98);
        }
        if (listener == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(99);
        }
        ExternalSystemApiUtil.getSettings(project, systemId).subscribe(listener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 23: 
            case 25: 
            case 28: 
            case 31: 
            case 42: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 73: 
            case 74: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 85: 
            case 92: 
            case 93: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 23: 
            case 25: 
            case 28: 
            case 31: 
            case 42: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 73: 
            case 74: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 85: 
            case 92: 
            case 93: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 23: 
            case 25: 
            case 28: 
            case 31: 
            case 42: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 73: 
            case 74: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 85: 
            case 92: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil";
                break;
            }
            case 4: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryData";
                break;
            }
            case 11: 
            case 19: 
            case 71: 
            case 76: 
            case 84: 
            case 87: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 47: 
            case 51: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 27: 
            case 30: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 44: 
            case 104: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 54: 
            case 56: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classPath";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundlePath";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextClass";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideProject";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectData";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetProjectPath";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectPath";
                break;
            }
            case 77: 
            case 83: 
            case 86: 
            case 88: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkedProjectPath";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 94: 
            case 95: 
            case 96: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemId";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "extractNameFromPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "stripPath";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "toCanonicalPath";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalFileSystemPath";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllManagers";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "group";
                break;
            }
            case 25: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "groupBy";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "findAll";
                break;
            }
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllRecursively";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectRepresentationName";
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorMessage";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "reloadIfNecessary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractNameFromPath";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 23: 
            case 25: 
            case 28: 
            case 31: 
            case 42: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 73: 
            case 74: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 85: 
            case 92: 
            case 93: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "stripPath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isRelated";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isExternalSystemLibrary";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parseArtifactInfo";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "orderAwareSort";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "toCanonicalPath";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getLocalFileSystemPath";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getManager";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "recursiveGroup";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "group";
                break;
            }
            case 24: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "groupBy";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "findParent";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "findAll";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "visit";
                break;
            }
            case 44: 
            case 47: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "findAllRecursively";
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "findFirstRecursively";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "findInQueue";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "disposeModels";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "executeProjectChangeAction";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "executeOnEdt";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "doWriteAction";
                break;
            }
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "addBundle";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "isOneToOneMapping";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "storeLastUsedExternalProjectPath";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getProjectRepresentationName";
                break;
            }
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "getRootProjectPath";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "buildErrorMessage";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "getSettings";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "getLocalSettings";
                break;
            }
            case 88: 
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "getExecutionSettings";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "reloadIfNecessary";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "toExternalSource";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "isExternalSystemAwareModule";
                break;
            }
            case 97: 
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "subscribe";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doWriteAction$9";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doWriteAction$8";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "lambda$executeOnEdt$7";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "lambda$executeProjectChangeAction$6";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findAllRecursively$4";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "lambda$groupBy$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 23: 
            case 25: 
            case 28: 
            case 31: 
            case 42: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 73: 
            case 74: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 85: 
            case 92: 
            case 93: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

