/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleRootModificationUtil {
    public static void addContentRoot(@NotNull Module module, @NotNull String path2) {
        if (module == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(0);
        }
        if (path2 == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(1);
        }
        ModuleRootModificationUtil.updateModel(module, (Consumer<ModifiableRootModel>)((Consumer)model -> {
            if (path2 == null) {
                ModuleRootModificationUtil.$$$reportNull$$$0(54);
            }
            model.addContentEntry(VfsUtilCore.pathToUrl(path2));
        }));
    }

    public static void addContentRoot(@NotNull Module module, @NotNull VirtualFile path2) {
        if (module == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(2);
        }
        if (path2 == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(3);
        }
        ModuleRootModificationUtil.updateModel(module, (Consumer<ModifiableRootModel>)((Consumer)model -> {
            if (path2 == null) {
                ModuleRootModificationUtil.$$$reportNull$$$0(53);
            }
            model.addContentEntry(path2);
        }));
    }

    public static void addModuleLibrary(@NotNull Module module, @Nullable String libName, @NotNull List<String> classesRoots, @NotNull List<String> sourceRoots) {
        if (module == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(4);
        }
        if (classesRoots == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(5);
        }
        if (sourceRoots == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(6);
        }
        ModuleRootModificationUtil.addModuleLibrary(module, libName, classesRoots, sourceRoots, DependencyScope.COMPILE);
    }

    public static void addModuleLibrary(@NotNull Module module, @Nullable String libName, @NotNull List<String> classesRoots, @NotNull List<String> sourceRoots, @NotNull DependencyScope scope) {
        if (module == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(7);
        }
        if (classesRoots == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(8);
        }
        if (sourceRoots == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(9);
        }
        if (scope == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(10);
        }
        ModuleRootModificationUtil.addModuleLibrary(module, libName, classesRoots, sourceRoots, Collections.emptyList(), scope);
    }

    public static void addModuleLibrary(@NotNull Module module, @Nullable String libName, @NotNull List<String> classesRoots, @NotNull List<String> sourceRoots, @NotNull List<String> excludedRoots, @NotNull DependencyScope scope) {
        if (module == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(11);
        }
        if (classesRoots == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(12);
        }
        if (sourceRoots == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(13);
        }
        if (excludedRoots == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(14);
        }
        if (scope == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(15);
        }
        ModuleRootModificationUtil.addModuleLibrary(module, libName, classesRoots, sourceRoots, excludedRoots, scope, false);
    }

    public static void addModuleLibrary(@NotNull Module module, @Nullable String libName, @NotNull List<String> classesRoots, @NotNull List<String> sourceRoots, @NotNull List<String> excludedRoots, @NotNull DependencyScope scope, boolean exported) {
        if (module == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(16);
        }
        if (classesRoots == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(17);
        }
        if (sourceRoots == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(18);
        }
        if (excludedRoots == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(19);
        }
        if (scope == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(20);
        }
        ModuleRootModificationUtil.updateModel(module, (Consumer<ModifiableRootModel>)((Consumer)model -> {
            if (classesRoots == null) {
                ModuleRootModificationUtil.$$$reportNull$$$0(49);
            }
            if (sourceRoots == null) {
                ModuleRootModificationUtil.$$$reportNull$$$0(50);
            }
            if (excludedRoots == null) {
                ModuleRootModificationUtil.$$$reportNull$$$0(51);
            }
            if (scope == null) {
                ModuleRootModificationUtil.$$$reportNull$$$0(52);
            }
            LibraryEx library = (LibraryEx)model.getModuleLibraryTable().createLibrary(libName);
            LibraryEx.ModifiableModelEx libraryModel = library.getModifiableModel();
            for (String root : classesRoots) {
                libraryModel.addRoot(root, OrderRootType.CLASSES);
            }
            for (String root : sourceRoots) {
                libraryModel.addRoot(root, OrderRootType.SOURCES);
            }
            for (String excluded : excludedRoots) {
                libraryModel.addExcludedRoot(excluded);
            }
            LibraryOrderEntry entry = model.findLibraryOrderEntry(library);
            assert (entry != null) : library;
            entry.setScope(scope);
            entry.setExported(exported);
            ApplicationManager.getApplication().invokeAndWait(() -> WriteAction.run(libraryModel::commit));
        }));
    }

    public static void addModuleLibrary(@NotNull Module module, @NotNull String classesRootUrl) {
        if (module == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(21);
        }
        if (classesRootUrl == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(22);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && classesRootUrl.endsWith(".jar")) assert (false) : "jar file is expected, local file is used";
        ModuleRootModificationUtil.addModuleLibrary(module, null, Collections.singletonList(classesRootUrl), Collections.emptyList());
    }

    public static void addDependency(@NotNull Module module, @NotNull Library library) {
        if (module == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(23);
        }
        if (library == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(24);
        }
        ModuleRootModificationUtil.addDependency(module, library, DependencyScope.COMPILE, false);
    }

    public static void addDependency(@NotNull Module module, @NotNull Library library, @NotNull DependencyScope scope, boolean exported) {
        if (module == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(25);
        }
        if (library == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(26);
        }
        if (scope == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(27);
        }
        ModuleRootModificationUtil.updateModel(module, (Consumer<ModifiableRootModel>)((Consumer)model -> {
            if (library == null) {
                ModuleRootModificationUtil.$$$reportNull$$$0(47);
            }
            if (scope == null) {
                ModuleRootModificationUtil.$$$reportNull$$$0(48);
            }
            LibraryOrderEntry entry = model.addLibraryEntry(library);
            entry.setExported(exported);
            entry.setScope(scope);
        }));
    }

    public static void setModuleSdk(@NotNull Module module, @Nullable Sdk sdk) {
        if (module == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(28);
        }
        ModuleRootModificationUtil.updateModel(module, (Consumer<ModifiableRootModel>)((Consumer)model -> model.setSdk(sdk)));
    }

    public static void setSdkInherited(@NotNull Module module) {
        if (module == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(29);
        }
        ModuleRootModificationUtil.updateModel(module, (Consumer<ModifiableRootModel>)((Consumer)model -> model.inheritSdk()));
    }

    public static void addDependency(@NotNull Module from, @NotNull Module to) {
        if (from == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(30);
        }
        if (to == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(31);
        }
        ModuleRootModificationUtil.addDependency(from, to, DependencyScope.COMPILE, false);
    }

    public static void addDependency(@NotNull Module from, @NotNull Module to, @NotNull DependencyScope scope, boolean exported) {
        if (from == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(32);
        }
        if (to == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(33);
        }
        if (scope == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(34);
        }
        ModuleRootModificationUtil.updateModel(from, (Consumer<ModifiableRootModel>)((Consumer)model -> {
            if (to == null) {
                ModuleRootModificationUtil.$$$reportNull$$$0(45);
            }
            if (scope == null) {
                ModuleRootModificationUtil.$$$reportNull$$$0(46);
            }
            ModuleOrderEntry entry = model.addModuleOrderEntry(to);
            entry.setScope(scope);
            entry.setExported(exported);
        }));
    }

    public static void updateModel(@NotNull Module module, @NotNull Consumer<ModifiableRootModel> task) {
        if (module == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(35);
        }
        if (task == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(36);
        }
        ModifiableRootModel model = (ModifiableRootModel)ReadAction.compute(() -> {
            if (module == null) {
                ModuleRootModificationUtil.$$$reportNull$$$0(44);
            }
            return ModuleRootManager.getInstance(module).getModifiableModel();
        });
        try {
            task.consume((Object)model);
            ApplicationManager.getApplication().invokeAndWait(() -> WriteAction.run(model::commit));
        }
        finally {
            if (!model.isDisposed()) {
                model.dispose();
            }
        }
    }

    public static void updateExcludedFolders(@NotNull Module module, @NotNull VirtualFile contentRoot, @NotNull Collection<String> urlsToUnExclude, @NotNull Collection<String> urlsToExclude) {
        if (module == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(37);
        }
        if (contentRoot == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(38);
        }
        if (urlsToUnExclude == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(39);
        }
        if (urlsToExclude == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(40);
        }
        ModuleRootModificationUtil.updateModel(module, (Consumer<ModifiableRootModel>)((Consumer)modifiableModel -> {
            if (contentRoot == null) {
                ModuleRootModificationUtil.$$$reportNull$$$0(41);
            }
            if (urlsToUnExclude == null) {
                ModuleRootModificationUtil.$$$reportNull$$$0(42);
            }
            if (urlsToExclude == null) {
                ModuleRootModificationUtil.$$$reportNull$$$0(43);
            }
            for (ContentEntry contentEntry : modifiableModel.getContentEntries()) {
                if (!contentRoot.equals(contentEntry.getFile())) continue;
                for (String url : urlsToUnExclude) {
                    contentEntry.removeExcludeFolder(url);
                }
                for (String url : urlsToExclude) {
                    contentEntry.addExcludeFolder(url);
                }
                break;
            }
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: 
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: 
            case 8: 
            case 12: 
            case 17: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesRoots";
                break;
            }
            case 6: 
            case 9: 
            case 13: 
            case 18: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRoots";
                break;
            }
            case 10: 
            case 15: 
            case 20: 
            case 27: 
            case 34: 
            case 46: 
            case 48: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 14: 
            case 19: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedRoots";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesRootUrl";
                break;
            }
            case 24: 
            case 26: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 31: 
            case 33: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRoot";
                break;
            }
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlsToUnExclude";
                break;
            }
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlsToExclude";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/ModuleRootModificationUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addContentRoot";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "addModuleLibrary";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[2] = "addDependency";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "setModuleSdk";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "setSdkInherited";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[2] = "updateModel";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[2] = "updateExcludedFolders";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$updateExcludedFolders$10";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$updateModel$8";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$addDependency$7";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$addDependency$4";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$addModuleLibrary$3";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$addContentRoot$1";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$addContentRoot$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

