/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.PairConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AsyncResult<T>
extends ActionCallback {
    private static final Logger LOG = Logger.getInstance(AsyncResult.class);
    protected T myResult;

    public AsyncResult() {
    }

    AsyncResult(int countToDone, @Nullable T result2) {
        super(countToDone);
        this.myResult = result2;
    }

    @NotNull
    public AsyncResult<T> setDone(T result2) {
        this.myResult = result2;
        this.setDone();
        AsyncResult asyncResult = this;
        if (asyncResult == null) {
            AsyncResult.$$$reportNull$$$0(0);
        }
        return asyncResult;
    }

    @NotNull
    public AsyncResult<T> setRejected(T result2) {
        this.myResult = result2;
        this.setRejected();
        AsyncResult asyncResult = this;
        if (asyncResult == null) {
            AsyncResult.$$$reportNull$$$0(1);
        }
        return asyncResult;
    }

    @NotNull
    public <DependentResult> AsyncResult<DependentResult> subResult(@NotNull Function<T, DependentResult> doneHandler) {
        if (doneHandler == null) {
            AsyncResult.$$$reportNull$$$0(2);
        }
        AsyncResult<T> asyncResult = this.subResult(new AsyncResult<T>(), doneHandler);
        if (asyncResult == null) {
            AsyncResult.$$$reportNull$$$0(3);
        }
        return asyncResult;
    }

    @NotNull
    public <SubResult, SubAsyncResult extends AsyncResult<SubResult>> SubAsyncResult subResult(@NotNull SubAsyncResult subResult, @NotNull Function<T, SubResult> doneHandler) {
        if (subResult == null) {
            AsyncResult.$$$reportNull$$$0(4);
        }
        if (doneHandler == null) {
            AsyncResult.$$$reportNull$$$0(5);
        }
        this.doWhenDone(new SubResultDoneCallback<T, SubResult, SubAsyncResult>(subResult, doneHandler)).notifyWhenRejected(subResult);
        SubAsyncResult SubAsyncResult = subResult;
        if (SubAsyncResult == null) {
            AsyncResult.$$$reportNull$$$0(6);
        }
        return SubAsyncResult;
    }

    @Deprecated
    @NotNull
    public AsyncResult<T> doWhenDone(@NotNull Handler<T> handler) {
        if (handler == null) {
            AsyncResult.$$$reportNull$$$0(7);
        }
        this.doWhenDone(() -> {
            if (handler == null) {
                AsyncResult.$$$reportNull$$$0(24);
            }
            handler.run(this.myResult);
        });
        AsyncResult asyncResult = this;
        if (asyncResult == null) {
            AsyncResult.$$$reportNull$$$0(8);
        }
        return asyncResult;
    }

    @NotNull
    public AsyncResult<T> doWhenDone(@NotNull Consumer<T> consumer) {
        if (consumer == null) {
            AsyncResult.$$$reportNull$$$0(9);
        }
        this.doWhenDone(() -> {
            if (consumer == null) {
                AsyncResult.$$$reportNull$$$0(23);
            }
            consumer.consume(this.myResult);
        });
        AsyncResult asyncResult = this;
        if (asyncResult == null) {
            AsyncResult.$$$reportNull$$$0(10);
        }
        return asyncResult;
    }

    @NotNull
    public AsyncResult<T> doWhenRejected(@NotNull PairConsumer<T, String> consumer) {
        if (consumer == null) {
            AsyncResult.$$$reportNull$$$0(11);
        }
        this.doWhenRejected(() -> {
            if (consumer == null) {
                AsyncResult.$$$reportNull$$$0(22);
            }
            consumer.consume(this.myResult, (Object)this.myError);
        });
        AsyncResult asyncResult = this;
        if (asyncResult == null) {
            AsyncResult.$$$reportNull$$$0(12);
        }
        return asyncResult;
    }

    @Override
    @NotNull
    public final AsyncResult<T> notify(@NotNull ActionCallback child) {
        if (child == null) {
            AsyncResult.$$$reportNull$$$0(13);
        }
        super.notify(child);
        AsyncResult asyncResult = this;
        if (asyncResult == null) {
            AsyncResult.$$$reportNull$$$0(14);
        }
        return asyncResult;
    }

    public T getResult() {
        return this.myResult;
    }

    public T getResultSync() {
        return this.getResultSync(-1L);
    }

    @Nullable
    public T getResultSync(long msTimeout) {
        this.waitFor(msTimeout);
        return this.myResult;
    }

    @NotNull
    public final ActionCallback doWhenProcessed(@NotNull Consumer<T> consumer) {
        if (consumer == null) {
            AsyncResult.$$$reportNull$$$0(15);
        }
        this.doWhenDone(consumer);
        this.doWhenRejected((result2, error) -> {
            if (consumer == null) {
                AsyncResult.$$$reportNull$$$0(21);
            }
            consumer.consume(result2);
        });
        AsyncResult asyncResult = this;
        if (asyncResult == null) {
            AsyncResult.$$$reportNull$$$0(16);
        }
        return asyncResult;
    }

    @Deprecated
    @NotNull
    public static <R> AsyncResult<R> rejected() {
        Rejected rejected2 = new Rejected();
        if (rejected2 == null) {
            AsyncResult.$$$reportNull$$$0(17);
        }
        return rejected2;
    }

    @Deprecated
    @NotNull
    public static <R> AsyncResult<R> rejected(@NotNull String errorMessage) {
        if (errorMessage == null) {
            AsyncResult.$$$reportNull$$$0(18);
        }
        AsyncResult result2 = new AsyncResult();
        result2.reject(errorMessage);
        AsyncResult asyncResult = result2;
        if (asyncResult == null) {
            AsyncResult.$$$reportNull$$$0(19);
        }
        return asyncResult;
    }

    @NotNull
    public static <R> AsyncResult<R> done(@Nullable R result2) {
        AsyncResult asyncResult = new AsyncResult<R>().setDone(result2);
        if (asyncResult == null) {
            AsyncResult.$$$reportNull$$$0(20);
        }
        return asyncResult;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/AsyncResult";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doneHandler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subResult";
                break;
            }
            case 7: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 9: 
            case 11: 
            case 15: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "setDone";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "setRejected";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/AsyncResult";
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "subResult";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "doWhenDone";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "doWhenRejected";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "notify";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "doWhenProcessed";
                break;
            }
            case 17: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "rejected";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "done";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "subResult";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doWhenDone";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doWhenRejected";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "notify";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doWhenProcessed";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "rejected";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doWhenProcessed$3";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doWhenRejected$2";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doWhenDone$1";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doWhenDone$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SubResultDoneCallback<Result, SubResult, AsyncSubResult extends AsyncResult<SubResult>>
    implements Consumer<Result> {
        private final AsyncSubResult subResult;
        private final Function<Result, SubResult> doneHandler;

        public SubResultDoneCallback(AsyncSubResult subResult, Function<Result, SubResult> doneHandler) {
            this.subResult = subResult;
            this.doneHandler = doneHandler;
        }

        public void consume(Result result2) {
            Object v;
            try {
                v = this.doneHandler.fun(result2);
            }
            catch (Throwable e) {
                ((ActionCallback)this.subResult).reject(e.getMessage());
                LOG.error(e);
                return;
            }
            ((AsyncResult)this.subResult).setDone((Object)v);
        }
    }

    @Deprecated
    public static class Rejected<T>
    extends AsyncResult<T> {
        public Rejected() {
            this.setRejected();
        }

        public Rejected(T value) {
            this.setRejected(value);
        }
    }

    @Deprecated
    public static class Done<T>
    extends AsyncResult<T> {
        public Done(T value) {
            this.setDone(value);
        }
    }

    @Deprecated
    public static interface Handler<T> {
        public void run(T var1);
    }
}

