/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.appServerIntegrations;

import com.intellij.CommonBundle;
import com.intellij.ide.DataManager;
import com.intellij.j2ee.appServerIntegrations.ApplicationServerConfigurable;
import com.intellij.j2ee.appServerIntegrations.ApplicationServersModelProvider;
import com.intellij.j2ee.appServerIntegrations.ApplicationServersUtil;
import com.intellij.j2ee.appServerIntegrations.impl.ApplicationServerImpl;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.openapi.ex.AppServerIntegrationsManager;
import com.intellij.javaee.serverInstances.ApplicationServersManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.UserActivityListener;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppServerDKsEditor
implements ApplicationServersModelProvider {
    private final ApplicationServer mySelected;
    private final JBList myServerDKs = new JBList();
    private final CardLayout myCardLayout = new CardLayout();
    private final JPanel myConfigurablePanel = new JPanel(this.myCardLayout);
    private final Map<ApplicationServer, Pair<ApplicationServerConfigurable, String>> mySKDToConfigurableMap = new HashMap<ApplicationServer, Pair<ApplicationServerConfigurable, String>>();
    private final Set<ApplicationServer> myInitialServers = new HashSet<ApplicationServer>();
    private ApplicationServersManager.ApplicationServersManagerModifiableModel myModifiableModel;
    private int myNextId = 0;
    private final AppServerIntegration[] myIntegrations;
    private final Splitter mySplitter = new JBSplitter("AppServerDKsEditor.splitterProportion", 0.3f);
    private ApplicationServer myCurrentSelection;
    private final UserActivityWatcher myUserActivityWatcher = new UserActivityWatcher();
    @NonNls
    protected static final String EMPTY_PANEL_PLACE = "empty";

    public AppServerDKsEditor(AppServerIntegration[] integrations, ApplicationServer selected) {
        this.myIntegrations = integrations;
        this.mySelected = selected;
        this.myServerDKs.setSelectionMode(0);
        this.myServerDKs.getSelectionModel().addListSelectionListener(new MyListSelectionListener());
        this.myServerDKs.getEmptyText().setText(J2EEBundle.message((String)"not.configured", (Object[])new Object[0]));
        JPanel listPanel = this.createWestPanel();
        this.mySplitter.setHonorComponentsMinimumSize(true);
        this.mySplitter.setFirstComponent((JComponent)listPanel);
        this.mySplitter.setSecondComponent((JComponent)this.myConfigurablePanel);
        this.mySplitter.setPreferredSize((Dimension)JBUI.size((int)400, (int)200));
        this.trySelectElementAt(0);
        this.myUserActivityWatcher.addUserActivityListener(new UserActivityListener(){

            public void stateChanged() {
                AppServerDKsEditor.this.myServerDKs.repaint();
            }
        });
    }

    private JPanel createWestPanel() {
        ToolbarDecorator listDecorator = ToolbarDecorator.createDecorator((JList)this.myServerDKs);
        listDecorator.disableUpDownActions();
        listDecorator.setAsUsualTopToolbar();
        listDecorator.setAddActionName(J2EEBundle.message((String)"action.description.add.application.server", (Object[])new Object[0]));
        listDecorator.setAddAction(this.createAddAction());
        listDecorator.setRemoveActionName(J2EEBundle.message((String)"action.description.remove.application.server", (Object[])new Object[0]));
        listDecorator.setRemoveAction((AnActionButtonRunnable)new MyRemoveAction());
        JPanel listPanel = listDecorator.createPanel();
        listPanel.setMinimumSize((Dimension)JBUI.size((int)50, (int)70));
        this.myServerDKs.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer(){

            protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    2.$$$reportNull$$$0(0);
                }
                ApplicationServer applicationServer = (ApplicationServer)value;
                this.append(AppServerDKsEditor.this.myModifiableModel.getLibrary(applicationServer).getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/j2ee/appServerIntegrations/AppServerDKsEditor$2", "customizeCellRenderer"));
            }
        });
        return listPanel;
    }

    private AnActionButtonRunnable createAddAction() {
        List<AddAction> addActions = this.createAllAddActions();
        return addActions.size() == 1 ? new ActionWrapper(addActions.get(0)) : new MultipleAddAction(addActions);
    }

    private List<AddAction> createAllAddActions() {
        ArrayList<AddAction> result = new ArrayList<AddAction>();
        for (AppServerIntegration integration : this.myIntegrations) {
            result.add(new AddAction(integration));
        }
        Collections.sort(result, (o1, o2) -> ((AddAction)o1).myIntegration.getPresentableName().compareToIgnoreCase(((AddAction)o2).myIntegration.getPresentableName()));
        return result;
    }

    public void reset() {
        this.mySKDToConfigurableMap.clear();
        this.myModifiableModel = this.createNewModifiableModel();
        this.refreshList();
        if (this.myServerDKs.getModel().getSize() > 0) {
            if (this.mySelected != null) {
                this.selectElementInList(((DefaultListModel)this.myServerDKs.getModel()).indexOf(this.mySelected));
            } else {
                this.selectElementInList(0);
            }
        }
    }

    private void refreshList() {
        this.myConfigurablePanel.removeAll();
        JLabel label = new JLabel(J2EEBundle.message((String)"label.text.no.application.server.selected", (Object[])new Object[0]));
        label.setHorizontalAlignment(0);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.myConfigurablePanel.add((Component)panel, EMPTY_PANEL_PLACE);
        DefaultListModel<ApplicationServerImpl> model = new DefaultListModel<ApplicationServerImpl>();
        this.myServerDKs.setModel(model);
        this.myServerDKs.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                ApplicationServer appServer = (ApplicationServer)value;
                Pair pair = (Pair)AppServerDKsEditor.this.mySKDToConfigurableMap.get(appServer);
                if (pair != null) {
                    value = ((ApplicationServerConfigurable)pair.getFirst()).getCurrentServerName();
                }
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        });
        ArrayList<ApplicationServer> allDKs = new ArrayList<ApplicationServer>(this.myModifiableModel.getCurrentList(this.myIntegrations));
        ApplicationServersUtil.sortByName(allDKs);
        for (ApplicationServer allDK : allDKs) {
            String uniqueId;
            ApplicationServerConfigurable configurable;
            ApplicationServerImpl applicationServer = (ApplicationServerImpl)allDK;
            Pair<ApplicationServerConfigurable, String> oldPair = this.mySKDToConfigurableMap.put(applicationServer, (Pair<ApplicationServerConfigurable, String>)Pair.create((Object)(configurable = applicationServer.createConfigurable(this)), (Object)(uniqueId = this.createUniqueId())));
            if (oldPair != null) {
                ((ApplicationServerConfigurable)oldPair.getFirst()).disposeUIResources();
            }
            JComponent component = configurable.createComponent();
            this.myConfigurablePanel.add((Component)component, uniqueId);
            this.myUserActivityWatcher.register((Component)component);
            configurable.reset();
            model.addElement(applicationServer);
        }
    }

    private String createUniqueId() {
        return String.valueOf(this.myNextId++);
    }

    private ApplicationServersManager.ApplicationServersManagerModifiableModel createNewModifiableModel() {
        ApplicationServersManager.ApplicationServersManagerModifiableModel modifiableModel = ApplicationServersManager.getInstance().createModifiableModel();
        this.myInitialServers.clear();
        this.myInitialServers.addAll(modifiableModel.getCurrentList(this.myIntegrations));
        return modifiableModel;
    }

    public void disposeUIResources() {
        if (this.myModifiableModel != null) {
            this.myModifiableModel.dispose();
        }
        for (ApplicationServer applicationServer : this.mySKDToConfigurableMap.keySet()) {
            ((ApplicationServerConfigurable)this.mySKDToConfigurableMap.get(applicationServer).getFirst()).disposeUIResources();
        }
        this.mySKDToConfigurableMap.clear();
    }

    public JComponent getComponent() {
        return this.mySplitter;
    }

    @Nullable
    private ApplicationServer getCurrentSelection() {
        int selectionIndex = this.myServerDKs.getSelectionModel().getMinSelectionIndex();
        if (selectionIndex == -1) {
            return null;
        }
        return (ApplicationServer)this.myServerDKs.getModel().getElementAt(selectionIndex);
    }

    private void selectElementAt(int selectedIndex) {
        this.myCurrentSelection = (ApplicationServer)this.myServerDKs.getModel().getElementAt(selectedIndex);
        Pair<ApplicationServerConfigurable, String> pair = this.mySKDToConfigurableMap.get(this.myCurrentSelection);
        if (pair != null) {
            this.myCardLayout.show(this.myConfigurablePanel, (String)pair.getSecond());
        }
        UIUtil.setupEnclosingDialogBounds((JComponent)this.mySplitter);
    }

    private List<ApplicationServer> collectNewServerDKs() {
        ArrayList<ApplicationServer> newServerDKs = new ArrayList<ApplicationServer>();
        ListModel model = this.myServerDKs.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            newServerDKs.add((ApplicationServer)model.getElementAt(i));
        }
        return newServerDKs;
    }

    private void selectServerElement(ApplicationServerImpl newServer) {
        ListModel model = this.myServerDKs.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            if (!newServer.equals(model.getElementAt(i))) continue;
            this.selectElementInList(i);
            return;
        }
        this.trySelectElementAt(model.getSize() - 1);
    }

    public ApplicationServer getSelectedAppliactionServer() {
        return this.myCurrentSelection;
    }

    public boolean isModified() {
        if (!this.myInitialServers.equals(this.mySKDToConfigurableMap.keySet())) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                System.out.println("myInitialServers: " + this.myInitialServers);
                System.out.println("mySKDToConfigurableMap: " + this.mySKDToConfigurableMap);
            }
            return true;
        }
        for (Pair<ApplicationServerConfigurable, String> pair : this.mySKDToConfigurableMap.values()) {
            if (!((ApplicationServerConfigurable)pair.getFirst()).isModified()) continue;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                System.out.println("Modified: " + pair);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply() throws ConfigurationException {
        this.checkServersNames();
        try {
            for (ApplicationServer applicationServer : this.mySKDToConfigurableMap.keySet()) {
                Pair<ApplicationServerConfigurable, String> pair = this.mySKDToConfigurableMap.get(applicationServer);
                ((ApplicationServerConfigurable)pair.getFirst()).apply();
            }
            ApplicationManager.getApplication().runWriteAction(() -> this.myModifiableModel.commit());
        }
        finally {
            this.myModifiableModel = this.createNewModifiableModel();
        }
    }

    private void checkServersNames() throws ConfigurationException {
        AppServerIntegration[] allIntegrations = AppServerIntegrationsManager.getInstance().getAllIntegrations();
        List servers = this.myModifiableModel.getCurrentList(allIntegrations);
        HashSet<String> names = new HashSet<String>();
        for (ApplicationServer server : servers) {
            String name;
            Pair<ApplicationServerConfigurable, String> pair = this.mySKDToConfigurableMap.get(server);
            if (pair != null) {
                name = ((ApplicationServerConfigurable)pair.getFirst()).getCurrentServerName();
                if (StringUtil.isEmptyOrSpaces((String)name)) {
                    throw new ConfigurationException(J2EEBundle.message((String)"message.text.application.server.name.cannot.be.empty", (Object[])new Object[0]), CommonBundle.getErrorTitle());
                }
            } else {
                name = server.getName();
            }
            if (names.contains(name)) {
                throw new ConfigurationException(J2EEBundle.message((String)"message.text.application.server.already.exists", (Object[])new Object[]{name}), CommonBundle.getErrorTitle());
            }
            names.add(name);
        }
    }

    private void trySelectElementAt(int prevSelection) {
        int size = this.myServerDKs.getModel().getSize();
        if (size == 0) {
            return;
        }
        if (prevSelection > size - 1) {
            int selectedElement = size - 1;
            this.selectElementInList(selectedElement);
        } else {
            this.selectElementInList(prevSelection);
        }
    }

    private void selectElementInList(int selectedElement) {
        this.myServerDKs.getSelectionModel().setSelectionInterval(selectedElement, selectedElement);
    }

    @Override
    public ApplicationServersManager.ApplicationServersManagerModifiableModel getApplicationServersModel() {
        return this.myModifiableModel;
    }

    private static class MultipleAddAction
    implements AnActionButtonRunnable {
        private final List<AddAction> myActions;

        public MultipleAddAction(List<AddAction> actions) {
            this.myActions = actions;
        }

        public void run(AnActionButton button) {
            DefaultActionGroup group = new DefaultActionGroup();
            for (AnAction anAction : this.myActions) {
                group.add(anAction);
            }
            JBPopupFactory popupFactory = JBPopupFactory.getInstance();
            ListPopup listPopup = popupFactory.createActionGroupPopup(J2EEBundle.message((String)"action.description.add.application.server", (Object[])new Object[0]), (ActionGroup)group, DataManager.getInstance().getDataContext((Component)button.getContextComponent()), false, false, false, null, -1, Conditions.alwaysTrue());
            listPopup.show(button.getPreferredPopupPoint());
        }
    }

    private static class ActionWrapper
    implements AnActionButtonRunnable {
        private final AddAction myAction;

        public ActionWrapper(AddAction action) {
            this.myAction = action;
        }

        public void run(AnActionButton button) {
            this.myAction.actionPerformed(null);
        }
    }

    private class MyListSelectionListener
    implements ListSelectionListener {
        private MyListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int selectedIndex = AppServerDKsEditor.this.myServerDKs.getSelectionModel().getMinSelectionIndex();
            if (selectedIndex == -1 || AppServerDKsEditor.this.myServerDKs.getModel().getSize() <= selectedIndex) {
                return;
            }
            AppServerDKsEditor.this.selectElementAt(selectedIndex);
        }
    }

    private class AddAction
    extends AnAction
    implements DumbAware {
        private final AppServerIntegration myIntegration;

        public AddAction(AppServerIntegration integration) {
            super(integration.getPresentableName(), null, integration.getIcon());
            this.myIntegration = integration;
        }

        public void actionPerformed(AnActionEvent e) {
            ApplicationServerImpl newServer = ApplicationServersUtil.createNewApplicationServer(this.myIntegration, AppServerDKsEditor.this.myModifiableModel, AppServerDKsEditor.this.collectNewServerDKs(), (JPanel)AppServerDKsEditor.this.mySplitter);
            if (newServer != null) {
                ApplicationServerConfigurable configurable = newServer.createConfigurable(AppServerDKsEditor.this);
                Pair pair = Pair.create((Object)configurable, (Object)AppServerDKsEditor.this.createUniqueId());
                AppServerDKsEditor.this.mySKDToConfigurableMap.put(newServer, pair);
                AppServerDKsEditor.this.myConfigurablePanel.add((Component)configurable.createComponent(), pair.getSecond());
                AppServerDKsEditor.this.refreshList();
                AppServerDKsEditor.this.selectServerElement(newServer);
            }
        }
    }

    private class MyRemoveAction
    implements AnActionButtonRunnable {
        private MyRemoveAction() {
        }

        public void run(AnActionButton button) {
            int prevSelection = AppServerDKsEditor.this.myServerDKs.getSelectionModel().getMinSelectionIndex();
            ApplicationServer currentSelection = AppServerDKsEditor.this.getCurrentSelection();
            if (currentSelection != null) {
                AppServerDKsEditor.this.myModifiableModel.deleteApplicationServer(currentSelection);
                Pair pair = (Pair)AppServerDKsEditor.this.mySKDToConfigurableMap.remove(currentSelection);
                if (pair != null) {
                    ((ApplicationServerConfigurable)pair.getFirst()).disposeUIResources();
                }
                AppServerDKsEditor.this.refreshList();
                AppServerDKsEditor.this.trySelectElementAt(prevSelection);
            }
        }
    }
}

