/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.web;

import com.intellij.facet.ProjectWideFacetAdapter;
import com.intellij.facet.ProjectWideFacetListener;
import com.intellij.facet.ProjectWideFacetListenersRegistry;
import com.intellij.ide.FrameStateManager;
import com.intellij.javaee.make.J2EECompilerManager;
import com.intellij.javaee.web.WebLogicalRoot;
import com.intellij.javaee.web.artifact.WebArtifactUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.validation.JasperValidationTask;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.components.NamedComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactListener;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.source.jsp.WebDirectoryUtil;
import com.intellij.util.Function;
import com.intellij.util.LogicalRootsManager;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class WebProjectComponent
implements NamedComponent {
    public WebProjectComponent(final Project project, J2EECompilerManager j2EECompilerManager, CompilerManager compilerManager, FrameStateManager saveAndSyncHandler, LogicalRootsManager logicalRootsManager, ProjectWideFacetListenersRegistry facetListenersRegistry) {
        j2EECompilerManager.setValidator(compilerManager, saveAndSyncHandler);
        compilerManager.addAfterTask((CompileTask)new JasperValidationTask(project));
        logicalRootsManager.registerLogicalRootProvider(WebLogicalRoot.WEB_ROOT_TYPE, module -> {
            Collection webFacets = WebFacet.getInstances((Module)module);
            return ContainerUtil.concat((Iterable)webFacets, webFacet -> {
                List list = webFacet.getWebRoots();
                return ContainerUtil.mapNotNull((Collection)list, (Function)((NullableFunction)s -> {
                    VirtualFile file = s.getFile();
                    return file != null ? new WebLogicalRoot(s) : null;
                }));
            });
        });
        facetListenersRegistry.registerListener(WebFacet.ID, (ProjectWideFacetListener)new ProjectWideFacetAdapter<WebFacet>(){

            public void facetAdded(WebFacet facet) {
                WebDirectoryUtil.getWebDirectoryUtil(project).clearWebDirectoryCaches();
                ((LogicalRootsManager.LogicalRootListener)project.getMessageBus().syncPublisher(LogicalRootsManager.LOGICAL_ROOTS)).logicalRootsChanged();
            }

            public void facetConfigurationChanged(WebFacet facet) {
                WebDirectoryUtil.getWebDirectoryUtil(project).clearWebDirectoryCaches();
            }

            public void facetRemoved(WebFacet facet) {
                WebDirectoryUtil.getWebDirectoryUtil(project).clearWebDirectoryCaches();
                ((LogicalRootsManager.LogicalRootListener)project.getMessageBus().syncPublisher(LogicalRootsManager.LOGICAL_ROOTS)).logicalRootsChanged();
            }
        });
        project.getMessageBus().connect().subscribe(ArtifactManager.TOPIC, (Object)new ArtifactListener(){

            public void artifactAdded(@NotNull Artifact artifact) {
                if (artifact == null) {
                    2.$$$reportNull$$$0(0);
                }
                WebProjectComponent.onArtifactChanged(project, artifact);
            }

            public void artifactRemoved(@NotNull Artifact artifact) {
                if (artifact == null) {
                    2.$$$reportNull$$$0(1);
                }
                WebProjectComponent.onArtifactChanged(project, artifact);
            }

            public void artifactChanged(@NotNull Artifact artifact, @NotNull String oldName) {
                if (artifact == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (oldName == null) {
                    2.$$$reportNull$$$0(3);
                }
                WebProjectComponent.onArtifactChanged(project, artifact);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "artifact";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "oldName";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/j2ee/web/WebProjectComponent$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "artifactAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "artifactRemoved";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "artifactChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static void onArtifactChanged(Project project, Artifact artifact) {
        if (WebArtifactUtil.getInstance().isWebApplication(artifact.getArtifactType())) {
            ((PsiModificationTrackerImpl)PsiManager.getInstance((Project)project).getModificationTracker()).incCounter();
        }
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("WebProjectComponent" == null) {
            WebProjectComponent.$$$reportNull$$$0(0);
        }
        return "WebProjectComponent";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2ee/web/WebProjectComponent", "getComponentName"));
    }
}

