/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.inspections;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.analysis.annotator.EjbHighlightingMessages;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.role.EjbMethodRole;
import com.intellij.javaee.ejb.role.EjbMethodRoleEnum;
import com.intellij.javaee.facet.JavaeeFacetUtil;
import com.intellij.javaee.model.common.ejb.CmrField;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.EntityBean;
import com.intellij.javaee.module.JavaeeLibrariesUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class EjbHighlightUtil {
    private static final Logger LOG = Logger.getInstance((String)"#EjbHighlightUtil");
    @NonNls
    public static final String ILLEGAL_CLASSES_PATERN = "^(java\\.io\\.File|java\\.awt|javax\\.swing|java\\.lang\\.reflect|java\\.security\\.Policy|java\\.security\\.Security|java\\.security\\.Provider|java\\.security\\.Signer|java\\.security\\.Identity|java\\.net\\.ServerSocket|java\\.lang\\.ClassLoader|java\\.lang\\.SecurityManager|java\\.lang\\.Thread).*$";
    @NonNls
    public static final String EJB_SELECT_METHOD_PREFIX = "ejbSelect";
    @NonNls
    public static final String EJB_FINDER_METHOD_PREFIX = "ejbFind";
    @NonNls
    public static final String FINALIZE_METHOD_NAME = "finalize";
    @NonNls
    public static final String CREATE_METHOD_SUFFIX = "Create";
    @NonNls
    public static final String EJB_CREATE_METHOD_TEMPLATE = "public void ejbCreate() throws javax.ejb.CreateException{}";
    @NonNls
    public static final String FIND_BY_PRIMKEY_METHOD = "findByPrimaryKey";
    @NonNls
    public static final String CREATE_METHOD = "create";
    @NonNls
    public static final String FIND_METHOD = "find";

    private EjbHighlightUtil() {
    }

    public static void checkClassExtends(ProblemsHolder holder, PsiClass aClass, String baseClass, boolean shouldExtend) {
        PsiClass aBaseClass = EjbHighlightUtil.checkClassAvailable(holder, (PsiElement)aClass.getNameIdentifier(), baseClass);
        if (aBaseClass == null) {
            return;
        }
        if (aClass.isInheritor(aBaseClass, true) != shouldExtend) {
            PsiReferenceList extendsList = aClass.getExtendsList();
            if (extendsList == null || extendsList.getReferenceElements().length == 0) {
                extendsList = aClass.getImplementsList();
            }
            assert (extendsList != null);
            String messageKey = aClass.isInterface() ? (shouldExtend ? "interface.should.extend" : "interface.should.not.extend") : (aBaseClass.isInterface() == aClass.isInterface() ? (shouldExtend ? "class.should.extend" : "class.should.not.extend") : (shouldExtend ? "class.should.implement" : "class.should.not.implement"));
            LocalQuickFixAndIntentionActionOnPsiElement quickFix = QuickFixFactory.getInstance().createExtendsListFix(aClass, JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory().createType(aBaseClass), shouldExtend);
            if (extendsList.getReferenceElements().length == 0) {
                holder.registerProblem((PsiElement)aClass, EjbHighlightUtil.getClassDeclarationRange(aClass), EjbHighlightingMessages.message(messageKey, aClass.getName(), baseClass), new LocalQuickFix[]{quickFix});
            } else {
                holder.registerProblem((PsiElement)extendsList, EjbHighlightingMessages.message(messageKey, aClass.getName(), baseClass), new LocalQuickFix[]{quickFix});
            }
        }
    }

    @Nullable
    public static PsiClass checkClassAvailable(ProblemsHolder holder, PsiElement context, String baseClass) {
        PsiClass aClass = JavaPsiFacade.getInstance((Project)context.getProject()).findClass(baseClass, GlobalSearchScope.allScope((Project)context.getProject()));
        if (aClass == null && (baseClass.startsWith("java.") || baseClass.startsWith("javax."))) {
            Module module = ModuleUtil.findModuleForPsiElement((PsiElement)context);
            LocalQuickFix[] quickFixes = module != null && JavaeeFacetUtil.getInstance().getAllJavaeeFacets(new Module[]{module}).length > 0 && baseClass.startsWith("javax.") ? new LocalQuickFix[]{JavaeeLibrariesUtil.createAddJavaeeLibraryQuickFix(module, J2EEBundle.message((String)"inspection.ejb.display.name", (Object[])new Object[0]))} : LocalQuickFix.EMPTY_ARRAY;
            holder.registerProblem(context, EjbHighlightingMessages.message("ejb.library.not.linked", baseClass), quickFixes);
        }
        return aClass;
    }

    @Nullable
    private static PsiJavaCodeReferenceElement findMethodThrowsElement(ProblemsHolder holder, PsiMethod method, String exception, boolean shouldHave) {
        PsiClass targetException = EjbHighlightUtil.checkClassAvailable(holder, (PsiElement)method.getNameIdentifier(), exception);
        if (targetException != null) {
            PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory();
            for (PsiJavaCodeReferenceElement element : method.getThrowsList().getReferenceElements()) {
                PsiClassType classType = psiElementFactory.createType(element);
                PsiClass throwException = classType.resolve();
                if (throwException == null || !exception.equals(throwException.getQualifiedName()) && (!shouldHave || !targetException.isInheritor(throwException, true)) && (shouldHave || !throwException.isInheritor(targetException, true))) continue;
                return element;
            }
        }
        return null;
    }

    public static boolean checkMethodThrows(ProblemsHolder holder, PsiMethod method, String exception, boolean shouldHave) {
        boolean doThrows;
        PsiJavaCodeReferenceElement element = EjbHighlightUtil.findMethodThrowsElement(holder, method, exception, shouldHave);
        boolean bl = doThrows = element != null;
        if (doThrows != shouldHave) {
            PsiJavaCodeReferenceElement context = element == null ? method.getNameIdentifier() : element;
            PsiClassType type = JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory().createTypeByFQClassName(exception, method.getResolveScope());
            holder.registerProblem((PsiElement)context, EjbHighlightingMessages.message(shouldHave ? "method.should.throw" : "method.should.not.throw", method.getName(), exception), new LocalQuickFix[]{QuickFixFactory.getInstance().createMethodThrowsFix(method, type, shouldHave, false)});
            return true;
        }
        return false;
    }

    static void checkMethodReturns(ProblemsHolder holder, PsiMethod method, Object[] returnTypes) {
        try {
            for (Object o : returnTypes) {
                PsiType type;
                PsiType psiType = type = o instanceof String ? JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory().createTypeFromText((String)o, (PsiElement)method) : (PsiType)o;
                if (!Comparing.equal((Object)method.getReturnType(), (Object)type)) continue;
                return;
            }
            PsiTypeElement context = method.getReturnTypeElement();
            if (context == null) {
                context = method.getNameIdentifier();
            }
            ArrayList<LocalQuickFixAndIntentionActionOnPsiElement> quickFixes = new ArrayList<LocalQuickFixAndIntentionActionOnPsiElement>();
            for (Object o : returnTypes) {
                PsiType type = o instanceof String ? JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory().createTypeFromText((String)o, (PsiElement)method) : (PsiType)o;
                quickFixes.add(QuickFixFactory.getInstance().createMethodReturnFix(method, type, false));
            }
            String message = EjbHighlightingMessages.message(returnTypes.length > 1 ? "method.should.return.one.of" : "method.should.return", method.getName(), EjbHighlightUtil.getReturnTypesCommaSeparatedList(returnTypes));
            holder.registerProblem((PsiElement)context, message, quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    static String getReturnTypesCommaSeparatedList(Object[] returnTypes) {
        StringBuilder returnMessage = new StringBuilder();
        for (int i = 0; i < returnTypes.length; ++i) {
            Object o = returnTypes[i];
            if (i > 0) {
                returnMessage.append(", ");
            }
            returnMessage.append("'");
            returnMessage.append(o instanceof String ? o : ((PsiType)o).getCanonicalText());
            returnMessage.append("'");
        }
        return returnMessage.toString();
    }

    public static void checkMethodParameters(ProblemsHolder holder, PsiMethod method, PsiType[] types) {
        PsiParameter[] parameters = method.getParameterList().getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            PsiParameter parameter = parameters[i];
            PsiType parameterType = parameter.getType();
            if (i < types.length) {
                PsiType type = types[i];
                if (parameterType.equals(type)) continue;
                holder.registerProblem((PsiElement)parameter, EjbHighlightingMessages.message("method.parameter.of.type.expected", method.getName(), type.getPresentableText()), new LocalQuickFix[]{QuickFixFactory.getInstance().createMethodParameterTypeFix(method, i, type, true)});
                continue;
            }
            if (i != types.length) continue;
            holder.registerProblem((PsiElement)method.getParameterList(), EjbHighlightingMessages.message("method.too.many.parameters", method.getName(), types.length), new LocalQuickFix[]{QuickFixFactory.getInstance().createRemoveUnusedParameterFix(parameter)});
        }
        if (parameters.length < types.length) {
            holder.registerProblem((PsiElement)method.getParameterList(), EjbHighlightingMessages.message("method.parameter.of.type.expected", method.getName(), types[parameters.length].getPresentableText()), new LocalQuickFix[]{QuickFixFactory.getInstance().createMethodParameterTypeFix(method, parameters.length, types[parameters.length], true)});
        }
    }

    static void checkMethodReturns(ProblemsHolder holder, PsiMethod method, String returnType) {
        EjbHighlightUtil.checkMethodReturns(holder, method, new Object[]{returnType});
    }

    static void checkMethodReturns(ProblemsHolder holder, PsiMethod method, PsiType returnType) {
        EjbHighlightUtil.checkMethodReturns(holder, method, new Object[]{returnType});
    }

    public static void checkClassModifier(ProblemsHolder holder, PsiClass aClass, @PsiModifier.ModifierConstant String modifier, boolean shouldHave) {
        PsiModifierList modifierList = aClass.getModifierList();
        if (modifierList != null && modifierList.hasModifierProperty(modifier) != shouldHave) {
            PsiElement keyword = PsiUtil.findModifierInList((PsiModifierList)modifierList, (String)modifier);
            String messageKey = EjbHighlightUtil.getMessageKey(aClass.isInterface(), shouldHave);
            if (keyword != null) {
                holder.registerProblem(keyword, EjbHighlightingMessages.message(messageKey, aClass.getName(), modifier), new LocalQuickFix[]{QuickFixFactory.getInstance().createModifierListFix((PsiModifierListOwner)aClass, modifier, shouldHave, false)});
            } else {
                holder.registerProblem((PsiElement)aClass, EjbHighlightUtil.getClassDeclarationRange(aClass), EjbHighlightingMessages.message(messageKey, aClass.getName(), modifier), new LocalQuickFix[]{QuickFixFactory.getInstance().createModifierListFix((PsiModifierListOwner)aClass, modifier, shouldHave, false)});
            }
        }
    }

    @NonNls
    private static String getMessageKey(boolean anInterface, boolean shouldHave) {
        if (anInterface) {
            return shouldHave ? "interface.should.have.modifier" : "interface.should.not.have.modifier";
        }
        return shouldHave ? "class.should.have.modifier" : "class.should.not.have.modifier";
    }

    public static void checkMethodModifier(ProblemsHolder holder, PsiMethod method, @PsiModifier.ModifierConstant String modifier, boolean shouldHave) {
        PsiModifierList modifierList = method.getModifierList();
        if (modifierList.hasModifierProperty(modifier) != shouldHave) {
            PsiElement context = PsiUtil.findModifierInList((PsiModifierList)modifierList, (String)modifier);
            if (context == null) {
                context = modifierList.getTextLength() == 0 ? method.getNameIdentifier() : method.getModifierList();
            }
            holder.registerProblem(context, EjbHighlightingMessages.message(shouldHave ? "method.should.have.modifier" : "method.should.not.have.modifier", method.getName(), modifier), new LocalQuickFix[]{QuickFixFactory.getInstance().createModifierListFix((PsiModifierListOwner)method, modifier, shouldHave, false)});
        }
    }

    public static void checkFieldModifier(ProblemsHolder holder, PsiField field, @PsiModifier.ModifierConstant String modifier, boolean shouldHave) {
        PsiModifierList modifierList = field.getModifierList();
        if (modifierList != null && modifierList.hasModifierProperty(modifier) != shouldHave) {
            PsiElement context = PsiUtil.findModifierInList((PsiModifierList)modifierList, (String)modifier);
            if (context == null) {
                context = modifierList.getTextLength() == 0 ? field.getNameIdentifier() : field.getModifierList();
            }
            holder.registerProblem(context, EjbHighlightingMessages.message(shouldHave ? "field.should.have.modifier" : "field.should.not.have.modifier", field.getName(), modifier), new LocalQuickFix[]{QuickFixFactory.getInstance().createModifierListFix((PsiModifierListOwner)field, modifier, shouldHave, false)});
        }
    }

    public static void checkCmrAccessorSignature(ProblemsHolder holder, PsiMethod method, EjbMethodRole methodRole) {
        String type;
        PsiClass cmrType;
        EntityBean entityBean = (EntityBean)methodRole.getEnterpriseBean();
        CmrField cmrField = EjbUtil.findCmrField((EnterpriseBean)entityBean, method);
        if (cmrField != null && (cmrType = EjbUtil.findClass(cmrField)) != null && (type = cmrType.getQualifiedName()) != null) {
            PsiParameter[] parameters;
            EjbMethodRoleEnum roleType = methodRole.getType();
            if (roleType == EjbMethodRoleEnum.EJB_METHOD_ROLE_CMR_GETTER_IMPL || roleType == EjbMethodRoleEnum.EJB_METHOD_ROLE_CMR_GETTER_DECL) {
                EjbHighlightUtil.checkMethodReturns(holder, method, type);
            } else if (!(roleType != EjbMethodRoleEnum.EJB_METHOD_ROLE_CMR_SETTER_DECL && roleType != EjbMethodRoleEnum.EJB_METHOD_ROLE_CMR_SETTER_IMPL || (parameters = method.getParameterList().getParameters()).length == 1 && parameters[0].getType().equalsToText(type))) {
                holder.registerProblem((PsiElement)(parameters.length == 0 ? method.getNameIdentifier() : parameters[0].getTypeElement()), EjbHighlightingMessages.message("cmr.field.setter.should.have.parameter", type), new LocalQuickFix[0]);
            }
        }
    }

    public static void checkPublicNoArgsConstructorDefined(ProblemsHolder holder, PsiClass aClass) {
        PsiMethod[] constructors = aClass.getConstructors();
        if (constructors.length == 0) {
            return;
        }
        for (PsiMethod method : constructors) {
            if (!method.hasModifierProperty("public") || method.getParameterList().getParametersCount() != 0) continue;
            return;
        }
        holder.registerProblem((PsiElement)aClass.getNameIdentifier(), EjbHighlightingMessages.message("public.no.args.constructor.required", aClass.getName()), new LocalQuickFix[]{QuickFixFactory.getInstance().createAddDefaultConstructorFix(aClass)});
    }

    public static void checkClassIsInterface(ProblemsHolder holder, PsiClass aClass, boolean shouldBe) {
        if (shouldBe != aClass.isInterface()) {
            holder.registerProblem((PsiElement)aClass, EjbHighlightUtil.getClassDeclarationRange(aClass), EjbHighlightingMessages.message(shouldBe ? "should.be.interface" : "should.not.be.interface", aClass.getName()), new LocalQuickFix[]{QuickFixFactory.getInstance().createMakeClassInterfaceFix(aClass, shouldBe)});
        }
    }

    public static boolean isInheritor(ProblemsHolder holder, PsiClass aClass, String baseClass) {
        PsiClass remoteClass = EjbHighlightUtil.checkClassAvailable(holder, (PsiElement)aClass, baseClass);
        return remoteClass == null || aClass.isInheritor(remoteClass, true);
    }

    public static TextRange getClassDeclarationRange(PsiClass aClass) {
        return HighlightNamesUtil.getClassDeclarationTextRange((PsiClass)aClass).shiftRight(-aClass.getTextRange().getStartOffset());
    }
}

