/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.migration;

import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.ejb.migration.ApplyJavaeeStyleDialog;
import com.intellij.javaee.ejb.migration.ApplyJavaeeStyleViewDescriptor;
import com.intellij.javaee.ejb.migration.JavaeeStyleEngine;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ApplyJavaeeStyleProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.javaee.ejb.migration.ApplyJavaeeStyleProcessor");
    private final ApplyJavaeeStyleDialog myDialog;
    private PsiFile[] filesWithInvalidValues = PsiFile.EMPTY_ARRAY;

    public ApplyJavaeeStyleProcessor(Project project, ApplyJavaeeStyleDialog dialog) {
        super(project);
        this.myDialog = dialog;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            ApplyJavaeeStyleProcessor.$$$reportNull$$$0(0);
        }
        EnterpriseBean[] enterpriseBeans = this.myDialog.getEnterpriseBeans();
        PsiClass[] psiClasses = new PsiClass[enterpriseBeans.length];
        for (int i = 0; i < psiClasses.length; ++i) {
            psiClasses[i] = (PsiClass)enterpriseBeans[i].getEjbClass().getValue();
        }
        ApplyJavaeeStyleViewDescriptor applyJavaeeStyleViewDescriptor = new ApplyJavaeeStyleViewDescriptor(PsiClass.EMPTY_ARRAY);
        if (applyJavaeeStyleViewDescriptor == null) {
            ApplyJavaeeStyleProcessor.$$$reportNull$$$0(1);
        }
        return applyJavaeeStyleViewDescriptor;
    }

    @NotNull
    protected String getCommandName() {
        String string = J2EEBundle.message((String)"apply.javaee.style.command", (Object[])new Object[0]);
        if (string == null) {
            ApplyJavaeeStyleProcessor.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void doRun() {
        super.doRun();
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            ApplyJavaeeStyleProcessor.$$$reportNull$$$0(3);
        }
        final MultiMap conflicts = new MultiMap();
        if (this.myDialog != null) {
            ConflictsDialog dialog;
            JavaeeStyleEngine.MyUsageVisitor visitor = new JavaeeStyleEngine.MyUsageVisitor(){

                @Override
                public void visitMyUsageInfo(JavaeeStyleEngine.MyUsageInfo usageInfo) {
                    if (usageInfo instanceof JavaeeStyleEngine.AddElementUsageInfo && usageInfo.getElement() instanceof PsiClass) {
                        ApplyJavaeeStyleProcessor.this.checkExistingMembers((MultiMap<PsiElement, String>)conflicts, (PsiClass)usageInfo.getElement(), ((JavaeeStyleEngine.AddElementUsageInfo)usageInfo).getNewElements());
                    } else if (usageInfo instanceof JavaeeStyleEngine.ReplaceElementUsageInfo) {
                        JavaeeStyleEngine.ReplaceElementUsageInfo replaceInfo = (JavaeeStyleEngine.ReplaceElementUsageInfo)usageInfo;
                        if (usageInfo.getElement() instanceof PsiMember) {
                            ApplyJavaeeStyleProcessor.this.checkExistingMembers((MultiMap<PsiElement, String>)conflicts, ((PsiMember)usageInfo.getElement()).getContainingClass(), Collections.singletonList(replaceInfo.getNewElement()));
                        } else if (usageInfo.getElement() instanceof PsiIdentifier && usageInfo.getElement().getParent() instanceof PsiMember) {
                            PsiMember psiMember = (PsiMember)usageInfo.getElement().getParent();
                            PsiElement newName = replaceInfo.getNewElement();
                            PsiMember psiCopy = (PsiMember)psiMember.copy();
                            try {
                                if (psiCopy instanceof PsiField) {
                                    ((PsiField)psiCopy).getNameIdentifier().replace(newName);
                                } else {
                                    ((PsiMethod)psiCopy).getNameIdentifier().replace(newName);
                                }
                                ApplyJavaeeStyleProcessor.this.checkExistingMembers((MultiMap<PsiElement, String>)conflicts, psiMember.getContainingClass(), Collections.singletonList(psiCopy));
                            }
                            catch (IncorrectOperationException incorrectOperationException) {
                                // empty catch block
                            }
                        }
                    }
                }
            };
            if (refUsages.get() == null) {
                return false;
            }
            for (UsageInfo usageInfo : (UsageInfo[])refUsages.get()) {
                assert (usageInfo instanceof JavaeeStyleEngine.MyUsageInfo);
                ((JavaeeStyleEngine.MyUsageInfo)usageInfo).accept(visitor);
            }
            if (conflicts.size() > 0 && !(dialog = this.prepareConflictsDialog(conflicts, (UsageInfo[])refUsages.get())).showAndGet()) {
                if (dialog.isShowConflicts()) {
                    this.prepareSuccessful();
                }
                return false;
            }
        }
        this.prepareSuccessful();
        return true;
    }

    private void checkExistingMembers(MultiMap<PsiElement, String> conflicts, PsiClass psiClass, List<? extends PsiElement> elements) {
        for (PsiElement psiElement : elements) {
            PsiMethod psiMethod;
            String message;
            String descr;
            PsiField psiMember;
            if (psiElement instanceof PsiField) {
                PsiField psiField = (PsiField)psiElement;
                psiMember = psiClass.findFieldByName(psiField.getName(), false);
                if (psiMember == null) continue;
                descr = PsiFormatUtil.formatVariable((PsiVariable)psiMember, (int)3, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                message = J2EEBundle.message((String)"apply.javaee.style.field.exists", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)descr)});
                conflicts.putValue((Object)psiMember, (Object)message);
                continue;
            }
            if (!(psiElement instanceof PsiMethod) || (psiMember = psiClass.findMethodBySignature(psiMethod = (PsiMethod)psiElement, false)) == null) continue;
            descr = PsiFormatUtil.formatMethod((PsiMethod)psiMember, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4353, (int)2);
            message = J2EEBundle.message((String)"apply.javaee.style.method.exists", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)descr)});
            conflicts.putValue((Object)psiMember, (Object)message);
        }
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        UsageInfo[] usageInfos;
        block3: {
            try {
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                JavaeeStyleEngine migrator = new JavaeeStyleEngine(this.myDialog);
                usageInfos = migrator.calculateUsages();
                this.filesWithInvalidValues = migrator.getFileWithInvalidValues();
                if (usageInfos != null) break block3;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                if (UsageInfo.EMPTY_ARRAY == null) {
                    ApplyJavaeeStyleProcessor.$$$reportNull$$$0(5);
                }
                return UsageInfo.EMPTY_ARRAY;
            }
            ApplyJavaeeStyleProcessor.$$$reportNull$$$0(4);
        }
        return usageInfos;
    }

    protected void refreshElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            ApplyJavaeeStyleProcessor.$$$reportNull$$$0(6);
        }
        this.myDialog.refreshEnterpriseBeans();
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            ApplyJavaeeStyleProcessor.$$$reportNull$$$0(7);
        }
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)this.myDialog.getModule().getProject());
        try {
            for (UsageInfo usage : JavaeeStyleEngine.preprocessUsages(usages)) {
                assert (usage instanceof JavaeeStyleEngine.MyUsageInfo);
                JavaeeStyleEngine.MyUsageInfo myUsage = (JavaeeStyleEngine.MyUsageInfo)usage;
                for (PsiElement psiElement : myUsage.processUsage()) {
                    codeStyleManager.shortenClassReferences(psiElement);
                }
            }
            JavaeeStyleEngine.postProcess(this.myDialog);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    protected void performPsiSpoilingRefactoring() {
        PsiFile[] psiFiles = this.filesWithInvalidValues;
        this.filesWithInvalidValues = PsiFile.EMPTY_ARRAY;
        JavaeeStyleEngine.processInvalidValues(psiFiles);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/ejb/migration/ApplyJavaeeStyleProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/ejb/migration/ApplyJavaeeStyleProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "refreshElements";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

