/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view;

import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.ui.GuiUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;

public abstract class ViewletsPanel
extends JPanel
implements DataProvider {
    protected final Project myProject;
    private final Map<String, JComponent> myDataHolder = new HashMap<String, JComponent>();
    private JPanel myPanel;

    protected ViewletsPanel(Project project) {
        this.myProject = project;
    }

    protected abstract void setupViewlets();

    public JComponent getComponent() {
        if (this.myPanel == null) {
            this.setupComponent();
        }
        return this.myPanel;
    }

    protected void setupComponent() {
        this.setupViewlets();
        JComponent component = this.createComponent();
        this.setLayout(new BorderLayout());
        this.add((Component)component, "Center");
        GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)component);
        this.myPanel = this;
    }

    protected void addComponentForViewlet(String viewletKey, JComponent component) {
        this.myDataHolder.put(viewletKey, component);
    }

    public Object getData(String dataId) {
        return this.myDataHolder.get(dataId);
    }

    protected abstract JComponent createComponent();
}

