/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.util;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.javaee.oss.server.JavaeeServerInstance;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunEnvironmentProvider {
    private final JavaeeServerInstance myServerInstance;
    private RunContentDescriptor myContentDescriptor;
    private Executor myExecutor;

    public RunEnvironmentProvider(@NotNull JavaeeServerInstance serverInstance) {
        if (serverInstance == null) {
            RunEnvironmentProvider.$$$reportNull$$$0(0);
        }
        this.myServerInstance = serverInstance;
    }

    private void find() {
        ProcessHandler processHandler = this.myServerInstance.getProcessHandler();
        RunContentManager contentManager = ExecutionManager.getInstance((Project)this.myServerInstance.getProject()).getContentManager();
        for (Executor executor : new Executor[]{DefaultRunExecutor.getRunExecutorInstance(), DefaultDebugExecutor.getDebugExecutorInstance()}) {
            this.myContentDescriptor = contentManager.findContentDescriptor(executor, processHandler);
            if (this.myContentDescriptor == null) continue;
            this.myExecutor = executor;
            return;
        }
    }

    @Nullable
    public RunContentDescriptor getRunContentDescriptor() {
        if (this.myContentDescriptor == null) {
            this.find();
        }
        return this.myContentDescriptor;
    }

    @Nullable
    public Executor getExecutor() {
        if (this.myExecutor == null) {
            this.find();
        }
        return this.myExecutor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverInstance", "com/intellij/javaee/oss/util/RunEnvironmentProvider", "<init>"));
    }
}

