/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.engine;

import com.intellij.credentialStore.Credentials;
import com.intellij.database.DataBus;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.javaee.JavaeePersistenceDescriptorsConstants;
import com.intellij.javaee.model.common.persistence.mapping.Entity;
import com.intellij.javaee.model.xml.persistence.Persistence;
import com.intellij.javaee.model.xml.persistence.PersistenceUnit;
import com.intellij.javaee.model.xml.persistence.PersistenceUnitTransactionType;
import com.intellij.javaee.model.xml.persistence.Property;
import com.intellij.jpa.JpaImplementationProvider;
import com.intellij.jpa.engine.JpaConnectionManager;
import com.intellij.jpa.engine.JpaEngineBase;
import com.intellij.jpa.engine.JpaTemplateDescriptor;
import com.intellij.jpa.model.annotations.mapping.JamEntityMappings;
import com.intellij.jpa.model.manipulators.JpaUnitManipulator;
import com.intellij.jpa.remote.JpaFacade;
import com.intellij.jpa.remote.RemoteEntityManager;
import com.intellij.jpa.remote.RemoteEntityManagerFactory;
import com.intellij.jpa.remote.RemoteQuery;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistencePackagePointer;
import com.intellij.persistence.model.manipulators.PersistenceUnitManipulator;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.ModelMergerUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpaEngine
extends JpaEngineBase {
    private File myTemporaryJpaConfig;
    private JpaFacade myFacade;
    private RemoteEntityManager myEntityManager;

    public static boolean isAvailable(Module module) {
        return JpaEngine.isClassAvailable(module, "javax.persistence.EntityManager");
    }

    public JpaEngine(DataBus.Producing messageBus, PersistencePackagePointer unitFile, ConsoleRunConfiguration configuration) {
        super(messageBus, unitFile, configuration);
    }

    @Override
    protected void releaseConnection() {
        this.myFacade = null;
        JpaConnectionManager.getInstance(this.getProject()).releaseConnection(this.myUnitFile, this.myConfiguration);
        this.removeTemporaryFiles();
    }

    private void ensureInitialized() throws Exception {
        try {
            if (!this.myEntityManager.isOpen()) {
                throw new IllegalStateException();
            }
        }
        catch (Exception e) {
            this.removeTemporaryFiles();
            this.createConnection();
        }
    }

    private void createConnection() throws Exception {
        LocalDataSource dataSource = JpaEngine.findDataSource(this.getProject(), this.myUnitFile);
        this.setRunConfigurationOptionsForDataSource(dataSource);
        this.myFacade = JpaConnectionManager.getInstance(this.getProject()).getConnection(this.myUnitFile, this.myConfiguration);
        this.createTemporaryConfig(this.myFacade.getPersistenceRoot(), dataSource);
        RemoteEntityManagerFactory entityManagerFactory = this.myFacade.createEntityManagerFactory(this.myUnitFile.getElementName());
        this.myEntityManager = entityManagerFactory.createEntityManager();
    }

    @Override
    protected RemoteQuery createQuery(String query) throws Exception {
        this.ensureInitialized();
        return this.myEntityManager.createQuery(query);
    }

    @Override
    protected String getGenerateSqlInner(String hqlQuery) throws Exception {
        this.ensureInitialized();
        return this.myEntityManager.generateSql(hqlQuery);
    }

    @Override
    protected String getGeneratedDdlInner() throws Exception {
        this.ensureInitialized();
        return this.myEntityManager.generateSchemaScript();
    }

    private void removeTemporaryFiles() {
        File file;
        this.myTemporaryJpaConfig = null;
        if (file != null) {
            File generatedDataDirectory = JpaEngine.getTempDirectory(this.getProject());
            for (file = this.myTemporaryJpaConfig; file != null && !FileUtil.filesEqual((File)file.getParentFile(), (File)generatedDataDirectory); file = file.getParentFile()) {
            }
            if (file != null) {
                FileUtil.delete((File)file);
            }
        }
    }

    private void createTemporaryConfig(@NotNull String unitRoot, @Nullable LocalDataSource dataSource) {
        if (unitRoot == null) {
            JpaEngine.$$$reportNull$$$0(0);
        }
        Credentials credentials = dataSource == null ? null : DatabaseCredentials.getInstance().getCredentials((DatabaseSystem)dataSource);
        this.myTemporaryJpaConfig = (File)DumbService.getInstance((Project)this.getProject()).runReadActionInSmartMode(() -> {
            if (unitRoot == null) {
                JpaEngine.$$$reportNull$$$0(9);
            }
            PersistencePackage unit = this.myUnitFile.findElement();
            PersistenceFacet facet = this.myUnitFile.getPersistenceFacet();
            if (unit == null || facet == null || facet.getModule().isDisposed()) {
                return null;
            }
            File tempDirMetaInf = new File(unitRoot, "META-INF");
            File jpaConfig = this.createTemporaryJpaConfig(new JpaEngineBase.GenerationInfo(this.getProject(), facet, unit, dataSource, credentials), tempDirMetaInf);
            JpaEngine.copyOrmXmlToTempDir(unit, tempDirMetaInf);
            return jpaConfig;
        });
    }

    private static void copyOrmXmlToTempDir(@NotNull PersistencePackage unit, @NotNull File tempMetaInf) {
        PsiFile containingFile;
        if (unit == null) {
            JpaEngine.$$$reportNull$$$0(1);
        }
        if (tempMetaInf == null) {
            JpaEngine.$$$reportNull$$$0(2);
        }
        if (!((containingFile = unit.getContainingFile()) instanceof XmlFile)) {
            return;
        }
        PsiDirectory directory = containingFile.getContainingDirectory();
        if (directory == null) {
            return;
        }
        PsiFile ormXml = directory.findFile("orm.xml");
        if (ormXml == null) {
            return;
        }
        VirtualFile ormXmlVirtualFile = ormXml.getVirtualFile();
        if (ormXmlVirtualFile == null) {
            return;
        }
        try {
            FileUtil.copy((File)VfsUtilCore.virtualToIoFile((VirtualFile)ormXmlVirtualFile), (File)new File(tempMetaInf, "orm.xml"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String createPersistenceXmlText(@NotNull JpaEngineBase.GenerationInfo info) {
        PersistenceUnitManipulator manipulator;
        if (info == null) {
            JpaEngine.$$$reportNull$$$0(3);
        }
        Project project = info.project;
        String versionString = JpaEngine.getVersion(info);
        JpaTemplateDescriptor jpaTemplateDescriptor = JpaEngine.loadJpaTemplate(versionString);
        XmlFile xmlFile = (XmlFile)PsiFileFactory.getInstance((Project)project).createFileFromText(JavaeePersistenceDescriptorsConstants.PERSISTENCE_XML_META_DATA.getFileName(), (FileType)StdFileTypes.XML, (CharSequence)jpaTemplateDescriptor.getTemplate());
        DomFileElement fileElement = DomManager.getDomManager((Project)project).getFileElement(xmlFile, Persistence.class);
        assert (fileElement != null);
        if (StringUtil.isNotEmpty((String)versionString)) {
            ((Persistence)fileElement.getRootElement()).getVersion().setStringValue(versionString);
        }
        PersistenceUnit pu = ((Persistence)fileElement.getRootElement()).addPersistenceUnit();
        pu.getName().setStringValue((String)info.unit.getName().getValue());
        pu.getExcludeUnlistedClasses().setStringValue(info.unit.getModelHelper().getExcludeUnlistedClasses().getStringValue());
        PersistenceFacet facet = info.facet;
        JpaImplementationProvider provider = JpaUtil.findJpaProvider(facet, info.unit, true);
        if (provider != null) {
            pu.getProvider().setStringValue(provider.getProviderClassName(facet != null ? facet.getModule() : null));
        }
        pu.getTransactionType().setValue((Object)PersistenceUnitTransactionType.RESOURCE_LOCAL);
        for (GenericValue value : info.unit.getModelHelper().getJarFiles()) {
            pu.addJarFile().setStringValue(value.getStringValue());
        }
        for (GenericValue value : info.unit.getModelHelper().getMappingFiles(PersistenceMappings.class)) {
            pu.addMappingFile().setStringValue(value.getStringValue());
        }
        for (String name : JpaEngine.getMappedClasses(info.unit.getModelHelper().getClasses(), info.unit, facet)) {
            pu.addClass().setStringValue(name);
        }
        for (GenericValue value : info.unit.getModelHelper().getClasses()) {
            pu.addClass().setStringValue(value.getStringValue());
        }
        HashSet filteredProperties = ContainerUtil.newHashSet();
        if (info.dataSource != null && (manipulator = (PersistenceUnitManipulator)PersistenceHelper.getHelper().getManipulatorsRegistry().getManipulator((Object)pu, PersistenceUnitManipulator.class)) != null) {
            if (manipulator instanceof JpaUnitManipulator) {
                ((JpaUnitManipulator)manipulator).setConnectionProperties(provider, project, (RawConnectionConfig)info.dataSource, info.credentials);
            } else {
                manipulator.setConnectionProperties(project, (RawConnectionConfig)info.dataSource, info.credentials);
            }
            for (Property property : pu.getProperties().getProperties()) {
                filteredProperties.add(property.getName().getStringValue());
            }
        }
        Properties properties = info.unit.getModelHelper().getPersistenceUnitProperties();
        for (Object object : properties.keySet()) {
            String name = (String)object;
            if (filteredProperties.contains(name) || jpaTemplateDescriptor.getIgnored().contains(name) || jpaTemplateDescriptor.getPredefined().containsKey(name)) continue;
            Property property = pu.getProperties().addProperty();
            property.getName().setValue((Object)name);
            property.getValue().setStringValue(properties.getProperty(name));
        }
        for (Map.Entry entry : jpaTemplateDescriptor.getPredefined().entrySet()) {
            Property property = pu.getProperties().addProperty();
            property.getName().setValue(entry.getKey());
            property.getValue().setStringValue((String)entry.getValue());
        }
        return xmlFile.getText();
    }

    private File createTemporaryJpaConfig(@NotNull JpaEngineBase.GenerationInfo info, @NotNull File metaInf) {
        if (info == null) {
            JpaEngine.$$$reportNull$$$0(4);
        }
        if (metaInf == null) {
            JpaEngine.$$$reportNull$$$0(5);
        }
        String fileName = JavaeePersistenceDescriptorsConstants.PERSISTENCE_XML_META_DATA.getFileName();
        String text = JpaEngine.createPersistenceXmlText(info);
        File file = new File(metaInf, fileName);
        this.writeTemporaryConfigText(file, text, info);
        return file;
    }

    public static Set<String> getMappedClasses(List<? extends GenericValue<PsiClass>> classes, PersistencePackage unit, PersistenceFacet facet) {
        JamEntityMappings jamMappings;
        THashSet classNames = new THashSet();
        for (GenericValue<PsiClass> genericValue : classes) {
            ContainerUtil.addIfNotNull((Collection)classNames, (Object)genericValue.getStringValue());
        }
        if (classes.isEmpty() && (jamMappings = (JamEntityMappings)ModelMergerUtil.getImplementation((Object)facet.getEntityMappings(unit), JamEntityMappings.class)) != null) {
            for (Entity entity : jamMappings.getEntities()) {
                ContainerUtil.addIfNotNull((Collection)classNames, (Object)entity.getClazz().getStringValue());
            }
        }
        return classNames;
    }

    @NotNull
    public static JpaTemplateDescriptor loadJpaTemplate(@Nullable String versionString) {
        String template;
        String name = "console-persistence" + (StringUtil.isNotEmpty((String)versionString) ? versionString : "") + ".xml";
        try {
            InputStream stream = JpaEngine.class.getResourceAsStream(name);
            template = stream != null ? FileUtil.loadTextAndClose((InputStream)stream) : JpaEngine.getDefaultTemplate();
        }
        catch (IOException e) {
            template = JpaEngine.getDefaultTemplate();
        }
        JpaTemplateDescriptor jpaTemplateDescriptor = new JpaTemplateDescriptor(template);
        Matcher ignoreMatcher = Pattern.compile("<!-- ignore: (.*) -->").matcher(template);
        while (ignoreMatcher.find()) {
            jpaTemplateDescriptor.getIgnored().add(ignoreMatcher.group(1).trim());
        }
        Matcher setMatcher = Pattern.compile("<!-- set: (.*) -->").matcher(template);
        while (setMatcher.find()) {
            List pair = StringUtil.split((String)setMatcher.group(1).trim(), (String)"=");
            if (pair.size() != 2) continue;
            jpaTemplateDescriptor.getPredefined().put((String)pair.get(0), (String)pair.get(1));
        }
        JpaTemplateDescriptor jpaTemplateDescriptor2 = jpaTemplateDescriptor;
        if (jpaTemplateDescriptor2 == null) {
            JpaEngine.$$$reportNull$$$0(6);
        }
        return jpaTemplateDescriptor2;
    }

    @NotNull
    private static String getDefaultTemplate() {
        if ("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<persistence xmlns=\"http://xmlns.jcp.org/xml/ns/persistence\"/>" == null) {
            JpaEngine.$$$reportNull$$$0(7);
        }
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<persistence xmlns=\"http://xmlns.jcp.org/xml/ns/persistence\"/>";
    }

    @Nullable
    public static String getVersion(@NotNull JpaEngineBase.GenerationInfo info) {
        if (info == null) {
            JpaEngine.$$$reportNull$$$0(8);
        }
        DomElement parent = info.unit instanceof PersistenceUnit ? ((PersistenceUnit)info.unit).getParent() : null;
        return parent instanceof Persistence ? ((Persistence)parent).getVersion().getStringValue() : "2.0";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unitRoot";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempMetaInf";
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaInf";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/engine/JpaEngine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/engine/JpaEngine";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "loadJpaTemplate";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTemplate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTemporaryConfig";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "copyOrmXmlToTempDir";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createPersistenceXmlText";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTemporaryJpaConfig";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getVersion";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createTemporaryConfig$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

