/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.generation.ui;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetTypeId;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.jam.view.tree.JamNodeDescriptor;
import com.intellij.jam.view.treetable.JamTreeTableView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.TreeTableSpeedSearch;
import com.intellij.ui.treeStructure.treetable.TreeColumnInfo;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.util.ui.ColumnInfo;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.jetbrains.annotations.Nullable;

public class FacetChooserDialog
extends DialogWrapper {
    private final Project myProject;
    private final FacetTypeId<?> myFacetTypeId;
    private JamTreeTableView myTreeView;
    private Facet mySelectedFacet;

    public FacetChooserDialog(Project project, FacetTypeId<?> facetTypeId) {
        super(project, false);
        this.myProject = project;
        this.myFacetTypeId = facetTypeId;
        this.init();
        this.updateOKAction();
    }

    private void updateOKAction() {
        this.setOKActionEnabled(this.mySelectedFacet != null);
    }

    protected boolean acceptsModule(Module module) {
        return true;
    }

    public Facet getSelectedFacet() {
        return this.mySelectedFacet;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.myTreeView = new MyTreeTableView(this.myProject, new ProjectDescriptor(this.myProject));
        this.myTreeView.getTree().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                NodeDescriptor nodeDescriptor = FacetChooserDialog.this.myTreeView.getSelectedDescriptor();
                FacetChooserDialog.this.mySelectedFacet = nodeDescriptor != null && nodeDescriptor.getElement() instanceof Facet ? (Facet)nodeDescriptor.getElement() : null;
                FacetChooserDialog.this.updateOKAction();
            }
        });
        new TreeTableSpeedSearch((TreeTable)this.myTreeView.getTreeTableView());
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                if (FacetChooserDialog.this.isOKActionEnabled()) {
                    FacetChooserDialog.this.doOKAction();
                    return true;
                }
                return false;
            }
        }.installOn((Component)this.myTreeView.getTreeTableView());
        return this.myTreeView.getComponent();
    }

    protected void dispose() {
        Disposer.dispose((Disposable)this.myTreeView);
        super.dispose();
    }

    private class MyTreeTableView
    extends JamTreeTableView {
        public MyTreeTableView(Project project, JamNodeDescriptor root) {
            super(project, root);
            this.init();
        }

        @Override
        protected boolean isShowTree() {
            return true;
        }

        @Override
        protected ColumnInfo[] createColumnInfos() {
            return new ColumnInfo[]{new TreeColumnInfo(" ")};
        }
    }

    static class FacetDescriptor
    extends JamNodeDescriptor<Facet> {
        protected FacetDescriptor(Project project, JamNodeDescriptor parentDescriptor, Facet element) {
            super(project, (NodeDescriptor)parentDescriptor, null, (Object)element);
        }

        protected String getNewNodeText() {
            return ((Facet)this.getElement()).getName();
        }

        protected Icon getNewIcon() {
            return ((Facet)this.getElement()).getType().getIcon();
        }
    }

    class ModuleDescriptor
    extends JamNodeDescriptor<Module> {
        protected ModuleDescriptor(Project project, JamNodeDescriptor parentDescriptor, Module element) {
            super(project, (NodeDescriptor)parentDescriptor, null, (Object)element);
        }

        public JamNodeDescriptor[] getChildren() {
            ArrayList<FacetDescriptor> result = new ArrayList<FacetDescriptor>();
            for (Facet facet : FacetManager.getInstance((Module)((Module)this.getElement())).getFacetsByType(FacetChooserDialog.this.myFacetTypeId)) {
                result.add(new FacetDescriptor(((Module)this.getElement()).getProject(), this, facet));
            }
            return result.toArray(JamNodeDescriptor.EMPTY_ARRAY);
        }

        protected String getNewNodeText() {
            return ((Module)this.getElement()).getName();
        }

        protected Icon getNewIcon() {
            return ModuleType.get((Module)((Module)this.getElement())).getIcon();
        }
    }

    private class ProjectDescriptor
    extends JamNodeDescriptor<Project> {
        protected ProjectDescriptor(Project project) {
            super(project, null, null, (Object)project);
        }

        protected String getNewNodeText() {
            return null;
        }

        public JamNodeDescriptor[] getChildren() {
            ArrayList<ModuleDescriptor> result = new ArrayList<ModuleDescriptor>();
            for (Module module : ModuleManager.getInstance((Project)((Project)this.getElement())).getModules()) {
                if (!FacetChooserDialog.this.acceptsModule(module)) continue;
                result.add(new ModuleDescriptor((Project)this.getElement(), this, module));
            }
            return result.toArray(JamNodeDescriptor.EMPTY_ARRAY);
        }
    }
}

