/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerTimeline;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public abstract class ProfilerTooltipView
extends AspectObserver {
    @NotNull
    private final ProfilerTimeline myTimeline;
    @NotNull
    protected final String myTitle;
    @NotNull
    protected final JLabel myLabel;
    private int myMaximumLabelWidth;

    protected ProfilerTooltipView(@NotNull ProfilerTimeline timeline, @NotNull String title) {
        if (timeline == null) {
            ProfilerTooltipView.$$$reportNull$$$0(0);
        }
        if (title == null) {
            ProfilerTooltipView.$$$reportNull$$$0(1);
        }
        this.myTimeline = timeline;
        this.myTitle = title;
        this.myLabel = new JLabel();
        this.myLabel.setForeground(ProfilerColors.TOOLTIP_TEXT);
        this.myLabel.setFont(this.myLabel.getFont().deriveFont(11.0f));
        this.myLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 12, 0));
        timeline.getTooltipRange().addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, this::timeChanged);
        this.myMaximumLabelWidth = 0;
    }

    protected void timeChanged() {
        Range range = this.myTimeline.getTooltipRange();
        if (!range.isEmpty()) {
            String time = TimeAxisFormatter.DEFAULT.getFormattedString(this.myTimeline.getDataRange().getLength(), range.getMin() - this.myTimeline.getDataRange().getMin(), true);
            this.myLabel.setText(String.format("%s at %s", this.myTitle, time));
            this.myMaximumLabelWidth = Math.max(this.myMaximumLabelWidth, this.myLabel.getWidth());
            this.myLabel.setMinimumSize(new Dimension(this.myMaximumLabelWidth, 0));
        } else {
            this.myLabel.setText("");
        }
    }

    protected abstract Component createTooltip();

    public final Component createComponent() {
        Component tooltip = this.createTooltip();
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.myLabel, "North");
        panel.add(tooltip, "Center");
        panel.setForeground(ProfilerColors.TOOLTIP_TEXT);
        panel.setBackground(ProfilerColors.TOOLTIP_BACKGROUND);
        panel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.timeChanged();
        return panel;
    }

    public void dispose() {
        this.myTimeline.getTooltipRange().removeDependencies((AspectObserver)this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "timeline";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "title";
                break;
            }
        }
        objectArray[1] = "com/android/tools/profilers/ProfilerTooltipView";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

