/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.FlatTabbedPane;
import com.android.tools.adtui.RangeTimeScrollBar;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.chart.hchart.HRenderer;
import com.android.tools.adtui.chart.hchart.HTreeChart;
import com.android.tools.adtui.chart.hchart.HTreeChartVerticalScrollBar;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.common.ColumnTreeBuilder;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.HNode;
import com.android.tools.adtui.model.Range;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.profilers.InfoMessagePanel;
import com.android.tools.profilers.JComboBoxView;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.ViewBinder;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.cpu.BottomUpTreeModel;
import com.android.tools.profilers.cpu.CaptureModel;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuProfilerStageView;
import com.android.tools.profilers.cpu.CpuTraceTreeSorter;
import com.android.tools.profilers.cpu.CpuTreeModel;
import com.android.tools.profilers.cpu.CpuTreeNode;
import com.android.tools.profilers.cpu.MethodModel;
import com.android.tools.profilers.cpu.SampledMethodUsageHRenderer;
import com.android.tools.profilers.cpu.TopDownTreeModel;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.google.common.collect.ImmutableMap;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.tree.TreeModelAdapter;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CpuCaptureView {
    private static final Map<CaptureModel.Details.Type, String> TABS = ImmutableMap.of((Object)((Object)CaptureModel.Details.Type.CALL_CHART), (Object)"Call Chart", (Object)((Object)CaptureModel.Details.Type.FLAME_CHART), (Object)"Flame Chart", (Object)((Object)CaptureModel.Details.Type.TOP_DOWN), (Object)"Top Down", (Object)((Object)CaptureModel.Details.Type.BOTTOM_UP), (Object)"Bottom Up");
    private static final Map<CaptureModel.Details.Type, Consumer<FeatureTracker>> CAPTURE_TRACKERS = ImmutableMap.of((Object)((Object)CaptureModel.Details.Type.TOP_DOWN), FeatureTracker::trackSelectCaptureTopDown, (Object)((Object)CaptureModel.Details.Type.BOTTOM_UP), FeatureTracker::trackSelectCaptureBottomUp, (Object)((Object)CaptureModel.Details.Type.CALL_CHART), FeatureTracker::trackSelectCaptureCallChart, (Object)((Object)CaptureModel.Details.Type.FLAME_CHART), FeatureTracker::trackSelectCaptureFlameChart);
    private static final Comparator<DefaultMutableTreeNode> DEFAULT_SORT_ORDER = Collections.reverseOrder(new DoubleValueNodeComparator(CpuTreeNode::getTotal));
    @NotNull
    private final CpuProfilerStageView myView;
    private final JPanel myPanel;
    private final JTabbedPane myTabsPanel;
    @Nullable
    private CaptureDetailsView myDetailsView;
    @NotNull
    private final ViewBinder<CpuProfilerStageView, CaptureModel.Details, CaptureDetailsView> myBinder;

    CpuCaptureView(@NotNull CpuProfilerStageView view) {
        if (view == null) {
            CpuCaptureView.$$$reportNull$$$0(0);
        }
        this.myView = view;
        this.myPanel = new JPanel((LayoutManager)new TabularLayout("*,Fit", "Fit,*"));
        this.myTabsPanel = new FlatTabbedPane();
        for (String label : TABS.values()) {
            this.myTabsPanel.addTab(label, new JPanel(new BorderLayout()));
        }
        this.myTabsPanel.addChangeListener(this::setCaptureDetailToTab);
        ComboBox clockTypeCombo = new ComboBox();
        JComboBoxView<ClockType, CpuProfilerAspect> clockTypes = new JComboBoxView<ClockType, CpuProfilerAspect>((JComboBox<ClockType>)clockTypeCombo, ((CpuProfilerStage)view.getStage()).getAspect(), CpuProfilerAspect.CLOCK_TYPE, ((CpuProfilerStage)view.getStage())::getClockTypes, ((CpuProfilerStage)view.getStage())::getClockType, ((CpuProfilerStage)view.getStage())::setClockType);
        clockTypes.bind();
        clockTypeCombo.setRenderer(new ClockTypeCellRenderer());
        this.myTabsPanel.setOpaque(false);
        this.myPanel.add((Component)clockTypeCombo, new TabularLayout.Constraint(0, 1));
        this.myPanel.add((Component)this.myTabsPanel, new TabularLayout.Constraint(0, 0, 2, 2));
        this.myBinder = new ViewBinder();
        this.myBinder.bind(CaptureModel.TopDown.class, (x$0, x$1) -> new TopDownView((CpuProfilerStageView)((Object)x$0), (CaptureModel.TopDown)x$1));
        this.myBinder.bind(CaptureModel.BottomUp.class, (x$0, x$1) -> new BottomUpView((CpuProfilerStageView)((Object)x$0), (CaptureModel.BottomUp)x$1));
        this.myBinder.bind(CaptureModel.CallChart.class, (x$0, x$1) -> new CallChartView((CpuProfilerStageView)((Object)x$0), (CaptureModel.CallChart)x$1));
        this.myBinder.bind(CaptureModel.FlameChart.class, FlameChartView::new);
        this.updateView();
    }

    void updateView() {
        for (Component tab : this.myTabsPanel.getComponents()) {
            assert (tab instanceof JPanel);
            ((JPanel)tab).removeAll();
        }
        CaptureModel.Details details = ((CpuProfilerStage)this.myView.getStage()).getCaptureDetails();
        if (details == null) {
            return;
        }
        String detailsTypeString = TABS.get((Object)details.getType());
        int currentTabIndex = this.myTabsPanel.getSelectedIndex();
        if (currentTabIndex < 0 || !this.myTabsPanel.getTitleAt(currentTabIndex).equals(detailsTypeString)) {
            for (int i = 0; i < this.myTabsPanel.getTabCount(); ++i) {
                if (!this.myTabsPanel.getTitleAt(i).equals(detailsTypeString)) continue;
                this.myTabsPanel.setSelectedIndex(i);
                break;
            }
        }
        Component selectedTab = this.myTabsPanel.getSelectedComponent();
        assert (selectedTab instanceof JPanel);
        this.myDetailsView = this.myBinder.build(this.myView, details);
        ((JPanel)selectedTab).add((Component)this.myDetailsView.getComponent(), "Center");
        selectedTab.revalidate();
    }

    private void setCaptureDetailToTab(ChangeEvent event) {
        CaptureModel.Details.Type type = null;
        if (this.myTabsPanel.getSelectedIndex() >= 0) {
            String tabTitle = this.myTabsPanel.getTitleAt(this.myTabsPanel.getSelectedIndex());
            for (Map.Entry<CaptureModel.Details.Type, String> entry : TABS.entrySet()) {
                if (!tabTitle.equals(entry.getValue())) continue;
                type = entry.getKey();
            }
        }
        ((CpuProfilerStage)this.myView.getStage()).setCaptureDetails(type);
        FeatureTracker tracker = ((CpuProfilerStage)this.myView.getStage()).getStudioProfilers().getIdeServices().getFeatureTracker();
        CAPTURE_TRACKERS.getOrDefault((Object)type, featureTracker -> {}).accept(tracker);
    }

    private static Logger getLog() {
        return Logger.getInstance(CpuCaptureView.class);
    }

    @NotNull
    private static JComponent setUpCpuTree(@NotNull JTree tree, @NotNull CpuTreeModel model, @NotNull CpuProfilerStageView stageView) {
        if (tree == null) {
            CpuCaptureView.$$$reportNull$$$0(1);
        }
        if (model == null) {
            CpuCaptureView.$$$reportNull$$$0(2);
        }
        if (stageView == null) {
            CpuCaptureView.$$$reportNull$$$0(3);
        }
        tree.setModel(model);
        CpuTraceTreeSorter sorter = new CpuTraceTreeSorter(tree);
        sorter.setModel(model, DEFAULT_SORT_ORDER);
        stageView.getIdeComponents().installNavigationContextMenu(tree, ((CpuProfilerStage)stageView.getStage()).getStudioProfilers().getIdeServices().getCodeNavigator(), () -> {
            if (tree == null) {
                CpuCaptureView.$$$reportNull$$$0(9);
            }
            return CpuCaptureView.getCodeLocation(tree);
        });
        JComponent jComponent = new ColumnTreeBuilder(tree).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Name").setPreferredWidth(900).setHeaderBorder(ProfilerLayout.TABLE_COLUMN_HEADER_BORDER).setHeaderAlignment(2).setRenderer((ColoredTreeCellRenderer)new MethodNameRenderer()).setComparator((Comparator)new NameValueNodeComparator())).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Self (\u03bcs)").setPreferredWidth(100).setHeaderBorder(ProfilerLayout.TABLE_COLUMN_RIGHT_ALIGNED_HEADER_BORDER).setHeaderAlignment(4).setRenderer((ColoredTreeCellRenderer)new DoubleValueCellRenderer(CpuTreeNode::getSelf, false, 4)).setComparator((Comparator)new DoubleValueNodeComparator(CpuTreeNode::getSelf))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("%").setPreferredWidth(50).setHeaderBorder(ProfilerLayout.TABLE_COLUMN_HEADER_BORDER).setHeaderAlignment(2).setRenderer((ColoredTreeCellRenderer)new DoubleValueCellRenderer(CpuTreeNode::getSelf, true, 2)).setComparator((Comparator)new DoubleValueNodeComparator(CpuTreeNode::getSelf))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Children (\u03bcs)").setPreferredWidth(100).setHeaderBorder(ProfilerLayout.TABLE_COLUMN_RIGHT_ALIGNED_HEADER_BORDER).setHeaderAlignment(4).setRenderer((ColoredTreeCellRenderer)new DoubleValueCellRenderer(CpuTreeNode::getChildrenTotal, false, 4)).setComparator((Comparator)new DoubleValueNodeComparator(CpuTreeNode::getChildrenTotal))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("%").setPreferredWidth(50).setHeaderBorder(ProfilerLayout.TABLE_COLUMN_HEADER_BORDER).setHeaderAlignment(2).setRenderer((ColoredTreeCellRenderer)new DoubleValueCellRenderer(CpuTreeNode::getChildrenTotal, true, 2)).setComparator((Comparator)new DoubleValueNodeComparator(CpuTreeNode::getChildrenTotal))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Total (\u03bcs)").setPreferredWidth(100).setHeaderBorder(ProfilerLayout.TABLE_COLUMN_RIGHT_ALIGNED_HEADER_BORDER).setHeaderAlignment(4).setRenderer((ColoredTreeCellRenderer)new DoubleValueCellRenderer(CpuTreeNode::getTotal, false, 4)).setComparator(DEFAULT_SORT_ORDER)).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("%").setPreferredWidth(50).setHeaderBorder(ProfilerLayout.TABLE_COLUMN_HEADER_BORDER).setHeaderAlignment(2).setRenderer((ColoredTreeCellRenderer)new DoubleValueCellRenderer(CpuTreeNode::getTotal, true, 2)).setComparator(DEFAULT_SORT_ORDER)).setTreeSorter((ColumnTreeBuilder.TreeSorter)sorter).setBorder(AdtUiUtils.DEFAULT_TOP_BORDER).setBackground(ProfilerColors.DEFAULT_BACKGROUND).setShowVerticalLines(true).build();
        if (jComponent == null) {
            CpuCaptureView.$$$reportNull$$$0(4);
        }
        return jComponent;
    }

    @Nullable
    private static CodeLocation getCodeLocation(@NotNull JTree tree) {
        if (tree == null) {
            CpuCaptureView.$$$reportNull$$$0(5);
        }
        if (tree.getSelectionPath() == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getSelectionPath().getLastPathComponent();
        CpuTreeNode cpuNode = (CpuTreeNode)node.getUserObject();
        return new CodeLocation.Builder(cpuNode.getClassName()).setMethodSignature(cpuNode.getMethodName(), cpuNode.getSignature()).build();
    }

    private static void expandTreeNodes(JTree tree) {
        int maxRowsToExpand = 8;
        int i = 0;
        while (i < tree.getRowCount() && i < maxRowsToExpand) {
            tree.expandRow(i++);
        }
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    private static CpuTreeNode getNode(Object value) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        return (CpuTreeNode)node.getUserObject();
    }

    private static HTreeChart<MethodModel> setUpChart(@NotNull Range range, @Nullable HNode<MethodModel> node, @NotNull HTreeChart.Orientation orientation, @NotNull CpuProfilerStageView stageView) {
        if (range == null) {
            CpuCaptureView.$$$reportNull$$$0(6);
        }
        if (orientation == null) {
            CpuCaptureView.$$$reportNull$$$0(7);
        }
        if (stageView == null) {
            CpuCaptureView.$$$reportNull$$$0(8);
        }
        HTreeChart chart = new HTreeChart(range, orientation);
        chart.setHRenderer((HRenderer)new SampledMethodUsageHRenderer());
        chart.setHTree(node);
        TreeChartNavigationHandler handler = new TreeChartNavigationHandler((HTreeChart<MethodModel>)chart);
        chart.addMouseListener((MouseListener)handler);
        stageView.getIdeComponents().installNavigationContextMenu((JComponent)chart, ((CpuProfilerStage)stageView.getStage()).getStudioProfilers().getIdeServices().getCodeNavigator(), () -> handler.getCodeLocation());
        return chart;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stageView";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuCaptureView";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orientation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuCaptureView";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "setUpCpuTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setUpCpuTree";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCodeLocation";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setUpChart";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$setUpCpuTree$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MethodNameRenderer
    extends ColoredTreeCellRenderer {
        private MethodNameRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                MethodNameRenderer.$$$reportNull$$$0(0);
            }
            if (value instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)value).getUserObject() instanceof CpuTreeNode) {
                CpuTreeNode node = (CpuTreeNode)((DefaultMutableTreeNode)value).getUserObject();
                if (node.getMethodName().isEmpty()) {
                    this.setIcon(AllIcons.Debugger.ThreadSuspended);
                    this.append(node.getClassName());
                } else {
                    this.setIcon(PlatformIcons.METHOD_ICON);
                    this.append(node.getMethodName() + "()");
                    if (node.getClassName() != null) {
                        this.append(" (" + node.getClassName() + ")", new SimpleTextAttributes(0, (Color)JBColor.GRAY));
                    }
                }
            } else {
                this.append(value.toString());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/profilers/cpu/CpuCaptureView$MethodNameRenderer", "customizeCellRenderer"));
        }
    }

    private static class DoubleValueCellRenderer
    extends ColoredTreeCellRenderer {
        private final Function<CpuTreeNode, Double> myGetter;
        private final boolean myPercentage;
        private final int myAlignment;

        public DoubleValueCellRenderer(Function<CpuTreeNode, Double> getter, boolean percentage, int alignment) {
            this.myGetter = getter;
            this.myPercentage = percentage;
            this.myAlignment = alignment;
            this.setTextAlign(alignment);
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            CpuTreeNode node;
            if (tree == null) {
                DoubleValueCellRenderer.$$$reportNull$$$0(0);
            }
            if ((node = CpuCaptureView.getNode(value)) != null) {
                double v = this.myGetter.apply(node);
                if (this.myPercentage) {
                    CpuTreeNode root = CpuCaptureView.getNode(tree.getModel().getRoot());
                    this.append(String.format("%.2f%%", v / root.getTotal() * 100.0));
                } else {
                    this.append(String.format("%,.0f", v));
                }
            } else {
                this.append(value.toString());
            }
            if (this.myAlignment == 2) {
                this.setIpad(ProfilerLayout.TABLE_COLUMN_CELL_INSETS);
            } else {
                this.setIpad(ProfilerLayout.TABLE_COLUMN_RIGHT_ALIGNED_CELL_INSETS);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/profilers/cpu/CpuCaptureView$DoubleValueCellRenderer", "customizeCellRenderer"));
        }
    }

    private static class DoubleValueNodeComparator
    implements Comparator<DefaultMutableTreeNode> {
        private final Function<CpuTreeNode, Double> myGetter;

        DoubleValueNodeComparator(Function<CpuTreeNode, Double> getter) {
            this.myGetter = getter;
        }

        @Override
        public int compare(DefaultMutableTreeNode a, DefaultMutableTreeNode b) {
            CpuTreeNode o1 = (CpuTreeNode)a.getUserObject();
            CpuTreeNode o2 = (CpuTreeNode)b.getUserObject();
            return Double.compare(this.myGetter.apply(o1), this.myGetter.apply(o2));
        }
    }

    private static class NameValueNodeComparator
    implements Comparator<DefaultMutableTreeNode> {
        private NameValueNodeComparator() {
        }

        @Override
        public int compare(DefaultMutableTreeNode o1, DefaultMutableTreeNode o2) {
            return ((CpuTreeNode)o1.getUserObject()).getMethodName().compareTo(((CpuTreeNode)o2.getUserObject()).getMethodName());
        }
    }

    private static class TreeChartNavigationHandler
    extends MouseAdapter {
        @NotNull
        private final HTreeChart<MethodModel> myChart;
        private Point myLastPopupPoint;

        TreeChartNavigationHandler(@NotNull HTreeChart<MethodModel> chart) {
            if (chart == null) {
                TreeChartNavigationHandler.$$$reportNull$$$0(0);
            }
            this.myChart = chart;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.handlePopup(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.handlePopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.handlePopup(e);
        }

        private void handlePopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.myLastPopupPoint = e.getPoint();
            }
        }

        @Nullable
        private CodeLocation getCodeLocation() {
            HNode n = this.myChart.getNodeAt(this.myLastPopupPoint);
            if (n == null || n.getData() == null) {
                return null;
            }
            MethodModel method = (MethodModel)n.getData();
            return new CodeLocation.Builder(method.getClassName()).setMethodSignature(method.getName(), method.getSignature()).build();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chart", "com/android/tools/profilers/cpu/CpuCaptureView$TreeChartNavigationHandler", "<init>"));
        }
    }

    static class FlameChartView
    extends CaptureDetailsView {
        @NotNull
        private final JPanel myPanel;
        @NotNull
        private final HTreeChart<MethodModel> myChart;
        @NotNull
        private final AspectObserver myObserver;
        @NotNull
        private final CaptureModel.FlameChart myFlameChart;
        @NotNull
        private final Range myMasterRange;

        public FlameChartView(CpuProfilerStageView stageView, @NotNull CaptureModel.FlameChart flameChart) {
            if (flameChart == null) {
                FlameChartView.$$$reportNull$$$0(0);
            }
            this.myFlameChart = flameChart;
            this.myMasterRange = new Range(flameChart.getRange());
            this.myChart = CpuCaptureView.setUpChart(this.myMasterRange, (HNode<MethodModel>)this.myFlameChart.getNode(), HTreeChart.Orientation.BOTTOM_UP, stageView);
            RangeTimeScrollBar horizontalScrollBar = new RangeTimeScrollBar(flameChart.getRange(), this.myMasterRange, TimeUnit.MICROSECONDS);
            horizontalScrollBar.setPreferredSize(new Dimension(horizontalScrollBar.getPreferredSize().width, 10));
            JPanel contentPanel = new JPanel(new BorderLayout());
            contentPanel.add((Component)this.myChart, "Center");
            contentPanel.add((Component)new HTreeChartVerticalScrollBar(this.myChart), "East");
            contentPanel.add((Component)horizontalScrollBar, "South");
            this.myPanel = new JPanel(new CardLayout());
            this.myPanel.add((Component)contentPanel, "Content");
            this.myPanel.add((Component)FlameChartView.getNoDataForRange(), "Empty content");
            this.myObserver = new AspectObserver();
            this.myFlameChart.getAspect().addDependency(this.myObserver).onChange((Enum)CaptureModel.FlameChart.Aspect.NODE, this::nodeChanged);
            this.nodeChanged();
        }

        private void nodeChanged() {
            FlameChartView.switchCardLayout(this.myPanel, this.myFlameChart.getNode() == null);
            this.myChart.setHTree(this.myFlameChart.getNode());
            this.myMasterRange.set(this.myFlameChart.getRange());
        }

        @Override
        @NotNull
        JComponent getComponent() {
            JPanel jPanel = this.myPanel;
            if (jPanel == null) {
                FlameChartView.$$$reportNull$$$0(1);
            }
            return jPanel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "flameChart";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/CpuCaptureView$FlameChartView";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/CpuCaptureView$FlameChartView";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class CallChartView
    extends CaptureDetailsView {
        @NotNull
        private final JPanel myPanel;
        @NotNull
        private final CaptureModel.CallChart myCallChart;
        @NotNull
        private final HTreeChart<MethodModel> myChart;
        private AspectObserver myObserver;

        private CallChartView(@NotNull CpuProfilerStageView stageView, @NotNull CaptureModel.CallChart callChart) {
            if (stageView == null) {
                CallChartView.$$$reportNull$$$0(0);
            }
            if (callChart == null) {
                CallChartView.$$$reportNull$$$0(1);
            }
            this.myCallChart = callChart;
            this.myChart = CpuCaptureView.setUpChart(this.myCallChart.getRange(), (HNode<MethodModel>)this.myCallChart.getNode(), HTreeChart.Orientation.TOP_DOWN, stageView);
            if (this.myCallChart.getNode() == null) {
                this.myPanel = CallChartView.getNoDataForThread();
                return;
            }
            Range selectionRange = stageView.getTimeline().getSelectionRange();
            Range captureRange = ((CpuProfilerStage)stageView.getStage()).getCapture().getRange();
            RangeTimeScrollBar horizontalScrollBar = new RangeTimeScrollBar(captureRange, selectionRange, TimeUnit.MICROSECONDS);
            horizontalScrollBar.setPreferredSize(new Dimension(horizontalScrollBar.getPreferredSize().width, 10));
            JPanel contentPanel = new JPanel(new BorderLayout());
            contentPanel.add((Component)this.myChart, "Center");
            contentPanel.add((Component)new HTreeChartVerticalScrollBar(this.myChart), "East");
            contentPanel.add((Component)horizontalScrollBar, "South");
            this.myPanel = new JPanel(new CardLayout());
            this.myPanel.add((Component)contentPanel, "Content");
            this.myPanel.add((Component)CallChartView.getNoDataForRange(), "Empty content");
            this.myObserver = new AspectObserver();
            this.myCallChart.getRange().addDependency(this.myObserver).onChange((Enum)Range.Aspect.RANGE, this::callChartRangeChanged);
            this.callChartRangeChanged();
        }

        private void callChartRangeChanged() {
            HNode<MethodModel> node = this.myCallChart.getNode();
            assert (node != null);
            Range intersection = this.myCallChart.getRange().getIntersection(new Range((double)node.getStart(), (double)node.getEnd()));
            CallChartView.switchCardLayout(this.myPanel, intersection.isEmpty() || intersection.getLength() == 0.0);
        }

        @Override
        @NotNull
        public JComponent getComponent() {
            JPanel jPanel = this.myPanel;
            if (jPanel == null) {
                CallChartView.$$$reportNull$$$0(2);
            }
            return jPanel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stageView";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callChart";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/CpuCaptureView$CallChartView";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/CpuCaptureView$CallChartView";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class BottomUpView
    extends CaptureDetailsView {
        @NotNull
        private final JPanel myPanel;

        private BottomUpView(@NotNull CpuProfilerStageView view, @NotNull CaptureModel.BottomUp bottomUp) {
            if (view == null) {
                BottomUpView.$$$reportNull$$$0(0);
            }
            if (bottomUp == null) {
                BottomUpView.$$$reportNull$$$0(1);
            }
            final BottomUpTreeModel model = bottomUp.getModel();
            if (model == null) {
                this.myPanel = BottomUpView.getNoDataForThread();
                return;
            }
            this.myPanel = new JPanel(new CardLayout());
            final JTree tree = new JTree();
            int defaultFontHeight = tree.getFontMetrics(tree.getFont()).getHeight();
            tree.setRowHeight(defaultFontHeight + ProfilerLayout.ROW_HEIGHT_PADDING);
            tree.setBorder(ProfilerLayout.TABLE_ROW_BORDER);
            this.myPanel.add((Component)CpuCaptureView.setUpCpuTree(tree, model, view), "Content");
            this.myPanel.add((Component)BottomUpView.getNoDataForRange(), "Empty content");
            tree.setRootVisible(false);
            tree.addTreeWillExpandListener(new TreeWillExpandListener(){

                @Override
                public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
                    ((BottomUpTreeModel)tree.getModel()).expand(node);
                }

                @Override
                public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                }
            });
            model.addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

                protected void process(TreeModelEvent event, TreeModelAdapter.EventType type) {
                    if (type == TreeModelAdapter.EventType.NodesInserted && event.getTreePath().getPathCount() == 1) {
                        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
                        Object[] inserted = event.getChildren();
                        if (inserted != null && inserted.length == root.getChildCount()) {
                            tree.expandPath(new TreePath(root));
                        }
                    }
                    CaptureDetailsView.switchCardLayout(myPanel, model.isEmpty());
                }
            });
            BottomUpView.switchCardLayout(this.myPanel, model.isEmpty());
        }

        @Override
        @NotNull
        public JComponent getComponent() {
            JPanel jPanel = this.myPanel;
            if (jPanel == null) {
                BottomUpView.$$$reportNull$$$0(2);
            }
            return jPanel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "view";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bottomUp";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/CpuCaptureView$BottomUpView";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/CpuCaptureView$BottomUpView";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class TopDownView
    extends CaptureDetailsView {
        @NotNull
        private final JPanel myPanel;

        private TopDownView(@NotNull CpuProfilerStageView view, @NotNull CaptureModel.TopDown topDown) {
            if (view == null) {
                TopDownView.$$$reportNull$$$0(0);
            }
            if (topDown == null) {
                TopDownView.$$$reportNull$$$0(1);
            }
            final TopDownTreeModel model = topDown.getModel();
            if (model == null) {
                this.myPanel = TopDownView.getNoDataForThread();
                return;
            }
            this.myPanel = new JPanel(new CardLayout());
            JTree tree = new JTree();
            int defaultFontHeight = tree.getFontMetrics(tree.getFont()).getHeight();
            tree.setRowHeight(defaultFontHeight + ProfilerLayout.ROW_HEIGHT_PADDING);
            tree.setBorder(ProfilerLayout.TABLE_ROW_BORDER);
            this.myPanel.add((Component)CpuCaptureView.setUpCpuTree(tree, model, view), "Content");
            this.myPanel.add((Component)TopDownView.getNoDataForRange(), "Empty content");
            CpuCaptureView.expandTreeNodes(tree);
            model.addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

                protected void process(TreeModelEvent event, TreeModelAdapter.EventType type) {
                    CaptureDetailsView.switchCardLayout(myPanel, model.isEmpty());
                }
            });
            TopDownView.switchCardLayout(this.myPanel, model.isEmpty());
        }

        @Override
        @NotNull
        public JComponent getComponent() {
            JPanel jPanel = this.myPanel;
            if (jPanel == null) {
                TopDownView.$$$reportNull$$$0(2);
            }
            return jPanel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "view";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topDown";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/CpuCaptureView$TopDownView";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/CpuCaptureView$TopDownView";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ClockTypeCellRenderer
    extends ListCellRendererWrapper<ClockType> {
        private ClockTypeCellRenderer() {
        }

        public void customize(JList list, ClockType value, int index, boolean selected, boolean hasFocus) {
            switch (value) {
                case GLOBAL: {
                    this.setText("Wall Clock Time");
                    break;
                }
                case THREAD: {
                    this.setText("Thread Time");
                    break;
                }
                default: {
                    CpuCaptureView.getLog().warn("Unexpected clock type received.");
                }
            }
        }
    }

    private static abstract class CaptureDetailsView {
        protected static final String CARD_EMPTY_INFO = "Empty content";
        protected static final String CARD_CONTENT = "Content";

        private CaptureDetailsView() {
        }

        @NotNull
        abstract JComponent getComponent();

        protected static void switchCardLayout(@NotNull JPanel panel, boolean isEmpty) {
            if (panel == null) {
                CaptureDetailsView.$$$reportNull$$$0(0);
            }
            CardLayout cardLayout = (CardLayout)panel.getLayout();
            cardLayout.show(panel, isEmpty ? CARD_EMPTY_INFO : CARD_CONTENT);
        }

        protected static JPanel getNoDataForThread() {
            String message = "No data available for the selected thread.";
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)new InfoMessagePanel(message, "", null), "Center");
            return panel;
        }

        protected static JComponent getNoDataForRange() {
            String message = "No data available for the selected time frame.";
            return new InfoMessagePanel(message, "", null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/android/tools/profilers/cpu/CpuCaptureView$CaptureDetailsView", "switchCardLayout"));
        }
    }
}

