/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.simpleperf;

import com.android.tools.adtui.model.Range;
import com.android.tools.profiler.proto.SimpleperfReport;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuThreadInfo;
import com.android.tools.profilers.cpu.MethodModel;
import com.android.tools.profilers.cpu.TraceParser;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class SimplePerfTraceParser
implements TraceParser {
    private static final int INVALID_SYMBOL_ID = -1;
    private final Map<Integer, SimpleperfReport.File> myFiles = new HashMap<Integer, SimpleperfReport.File>();
    private final Map<Integer, String> myThreads;
    final List<SimpleperfReport.Sample> mySamples = new ArrayList<SimpleperfReport.Sample>();
    private final Map<CpuThreadInfo, CaptureNode> myCaptureTrees = new HashMap<CpuThreadInfo, CaptureNode>();
    private final Map<Integer, List<SimpleperfReport.Sample.CallChainEntry>> myLastCallChain = new HashMap<Integer, List<SimpleperfReport.Sample.CallChainEntry>>();
    private final Map<Integer, CaptureNode> myLastCallStackTopNode = new HashMap<Integer, CaptureNode>();
    private long mySampleCount;
    private long myLostSampleCount;
    private Range myRange;

    public SimplePerfTraceParser() {
        this.myThreads = new HashMap<Integer, String>();
    }

    private static String fileNameFromPath(String path) {
        String[] splitPath = path.split("/");
        return splitPath[splitPath.length - 1];
    }

    private static boolean equals(SimpleperfReport.Sample.CallChainEntry c1, SimpleperfReport.Sample.CallChainEntry c2) {
        return c1.getVaddrInFile() == c2.getVaddrInFile() && c1.getFileId() == c2.getFileId() && c1.getSymbolId() == c2.getSymbolId();
    }

    private static Logger getLog() {
        return Logger.getInstance(SimplePerfTraceParser.class);
    }

    private static ByteBuffer byteBufferFromFile(File f, ByteOrder byteOrder) throws IOException {
        try (FileInputStream dataFile = new FileInputStream(f);){
            MappedByteBuffer buffer = dataFile.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, f.length());
            buffer.order(byteOrder);
            MappedByteBuffer mappedByteBuffer = buffer;
            return mappedByteBuffer;
        }
    }

    @Override
    public void parse(File trace) throws IOException {
        this.parseTraceFile(trace);
        this.parseSampleData();
    }

    @Override
    public Map<CpuThreadInfo, CaptureNode> getCaptureTrees() {
        return this.myCaptureTrees;
    }

    @Override
    public Range getRange() {
        return this.myRange;
    }

    public long getLostSampleCount() {
        return this.myLostSampleCount;
    }

    public long getSampleCount() {
        return this.mySampleCount;
    }

    @NotNull
    private static CaptureNode createCaptureNode(String name, long timestamp) {
        CaptureNode node = new CaptureNode();
        node.setMethodModel(new MethodModel(name));
        SimplePerfTraceParser.setNodeStartTime(node, timestamp);
        node.setDepth(0);
        CaptureNode captureNode = node;
        if (captureNode == null) {
            SimplePerfTraceParser.$$$reportNull$$$0(0);
        }
        return captureNode;
    }

    void parseTraceFile(File trace) throws IOException {
        ByteBuffer buffer = SimplePerfTraceParser.byteBufferFromFile(trace, ByteOrder.LITTLE_ENDIAN);
        int recordSize = buffer.getInt();
        while (recordSize != 0) {
            byte[] recordBytes = new byte[recordSize];
            buffer.get(recordBytes);
            SimpleperfReport.Record record = SimpleperfReport.Record.parseFrom((byte[])recordBytes);
            switch (record.getRecordDataCase()) {
                case FILE: {
                    SimpleperfReport.File file = record.getFile();
                    this.myFiles.put(file.getId(), file);
                    break;
                }
                case LOST: {
                    SimpleperfReport.LostSituation situation = record.getLost();
                    this.mySampleCount = situation.getSampleCount();
                    this.myLostSampleCount = situation.getLostCount();
                    break;
                }
                case SAMPLE: {
                    SimpleperfReport.Sample sample = record.getSample();
                    this.mySamples.add(sample);
                    break;
                }
                case THREAD: {
                    SimpleperfReport.Thread thread = record.getThread();
                    this.myThreads.put(thread.getThreadId(), thread.getThreadName());
                    break;
                }
                default: {
                    SimplePerfTraceParser.getLog().warn("Unexpected record data type " + record.getRecordDataCase());
                }
            }
            recordSize = buffer.getInt();
        }
        if ((long)this.mySamples.size() != this.mySampleCount) {
            throw new IllegalStateException("Samples count doesn't match the number of samples read.");
        }
    }

    private void parseSampleData() {
        if (this.mySamples.isEmpty()) {
            return;
        }
        long startTimestamp = this.mySamples.get(0).getTime();
        for (SimpleperfReport.Sample sample : this.mySamples) {
            this.parseCallChain(sample.getCallchainList(), sample.getThreadId(), sample.getTime());
        }
        long endTimestamp = this.mySamples.get(this.mySamples.size() - 1).getTime();
        this.myRange = new Range((double)TimeUnit.NANOSECONDS.toMicros(startTimestamp), (double)TimeUnit.NANOSECONDS.toMicros(endTimestamp));
        Iterator<CaptureNode> iterator = this.myLastCallStackTopNode.values().iterator();
        while (iterator.hasNext()) {
            CaptureNode lastNode;
            for (CaptureNode node = lastNode = iterator.next(); node != null && node.getEnd() == 0L; node = node.getParent()) {
                SimplePerfTraceParser.setNodeEndTime(node, endTimestamp);
            }
        }
    }

    private static void setNodeEndTime(CaptureNode node, long endTimeNs) {
        node.setEndGlobal(TimeUnit.NANOSECONDS.toMicros(endTimeNs));
        node.setEndThread(TimeUnit.NANOSECONDS.toMicros(endTimeNs));
    }

    private static void setNodeStartTime(CaptureNode node, long startTimeNs) {
        node.setStartGlobal(TimeUnit.NANOSECONDS.toMicros(startTimeNs));
        node.setStartThread(TimeUnit.NANOSECONDS.toMicros(startTimeNs));
    }

    private void parseCallChain(List<SimpleperfReport.Sample.CallChainEntry> callChain, int threadId, long timestamp) {
        int newCallChainIndex;
        if (!this.myLastCallStackTopNode.containsKey(threadId)) {
            CaptureNode main = SimplePerfTraceParser.createCaptureNode(this.myThreads.getOrDefault(threadId, "main"), timestamp);
            main.setDepth(0);
            if (!this.myThreads.containsKey(threadId)) {
                throw new IllegalStateException("Malformed trace file: thread with id " + threadId + " not found.");
            }
            this.myCaptureTrees.put(new CpuThreadInfo(threadId, this.myThreads.get(threadId)), main);
            this.myLastCallStackTopNode.put(threadId, main);
            this.myLastCallChain.put(threadId, new LinkedList());
        }
        List<SimpleperfReport.Sample.CallChainEntry> previousCallChain = this.myLastCallChain.get(threadId);
        int previousCallChainIndex = previousCallChain.size() - 1;
        CaptureNode divergentNodeParent = null;
        if (!previousCallChain.isEmpty()) {
            for (newCallChainIndex = callChain.size() - 1; previousCallChainIndex >= 0 && newCallChainIndex >= 0 && SimplePerfTraceParser.equals(previousCallChain.get(previousCallChainIndex), callChain.get(newCallChainIndex)); --previousCallChainIndex, --newCallChainIndex) {
            }
            divergentNodeParent = this.findDivergenceAndUpdateEndTime(previousCallChainIndex, threadId, timestamp);
        }
        if (newCallChainIndex >= 0) {
            divergentNodeParent = divergentNodeParent == null ? this.myLastCallStackTopNode.get(threadId) : divergentNodeParent;
            this.addNewNodes(callChain, divergentNodeParent, newCallChainIndex, timestamp, threadId);
        }
        this.myLastCallChain.put(threadId, callChain);
    }

    private CaptureNode findDivergenceAndUpdateEndTime(int divergenceCount, int tid, long endTimestamp) {
        CaptureNode node = this.myLastCallStackTopNode.get(tid);
        for (int i = 0; i < divergenceCount; ++i) {
            assert (node != null);
            SimplePerfTraceParser.setNodeEndTime(node, endTimestamp);
            node = node.getParent();
        }
        return node;
    }

    private void addNewNodes(List<SimpleperfReport.Sample.CallChainEntry> callChain, CaptureNode node, int startIndex, long startTimestamp, int tid) {
        assert (node != null);
        for (int i = startIndex; i >= 0; --i) {
            CaptureNode child = SimplePerfTraceParser.createCaptureNode(this.parseMethodName(callChain.get(i)), startTimestamp);
            node.addChild(child);
            child.setDepth(node.getDepth() + 1);
            node = child;
        }
        this.myLastCallStackTopNode.put(tid, node);
    }

    private String parseMethodName(SimpleperfReport.Sample.CallChainEntry callChainEntry) {
        String methodName;
        int symbolId = callChainEntry.getSymbolId();
        SimpleperfReport.File symbolFile = this.myFiles.get(callChainEntry.getFileId());
        if (symbolFile == null) {
            throw new IllegalStateException("Symbol file with id \"" + callChainEntry.getFileId() + "\" not found.");
        }
        if (symbolId == -1) {
            String hexAddress = "0x" + Long.toHexString(callChainEntry.getVaddrInFile());
            methodName = SimplePerfTraceParser.fileNameFromPath(symbolFile.getPath()) + "+" + hexAddress;
        } else {
            methodName = symbolFile.getSymbol(symbolId);
        }
        return methodName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/profilers/cpu/simpleperf/SimplePerfTraceParser", "createCaptureNode"));
    }
}

