/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.FlatTabbedPane;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.common.ColumnTreeBuilder;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.RelativeTimeConverter;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.memory.AttributeColumn;
import com.android.tools.profilers.memory.LazyMemoryObjectTreeNode;
import com.android.tools.profilers.memory.MemoryObjectTreeNode;
import com.android.tools.profilers.memory.MemoryProfilerAspect;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.memory.MemoryProfilerStageView;
import com.android.tools.profilers.memory.SimpleColumnRenderer;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.ClassSet;
import com.android.tools.profilers.memory.adapters.ClassifierSet;
import com.android.tools.profilers.memory.adapters.FieldObject;
import com.android.tools.profilers.memory.adapters.HeapSet;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.ReferenceObject;
import com.android.tools.profilers.memory.adapters.ValueObject;
import com.android.tools.profilers.memory.instanceviewers.BitmapViewer;
import com.android.tools.profilers.memory.instanceviewers.InstanceViewer;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.ContextMenuItem;
import com.android.tools.profilers.stacktrace.StackTraceView;
import com.google.common.annotations.VisibleForTesting;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class MemoryInstanceDetailsView
extends AspectObserver {
    private static final String TITLE_TAB_REFERENCES = "References";
    private static final String TITLE_TAB_CALLSTACK = "Call Stack";
    private static final int LABEL_COLUMN_WIDTH = 500;
    private static final int DEFAULT_COLUMN_WIDTH = 80;
    @NotNull
    private final MemoryProfilerStage myStage;
    @NotNull
    private final RelativeTimeConverter myTimeConverter;
    @NotNull
    private final IdeProfilerComponents myIdeProfilerComponents;
    @NotNull
    private final JTabbedPane myTabsPanel;
    @NotNull
    private final StackTraceView myStackTraceView;
    @Nullable
    private JComponent myReferenceColumnTree;
    @Nullable
    private JTree myReferenceTree;
    @NotNull
    private final Map<CaptureObject.InstanceAttribute, AttributeColumn> myAttributeColumns;
    @NotNull
    private final List<InstanceViewer> myInstanceViewers;

    public MemoryInstanceDetailsView(@NotNull MemoryProfilerStage stage, @NotNull IdeProfilerComponents ideProfilerComponents) {
        if (stage == null) {
            MemoryInstanceDetailsView.$$$reportNull$$$0(0);
        }
        if (ideProfilerComponents == null) {
            MemoryInstanceDetailsView.$$$reportNull$$$0(1);
        }
        this.myAttributeColumns = new HashMap<CaptureObject.InstanceAttribute, AttributeColumn>();
        this.myInstanceViewers = new ArrayList<InstanceViewer>();
        this.myStage = stage;
        this.myTimeConverter = this.myStage.getStudioProfilers().getRelativeTimeConverter();
        this.myStage.getAspect().addDependency((AspectObserver)this).onChange((Enum)MemoryProfilerAspect.CURRENT_INSTANCE, this::instanceChanged).onChange((Enum)MemoryProfilerAspect.CURRENT_FIELD_PATH, this::instanceChanged);
        this.myIdeProfilerComponents = ideProfilerComponents;
        this.myTabsPanel = new FlatTabbedPane();
        this.myTabsPanel.addChangeListener(this::trackActiveTab);
        this.myStackTraceView = ideProfilerComponents.createStackView(stage.getStackTraceModel());
        this.myInstanceViewers.add(new BitmapViewer());
        this.myAttributeColumns.put(CaptureObject.InstanceAttribute.LABEL, new AttributeColumn("Reference", () -> new SimpleColumnRenderer(node -> {
            StringBuilder builder = new StringBuilder();
            if (node.getAdapter() instanceof ReferenceObject) {
                builder.append(((ValueObject)node.getAdapter()).getName());
                builder.append(" in ");
            }
            builder.append(((ValueObject)node.getAdapter()).getValueText());
            return builder.toString();
        }, value -> MemoryProfilerStageView.getValueObjectIcon((ValueObject)value.getAdapter()), 2), 2, 500, Comparator.comparing(o -> ((ValueObject)o.getAdapter()).getName())));
        this.myAttributeColumns.put(CaptureObject.InstanceAttribute.DEPTH, new AttributeColumn("Depth", () -> new SimpleColumnRenderer(value -> {
            int depth = ((ValueObject)value.getAdapter()).getDepth();
            if (depth >= 0 && depth < Integer.MAX_VALUE) {
                return Integer.toString(depth);
            }
            return "";
        }, value -> null, 4), 4, 80, Comparator.comparingInt(o -> ((ValueObject)o.getAdapter()).getDepth())));
        this.myAttributeColumns.put(CaptureObject.InstanceAttribute.ALLOCATION_TIME, new AttributeColumn("Alloc Time", () -> new SimpleColumnRenderer(value -> {
            InstanceObject instanceObject;
            Object node = value.getAdapter();
            if (node instanceof InstanceObject && (instanceObject = (InstanceObject)node).getAllocTime() > Long.MIN_VALUE) {
                return TimeAxisFormatter.DEFAULT.getFixedPointFormattedString(TimeUnit.MILLISECONDS.toMicros(1L), TimeUnit.NANOSECONDS.toMicros(this.myTimeConverter.convertToRelativeTime(instanceObject.getAllocTime())));
            }
            return "";
        }, value -> null, 4), 4, 80, Comparator.comparingLong(o -> ((InstanceObject)o.getAdapter()).getAllocTime())));
        this.myAttributeColumns.put(CaptureObject.InstanceAttribute.DEALLOCATION_TIME, new AttributeColumn("Dealloc Time", () -> new SimpleColumnRenderer(value -> {
            InstanceObject instanceObject;
            Object node = value.getAdapter();
            if (node instanceof InstanceObject && (instanceObject = (InstanceObject)node).getDeallocTime() < Long.MAX_VALUE) {
                return TimeAxisFormatter.DEFAULT.getFixedPointFormattedString(TimeUnit.MILLISECONDS.toMicros(1L), TimeUnit.NANOSECONDS.toMicros(this.myTimeConverter.convertToRelativeTime(instanceObject.getDeallocTime())));
            }
            return "";
        }, value -> null, 4), 4, 80, Comparator.comparingLong(o -> ((InstanceObject)o.getAdapter()).getDeallocTime())));
        this.myAttributeColumns.put(CaptureObject.InstanceAttribute.NATIVE_SIZE, new AttributeColumn("Native Size", () -> new SimpleColumnRenderer(value -> ((ValueObject)value.getAdapter()).getNativeSize() != -1L ? Long.toString(((ValueObject)value.getAdapter()).getNativeSize()) : "", value -> null, 4), 4, 80, Comparator.comparingLong(o -> ((ValueObject)o.getAdapter()).getNativeSize())));
        this.myAttributeColumns.put(CaptureObject.InstanceAttribute.SHALLOW_SIZE, new AttributeColumn("Shallow Size", () -> new SimpleColumnRenderer(value -> ((ValueObject)value.getAdapter()).getShallowSize() != -1 ? Integer.toString(((ValueObject)value.getAdapter()).getShallowSize()) : "", value -> null, 4), 4, 80, Comparator.comparingInt(o -> ((ValueObject)o.getAdapter()).getShallowSize())));
        this.myAttributeColumns.put(CaptureObject.InstanceAttribute.RETAINED_SIZE, new AttributeColumn("Retained Size", () -> new SimpleColumnRenderer(value -> ((ValueObject)value.getAdapter()).getRetainedSize() != -1L ? Long.toString(((ValueObject)value.getAdapter()).getRetainedSize()) : "", value -> null, 4), 4, 80, Comparator.comparingLong(o -> ((ValueObject)o.getAdapter()).getRetainedSize())));
        this.instanceChanged();
    }

    private void trackActiveTab(ChangeEvent event) {
        if (this.myTabsPanel.getSelectedIndex() < 0) {
            return;
        }
        FeatureTracker featureTracker = this.myStage.getStudioProfilers().getIdeServices().getFeatureTracker();
        switch (this.myTabsPanel.getTitleAt(this.myTabsPanel.getSelectedIndex())) {
            case "References": {
                featureTracker.trackSelectMemoryReferences();
                break;
            }
            case "Call Stack": {
                featureTracker.trackSelectMemoryStack();
                break;
            }
        }
    }

    @NotNull
    JComponent getComponent() {
        JTabbedPane jTabbedPane = this.myTabsPanel;
        if (jTabbedPane == null) {
            MemoryInstanceDetailsView.$$$reportNull$$$0(2);
        }
        return jTabbedPane;
    }

    @VisibleForTesting
    @Nullable
    JTree getReferenceTree() {
        return this.myReferenceTree;
    }

    @VisibleForTesting
    @Nullable
    JComponent getReferenceColumnTree() {
        return this.myReferenceColumnTree;
    }

    private void instanceChanged() {
        List<CodeLocation> callStack;
        InstanceObject fieldInstance;
        CaptureObject capture = this.myStage.getSelectedCapture();
        InstanceObject instance = this.myStage.getSelectedInstanceObject();
        List<FieldObject> fieldPath = this.myStage.getSelectedFieldObjectPath();
        if (capture == null || instance == null) {
            this.myReferenceTree = null;
            this.myReferenceColumnTree = null;
            this.myTabsPanel.setVisible(false);
            return;
        }
        this.myTabsPanel.removeAll();
        boolean hasContent = false;
        if (!fieldPath.isEmpty() && (fieldInstance = fieldPath.get(fieldPath.size() - 1).getAsInstance()) != null) {
            instance = fieldInstance;
        }
        this.myReferenceColumnTree = this.buildReferenceColumnTree(capture, instance);
        if (this.myReferenceColumnTree != null) {
            this.myTabsPanel.addTab(TITLE_TAB_REFERENCES, this.myReferenceColumnTree);
            hasContent = true;
        }
        if (!(callStack = instance.getCodeLocations()).isEmpty()) {
            this.myStackTraceView.getModel().setStackFrames(instance.getAllocationThreadId(), callStack);
            JComponent stackTraceView = this.myStackTraceView.getComponent();
            stackTraceView.setBorder(AdtUiUtils.DEFAULT_TOP_BORDER);
            this.myTabsPanel.addTab(TITLE_TAB_CALLSTACK, stackTraceView);
            hasContent = true;
        }
        InstanceObject finalInstance = instance;
        this.myInstanceViewers.forEach(viewer -> {
            JComponent component = viewer.createComponent(this.myIdeProfilerComponents, capture, finalInstance);
            if (component != null) {
                this.myTabsPanel.addTab(viewer.getTitle(), component);
            }
        });
        this.myTabsPanel.setVisible(hasContent);
    }

    @Nullable
    private JComponent buildReferenceColumnTree(@NotNull CaptureObject captureObject, @NotNull InstanceObject instance) {
        if (captureObject == null) {
            MemoryInstanceDetailsView.$$$reportNull$$$0(3);
        }
        if (instance == null) {
            MemoryInstanceDetailsView.$$$reportNull$$$0(4);
        }
        if (instance.getReferences().isEmpty()) {
            this.myReferenceTree = null;
            return null;
        }
        this.myReferenceTree = this.buildTree(instance);
        ColumnTreeBuilder builder = new ColumnTreeBuilder(this.myReferenceTree);
        for (CaptureObject.InstanceAttribute attribute : captureObject.getInstanceAttributes()) {
            ColumnTreeBuilder.ColumnBuilder column = this.myAttributeColumns.get((Object)attribute).getBuilder();
            if (attribute == CaptureObject.InstanceAttribute.DEPTH) {
                column.setInitialOrder(attribute.getSortOrder());
            }
            builder.addColumn(column);
        }
        builder.setTreeSorter((comparator, sortOrder) -> {
            assert (this.myReferenceTree.getModel() instanceof DefaultTreeModel);
            DefaultTreeModel treeModel = (DefaultTreeModel)this.myReferenceTree.getModel();
            assert (treeModel.getRoot() instanceof MemoryObjectTreeNode);
            MemoryObjectTreeNode root = (MemoryObjectTreeNode)treeModel.getRoot();
            root.sort(comparator);
            treeModel.nodeStructureChanged(root);
        });
        builder.setHoverColor(ProfilerColors.DEFAULT_HOVER_COLOR);
        builder.setBackground(ProfilerColors.DEFAULT_BACKGROUND);
        builder.setBorder(AdtUiUtils.DEFAULT_TOP_BORDER);
        builder.setShowVerticalLines(true);
        return builder.build();
    }

    @VisibleForTesting
    @NotNull
    JTree buildTree(@NotNull InstanceObject instance) {
        Object root;
        if (instance == null) {
            MemoryInstanceDetailsView.$$$reportNull$$$0(5);
        }
        Comparator comparator = null;
        if (this.myReferenceTree != null && this.myReferenceTree.getModel() != null && this.myReferenceTree.getModel().getRoot() != null && (root = this.myReferenceTree.getModel().getRoot()) instanceof ReferenceTreeNode) {
            comparator = ((ReferenceTreeNode)root).getComparator();
        }
        ReferenceTreeNode treeRoot = new ReferenceTreeNode(instance);
        treeRoot.expandNode();
        if (comparator != null) {
            treeRoot.sort(comparator);
        }
        final DefaultTreeModel treeModel = new DefaultTreeModel(treeRoot);
        final JTree tree = new JTree(treeModel);
        int defaultFontHeight = tree.getFontMetrics(tree.getFont()).getHeight();
        tree.setRowHeight(defaultFontHeight + ProfilerLayout.ROW_HEIGHT_PADDING);
        tree.setBorder(ProfilerLayout.TABLE_ROW_BORDER);
        tree.setRootVisible(true);
        tree.setShowsRootHandles(true);
        tree.getSelectionModel().setSelectionMode(1);
        tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                TreePath path = event.getPath();
                assert (path.getLastPathComponent() instanceof MemoryObjectTreeNode);
                ReferenceTreeNode treeNode = (ReferenceTreeNode)path.getLastPathComponent();
                treeNode.expandNode();
                treeModel.nodeStructureChanged(treeNode);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        this.myIdeProfilerComponents.installNavigationContextMenu(tree, this.myStage.getStudioProfilers().getIdeServices().getCodeNavigator(), () -> {
            TreePath selection = tree.getSelectionPath();
            if (selection == null) {
                return null;
            }
            Object memoryObject = ((MemoryObjectTreeNode)selection.getLastPathComponent()).getAdapter();
            if (memoryObject instanceof InstanceObject) {
                return new CodeLocation.Builder(((InstanceObject)memoryObject).getClassEntry().getClassName()).build();
            }
            assert (memoryObject instanceof ReferenceObject);
            return new CodeLocation.Builder(((ReferenceObject)memoryObject).getReferenceInstance().getClassEntry().getClassName()).build();
        });
        this.myIdeProfilerComponents.installContextMenu(tree, new ContextMenuItem(){

            @Override
            @NotNull
            public String getText() {
                if ("Go to Instance" == null) {
                    2.$$$reportNull$$$0(0);
                }
                return "Go to Instance";
            }

            @Override
            @Nullable
            public Icon getIcon() {
                return null;
            }

            @Override
            public boolean isEnabled() {
                return tree.getSelectionPath() != null;
            }

            @Override
            public void run() {
                CaptureObject captureObject = MemoryInstanceDetailsView.this.myStage.getSelectedCapture();
                TreePath selection = tree.getSelectionPath();
                assert (captureObject != null && selection != null);
                Object memoryObject = ((MemoryObjectTreeNode)selection.getLastPathComponent()).getAdapter();
                if (memoryObject instanceof InstanceObject) {
                    assert (memoryObject == MemoryInstanceDetailsView.this.myStage.getSelectedInstanceObject());
                } else {
                    assert (memoryObject instanceof ReferenceObject);
                    InstanceObject targetInstance = ((ReferenceObject)memoryObject).getReferenceInstance();
                    HeapSet heapSet = captureObject.getHeapSet(targetInstance.getHeapId());
                    assert (heapSet != null);
                    MemoryInstanceDetailsView.this.myStage.selectHeapSet(heapSet);
                    ClassifierSet classifierSet = heapSet.findContainingClassifierSet(targetInstance);
                    assert (classifierSet != null && classifierSet instanceof ClassSet);
                    MemoryInstanceDetailsView.this.myStage.selectClassSet((ClassSet)classifierSet);
                    MemoryInstanceDetailsView.this.myStage.selectInstanceObject(targetInstance);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/profilers/memory/MemoryInstanceDetailsView$2", "getText"));
            }
        });
        tree.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (tree.getSelectionCount() == 0 && tree.getRowCount() != 0) {
                    tree.setSelectionRow(0);
                }
            }
        });
        JTree jTree = tree;
        if (jTree == null) {
            MemoryInstanceDetailsView.$$$reportNull$$$0(6);
        }
        return jTree;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideProfilerComponents";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/MemoryInstanceDetailsView";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "captureObject";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/MemoryInstanceDetailsView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildReferenceColumnTree";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildTree";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ReferenceTreeNode
    extends LazyMemoryObjectTreeNode<ValueObject> {
        @Nullable
        private List<ReferenceObject> myReferenceObjects;

        private ReferenceTreeNode(@NotNull ValueObject valueObject) {
            if (valueObject == null) {
                ReferenceTreeNode.$$$reportNull$$$0(0);
            }
            super(valueObject, false);
            this.myReferenceObjects = null;
        }

        @Override
        public int computeChildrenCount() {
            if (this.myReferenceObjects == null) {
                this.myReferenceObjects = this.getAdapter() instanceof InstanceObject ? ((InstanceObject)this.getAdapter()).getReferences() : (this.getAdapter() instanceof ReferenceObject ? ((ReferenceObject)this.getAdapter()).getReferenceInstance().getReferences() : Collections.emptyList());
            }
            return this.myReferenceObjects.size();
        }

        @Override
        public void expandNode() {
            this.getChildCount();
            assert (this.myReferenceObjects != null);
            if (this.myMemoizedChildrenCount != this.myChildren.size()) {
                this.myReferenceObjects.forEach(reference -> {
                    ReferenceTreeNode node = new ReferenceTreeNode((ValueObject)reference);
                    node.setTreeModel(this.getTreeModel());
                    this.add(node);
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueObject", "com/android/tools/profilers/memory/MemoryInstanceDetailsView$ReferenceTreeNode", "<init>"));
        }
    }
}

