/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.Profiler;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerMonitor;
import com.android.tools.profilers.StudioProfiler;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.memory.AllocationInfosDataSeries;
import com.android.tools.profilers.memory.MemoryMonitor;
import com.intellij.openapi.diagnostic.Logger;
import io.grpc.StatusRuntimeException;
import org.jetbrains.annotations.NotNull;

public class MemoryProfiler
extends StudioProfiler {
    @NotNull
    private final AspectObserver myAspectObserver;

    private static Logger getLogger() {
        return Logger.getInstance(MemoryProfiler.class);
    }

    public MemoryProfiler(@NotNull StudioProfilers profilers) {
        if (profilers == null) {
            MemoryProfiler.$$$reportNull$$$0(0);
        }
        super(profilers);
        this.myAspectObserver = new AspectObserver();
        this.myProfilers.addDependency(this.myAspectObserver).onChange((Enum)ProfilerAspect.AGENT, this::agentStatusChanged);
    }

    @Override
    public ProfilerMonitor newMonitor() {
        return new MemoryMonitor(this.myProfilers);
    }

    @Override
    public void startProfiling(Common.Session session, Profiler.Process process) {
        this.myProfilers.getClient().getMemoryClient().startMonitoringApp(MemoryProfiler.MemoryStartRequest.newBuilder().setProcessId(process.getPid()).setSession(session).build());
        try {
            if (this.myProfilers.isLiveAllocationEnabled()) {
                this.myProfilers.getClient().getMemoryClient().resumeTrackAllocations(MemoryProfiler.ResumeTrackAllocationsRequest.newBuilder().setProcessId(process.getPid()).setSession(session).build());
            }
        }
        catch (StatusRuntimeException e) {
            MemoryProfiler.getLogger().info((Throwable)e);
        }
    }

    @Override
    public void stopProfiling(Common.Session session, Profiler.Process process) {
        try {
            if (this.myProfilers.isLiveAllocationEnabled()) {
                this.myProfilers.getClient().getMemoryClient().suspendTrackAllocations(MemoryProfiler.SuspendTrackAllocationsRequest.newBuilder().setProcessId(process.getPid()).setSession(session).build());
            }
        }
        catch (StatusRuntimeException e) {
            MemoryProfiler.getLogger().info((Throwable)e);
        }
        this.myProfilers.getClient().getMemoryClient().stopMonitoringApp(MemoryProfiler.MemoryStopRequest.newBuilder().setProcessId(process.getPid()).setSession(session).build());
    }

    private void agentStatusChanged() {
        if (!this.myProfilers.isLiveAllocationEnabled()) {
            return;
        }
        Common.Session session = this.myProfilers.getSession();
        Profiler.Process process = this.myProfilers.getProcess();
        if (session == null || process == null) {
            return;
        }
        AllocationInfosDataSeries allocationSeries = new AllocationInfosDataSeries(this.myProfilers.getClient().getMemoryClient(), session, process.getPid(), this.myProfilers.getRelativeTimeConverter(), this.myProfilers.getIdeServices().getFeatureTracker(), null);
        if (!allocationSeries.getDataForXRange(this.myProfilers.getTimeline().getDataRange()).isEmpty()) {
            return;
        }
        Profiler.TimeResponse timeResponse = this.myProfilers.getClient().getProfilerClient().getCurrentTime(Profiler.TimeRequest.newBuilder().setSession(session).build());
        long timeNs = timeResponse.getTimestampNs();
        try {
            this.myProfilers.getClient().getMemoryClient().trackAllocations(MemoryProfiler.TrackAllocationsRequest.newBuilder().setRequestTime(timeNs).setSession(session).setProcessId(process.getPid()).setEnabled(false).build());
            this.myProfilers.getClient().getMemoryClient().trackAllocations(MemoryProfiler.TrackAllocationsRequest.newBuilder().setRequestTime(timeNs).setSession(session).setProcessId(process.getPid()).setEnabled(true).build());
        }
        catch (StatusRuntimeException e) {
            MemoryProfiler.getLogger().info((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profilers", "com/android/tools/profilers/memory/MemoryProfiler", "<init>"));
    }
}

