/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.ClassSet;
import com.android.tools.profilers.memory.adapters.ClassifierSet;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class PackageSet
extends ClassifierSet {
    @NotNull
    private final CaptureObject myCaptureObject;
    private final int myPackageNameIndex;

    @NotNull
    public static ClassifierSet.Classifier createDefaultClassifier(@NotNull CaptureObject captureObject) {
        if (captureObject == null) {
            PackageSet.$$$reportNull$$$0(0);
        }
        PackageClassifier packageClassifier = new PackageClassifier(captureObject, 0);
        if (packageClassifier == null) {
            PackageSet.$$$reportNull$$$0(1);
        }
        return packageClassifier;
    }

    public PackageSet(@NotNull CaptureObject captureObject, @NotNull String packageElementName, int packageNameIndex) {
        if (captureObject == null) {
            PackageSet.$$$reportNull$$$0(2);
        }
        if (packageElementName == null) {
            PackageSet.$$$reportNull$$$0(3);
        }
        super(packageElementName);
        this.myCaptureObject = captureObject;
        this.myPackageNameIndex = packageNameIndex;
    }

    @Override
    @NotNull
    public ClassifierSet.Classifier createSubClassifier() {
        PackageClassifier packageClassifier = new PackageClassifier(this.myCaptureObject, this.myPackageNameIndex + 1);
        if (packageClassifier == null) {
            PackageSet.$$$reportNull$$$0(4);
        }
        return packageClassifier;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "captureObject";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/adapters/PackageSet";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageElementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/adapters/PackageSet";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultClassifier";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createSubClassifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultClassifier";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class PackageClassifier
    extends ClassifierSet.Classifier {
        @NotNull
        private final Map<String, PackageSet> myPackageElements;
        @NotNull
        private final Map<ClassDb.ClassEntry, ClassSet> myClassMap;
        @NotNull
        private final CaptureObject myCaptureObject;
        private final int myPackageNameIndex;

        private PackageClassifier(@NotNull CaptureObject captureObject, int packageNameIndex) {
            if (captureObject == null) {
                PackageClassifier.$$$reportNull$$$0(0);
            }
            this.myPackageElements = new LinkedHashMap<String, PackageSet>();
            this.myClassMap = new LinkedHashMap<ClassDb.ClassEntry, ClassSet>();
            this.myCaptureObject = captureObject;
            this.myPackageNameIndex = packageNameIndex;
        }

        @Override
        @NotNull
        public ClassifierSet getOrCreateClassifierSet(@NotNull InstanceObject instance) {
            if (instance == null) {
                PackageClassifier.$$$reportNull$$$0(1);
            }
            if (this.myPackageNameIndex >= instance.getClassEntry().getSplitPackageName().length) {
                ClassifierSet classifierSet = this.myClassMap.computeIfAbsent(instance.getClassEntry(), ClassSet::new);
                if (classifierSet == null) {
                    PackageClassifier.$$$reportNull$$$0(2);
                }
                return classifierSet;
            }
            ClassifierSet classifierSet = this.myPackageElements.computeIfAbsent(instance.getClassEntry().getSplitPackageName()[this.myPackageNameIndex], name -> new PackageSet(this.myCaptureObject, (String)name, this.myPackageNameIndex));
            if (classifierSet == null) {
                PackageClassifier.$$$reportNull$$$0(3);
            }
            return classifierSet;
        }

        @Override
        @NotNull
        public List<ClassifierSet> getClassifierSets() {
            List<ClassifierSet> list = Stream.concat(this.myPackageElements.values().stream(), this.myClassMap.values().stream()).filter(child -> !child.isEmpty()).collect(Collectors.toList());
            if (list == null) {
                PackageClassifier.$$$reportNull$$$0(4);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "captureObject";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "instance";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/memory/adapters/PackageSet$PackageClassifier";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/memory/adapters/PackageSet$PackageClassifier";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrCreateClassifierSet";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClassifierSets";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getOrCreateClassifierSet";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

