/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.profilers.network.HttpData;
import com.android.tools.profilers.network.NetworkConnectionsModel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpDataFetcher
implements Updatable {
    private static final long FETCH_FREQUENCY = TimeUnit.MILLISECONDS.toNanos(250L);
    private final AspectObserver myAspectObserver;
    @NotNull
    private final NetworkConnectionsModel myConnectionsModel;
    @NotNull
    private final Range myRange;
    @NotNull
    private final List<Listener> myListeners;
    @Nullable
    private List<HttpData> myDataList;
    private long myAccumNs;

    public HttpDataFetcher(@NotNull NetworkConnectionsModel connectionsModel, @NotNull Range range) {
        if (connectionsModel == null) {
            HttpDataFetcher.$$$reportNull$$$0(0);
        }
        if (range == null) {
            HttpDataFetcher.$$$reportNull$$$0(1);
        }
        this.myAspectObserver = new AspectObserver();
        this.myListeners = new ArrayList<Listener>();
        this.myConnectionsModel = connectionsModel;
        this.myRange = range;
        this.myRange.addDependency(this.myAspectObserver).onChange((Enum)Range.Aspect.RANGE, this::pollImmediately);
        this.pollImmediately();
    }

    public void addListener(@NotNull Listener listener) {
        if (listener == null) {
            HttpDataFetcher.$$$reportNull$$$0(2);
        }
        this.myListeners.add(listener);
        if (this.myDataList != null) {
            this.fireListeners(this.myDataList);
        }
    }

    public void update(long elapsedNs) {
        this.myAccumNs += elapsedNs;
        if (this.myAccumNs < FETCH_FREQUENCY && this.myDataList != null) {
            return;
        }
        this.myAccumNs = 0L;
        if (this.myDataList == null || this.stillDownloading(this.myDataList)) {
            this.myDataList = !this.myRange.isEmpty() ? this.myConnectionsModel.getData(this.myRange) : new ArrayList<HttpData>();
            this.fireListeners(this.myDataList);
        }
    }

    private void pollImmediately() {
        this.myDataList = null;
        this.update(0L);
    }

    private void fireListeners(@NotNull List<HttpData> dataList) {
        if (dataList == null) {
            HttpDataFetcher.$$$reportNull$$$0(3);
        }
        for (Listener l : this.myListeners) {
            l.onUpdated(dataList);
        }
    }

    private boolean stillDownloading(@NotNull List<HttpData> dataList) {
        if (dataList == null) {
            HttpDataFetcher.$$$reportNull$$$0(4);
        }
        for (HttpData data : dataList) {
            if (data.getEndTimeUs() != 0L) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionsModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataList";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/profilers/network/HttpDataFetcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addListener";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fireListeners";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "stillDownloading";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Listener {
        public void onUpdated(@NotNull List<HttpData> var1);
    }
}

