/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.NetworkProfiler;
import com.android.tools.profiler.proto.NetworkServiceGrpc;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class NetworkTrafficDataSeries
implements DataSeries<Long> {
    @NotNull
    private NetworkServiceGrpc.NetworkServiceBlockingStub myClient;
    private final int myProcessId;
    private final Common.Session mySession;
    private final Type myType;

    public NetworkTrafficDataSeries(@NotNull NetworkServiceGrpc.NetworkServiceBlockingStub client, int id, Common.Session session, Type type) {
        if (client == null) {
            NetworkTrafficDataSeries.$$$reportNull$$$0(0);
        }
        this.myClient = client;
        this.myProcessId = id;
        this.mySession = session;
        this.myType = type;
    }

    public List<SeriesData<Long>> getDataForXRange(@NotNull Range timeCurrentRangeUs) {
        if (timeCurrentRangeUs == null) {
            NetworkTrafficDataSeries.$$$reportNull$$$0(1);
        }
        ArrayList<SeriesData<Long>> seriesData = new ArrayList<SeriesData<Long>>();
        long bufferNs = TimeUnit.SECONDS.toNanos(1L);
        NetworkProfiler.NetworkDataRequest.Builder dataRequestBuilder = NetworkProfiler.NetworkDataRequest.newBuilder().setProcessId(this.myProcessId).setSession(this.mySession).setType(NetworkProfiler.NetworkDataRequest.Type.SPEED).setStartTimestamp(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMin()) - bufferNs).setEndTimestamp(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMax()) + bufferNs);
        NetworkProfiler.NetworkDataResponse response = this.myClient.getData(dataRequestBuilder.build());
        for (NetworkProfiler.NetworkProfilerData data : response.getDataList()) {
            long xTimestamp = TimeUnit.NANOSECONDS.toMicros(data.getBasicInfo().getEndTimestamp());
            NetworkProfiler.SpeedData speedData = data.getSpeedData();
            seriesData.add((SeriesData<Long>)new SeriesData(xTimestamp, (Object)this.myType.getBytes(speedData)));
        }
        return seriesData;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeCurrentRangeUs";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/profilers/network/NetworkTrafficDataSeries";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getDataForXRange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum Type {
        BYTES_RECEIVED("Receiving", "Received"){

            @Override
            long getBytes(@NotNull NetworkProfiler.SpeedData data) {
                if (data == null) {
                    1.$$$reportNull$$$0(0);
                }
                return data.getReceived();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/profilers/network/NetworkTrafficDataSeries$Type$1", "getBytes"));
            }
        }
        ,
        BYTES_SENT("Sending", "Sent"){

            @Override
            long getBytes(@NotNull NetworkProfiler.SpeedData data) {
                if (data == null) {
                    2.$$$reportNull$$$0(0);
                }
                return data.getSent();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/profilers/network/NetworkTrafficDataSeries$Type$2", "getBytes"));
            }
        };

        private final String myLabel;
        private final String myTooltipLabel;

        private Type(String label, String tooltipLabel) {
            this.myLabel = label;
            this.myTooltipLabel = tooltipLabel;
        }

        @NotNull
        public String getLabel(boolean tooltip) {
            String string = tooltip ? this.myTooltipLabel : this.myLabel;
            if (string == null) {
                Type.$$$reportNull$$$0(0);
            }
            return string;
        }

        abstract long getBytes(@NotNull NetworkProfiler.SpeedData var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/profilers/network/NetworkTrafficDataSeries$Type", "getLabel"));
        }
    }
}

