/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.npw.module.ChooseModuleTypeStep;
import com.android.tools.idea.npw.module.ModuleDescriptionProvider;
import com.android.tools.idea.npw.module.ModuleGalleryEntry;
import com.android.tools.idea.npw.module.NewModuleModel;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.ui.wizard.StudioWizardDialogBuilder;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.Nullable;

public class AndroidNewModuleAction
extends AnAction
implements DumbAware {
    public AndroidNewModuleAction() {
        super(AndroidBundle.message("android.wizard.module.new.module.menu", new Object[0]), AndroidBundle.message("android.wizard.module.new.module.menu.description", new Object[0]), null);
    }

    public AndroidNewModuleAction(@Nullable String text, @Nullable String description, @Nullable Icon icon) {
        super(text, description, icon);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        if (project != null) {
            if (!AndroidSdkUtils.isAndroidSdkAvailable()) {
                SdkQuickfixUtils.showSdkMissingDialog();
                return;
            }
            ArrayList<ModuleGalleryEntry> moduleDescriptions = new ArrayList<ModuleGalleryEntry>();
            for (ModuleDescriptionProvider provider : (ModuleDescriptionProvider[])ModuleDescriptionProvider.EP_NAME.getExtensions()) {
                moduleDescriptions.addAll(provider.getDescriptions());
            }
            ChooseModuleTypeStep chooseModuleTypeStep = new ChooseModuleTypeStep(new NewModuleModel(project), moduleDescriptions);
            ModelWizard wizard = new ModelWizard.Builder(new ModelWizardStep[0]).addStep(chooseModuleTypeStep).build();
            new StudioWizardDialogBuilder(wizard, AndroidBundle.message("android.wizard.module.new.module.title", new Object[0])).setUseNewUx(true).build().show();
        }
    }
}

