/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer;

import com.android.ide.common.process.ProcessException;
import com.android.tools.apk.analyzer.AaptInvoker;
import com.android.tools.apk.analyzer.AndroidApplicationInfo;
import com.android.tools.apk.analyzer.ApkSizeCalculator;
import com.android.tools.apk.analyzer.Archive;
import com.android.tools.apk.analyzer.ArchiveNode;
import com.android.tools.apk.analyzer.ArchiveTreeStructure;
import com.android.tools.idea.apk.viewer.ApkViewPanel;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.log.LogWrapper;
import com.android.utils.ILogger;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class ApkParser {
    private static final ListeningExecutorService ourExecutorService = MoreExecutors.listeningDecorator((ExecutorService)PooledThreadExecutor.INSTANCE);
    private final Archive myArchive;
    private final ApkSizeCalculator myApkSizeCalculator;
    private ListenableFuture<ArchiveNode> myTreeStructure;
    private ListenableFuture<Long> myCompressedFullApkSize;

    public ApkParser(@NotNull Archive archive, @NotNull ApkSizeCalculator sizeCalculator) {
        if (archive == null) {
            ApkParser.$$$reportNull$$$0(0);
        }
        if (sizeCalculator == null) {
            ApkParser.$$$reportNull$$$0(1);
        }
        this.myArchive = archive;
        this.myApkSizeCalculator = sizeCalculator;
    }

    @NotNull
    public synchronized ListenableFuture<ArchiveNode> constructTreeStructure() {
        if (this.myTreeStructure == null) {
            this.myTreeStructure = ourExecutorService.submit(this::createTreeNode);
        }
        ListenableFuture<ArchiveNode> listenableFuture = this.myTreeStructure;
        if (listenableFuture == null) {
            ApkParser.$$$reportNull$$$0(2);
        }
        return listenableFuture;
    }

    public ArchiveNode updateTreeWithDownloadSizes(@NotNull ArchiveNode root) {
        if (root == null) {
            ApkParser.$$$reportNull$$$0(3);
        }
        ArchiveTreeStructure.updateDownloadFileSizes((ArchiveNode)root, (ApkSizeCalculator)this.myApkSizeCalculator);
        return root;
    }

    @NotNull
    public synchronized ListenableFuture<AndroidApplicationInfo> getApplicationInfo(@Nullable Archive archive) {
        ListenableFuture listenableFuture = ourExecutorService.submit(() -> ApkParser.getAppInfo(archive));
        if (listenableFuture == null) {
            ApkParser.$$$reportNull$$$0(4);
        }
        return listenableFuture;
    }

    @NotNull
    public synchronized ListenableFuture<Long> getUncompressedApkSize() {
        ListenableFuture listenableFuture = ourExecutorService.submit(() -> this.myApkSizeCalculator.getFullApkRawSize(this.myArchive.getPath()));
        if (listenableFuture == null) {
            ApkParser.$$$reportNull$$$0(5);
        }
        return listenableFuture;
    }

    @NotNull
    public synchronized ListenableFuture<Long> getCompressedFullApkSize() {
        if (this.myCompressedFullApkSize == null) {
            this.myCompressedFullApkSize = ourExecutorService.submit(() -> this.myApkSizeCalculator.getFullApkDownloadSize(this.myArchive.getPath()));
        }
        ListenableFuture<Long> listenableFuture = this.myCompressedFullApkSize;
        if (listenableFuture == null) {
            ApkParser.$$$reportNull$$$0(6);
        }
        return listenableFuture;
    }

    @NotNull
    private ArchiveNode createTreeNode() throws IOException {
        ArchiveNode node = ArchiveTreeStructure.create((Archive)this.myArchive);
        ArchiveTreeStructure.updateRawFileSizes((ArchiveNode)node, (ApkSizeCalculator)this.myApkSizeCalculator);
        ArchiveNode archiveNode = node;
        if (archiveNode == null) {
            ApkParser.$$$reportNull$$$0(7);
        }
        return archiveNode;
    }

    @NotNull
    public static AndroidApplicationInfo getAppInfo(@Nullable Archive archive) {
        AndroidApplicationInfo androidApplicationInfo;
        if (archive == null) {
            AndroidApplicationInfo androidApplicationInfo2 = AndroidApplicationInfo.UNKNOWN;
            if (androidApplicationInfo2 == null) {
                ApkParser.$$$reportNull$$$0(8);
            }
            return androidApplicationInfo2;
        }
        try {
            AaptInvoker invoker = new AaptInvoker(AndroidSdks.getInstance().tryToChooseSdkHandler(), (ILogger)new LogWrapper(ApkParser.class));
            List xmlTree = invoker.getXmlTree(archive.getPath().toFile(), "AndroidManifest.xml");
            androidApplicationInfo = AndroidApplicationInfo.parse((List)xmlTree);
        }
        catch (ProcessException e) {
            Logger.getInstance(ApkViewPanel.class).warn("Unable to run aapt", (Throwable)e);
            AndroidApplicationInfo androidApplicationInfo3 = AndroidApplicationInfo.UNKNOWN;
            if (androidApplicationInfo3 == null) {
                ApkParser.$$$reportNull$$$0(10);
            }
            return androidApplicationInfo3;
        }
        if (androidApplicationInfo == null) {
            ApkParser.$$$reportNull$$$0(9);
        }
        return androidApplicationInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archive";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sizeCalculator";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/apk/viewer/ApkParser";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/apk/viewer/ApkParser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "constructTreeStructure";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUncompressedApkSize";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompressedFullApkSize";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createTreeNode";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateTreeWithDownloadSizes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

