/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.draw.test;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class CheckDisplayList
extends JPanel {
    DisplayList list;
    int count = 0;
    long time = System.nanoTime();
    public static final Color BLUEPRINT_BG_COLOR = new Color(1258866);
    String simpleList = "DrawNlComponentFrame,0,0,1000,1000,1,1000,1000\nClip,0,0,1000,1000\nDrawComponentBackground,50,375,100,20,1\nDrawTextRegion,50,375,100,20,0,false,false,5,5,28,1.0,\"\"\nDrawComponentFrame,50,375,100,20,1,40,40\nDrawConnection,2,50x375x100x20,0,0x0x1000x1000,0,1,false,0,0,false,0.5,0,1,352680822097845\nDrawConnection,2,50x375x100x20,1,0x0x1000x1000,1,1,false,0,0,false,0.5,0,1,352680822123643\nDrawComponentBackground,200,525,100,15,1\nDrawTextRegion,200,525,100,15,0,false,false,5,5,28,1.0,\"\"\nDrawComponentFrame,200,525,100,15,1,30,30\nDrawConnection,2,200x525x100x15,0,0x0x1000x1000,0,1,false,0,0,false,0.5,0,1,352680822223779\nDrawConnection,2,200x525x100x15,1,0x0x1000x1000,1,1,false,0,0,false,0.5,0,1,352680822243725\nDrawConnection,1,200x525x100x15,3,50x375x100x20,3,0,false,0,0,false,0.5,0,1,352680882075149\nDrawComponentBackground,325,575,100,25,1\nDrawTextRegion,325,575,100,25,0,false,false,5,5,28,1.0,\"\"\nDrawComponentFrame,325,575,100,25,1,50,50\nDrawConnection,2,325x575x100x25,0,0x0x1000x1000,0,1,false,0,0,false,0.5,0,1,352680822326282\nDrawConnection,2,325x575x100x25,1,0x0x1000x1000,1,1,false,0,0,false,0.5,0,1,352680822351127\nDrawConnection,1,325x575x100x25,3,200x525x100x15,3,0,true,0,0,false,0.5,0,1,352680882145055\nUNClip";

    public CheckDisplayList() {
        this.list = DisplayList.getDisplayList(this.simpleList);
        this.setBackground(Color.BLUE);
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(BLUEPRINT_BG_COLOR);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.list != null) {
            this.list.paint((Graphics2D)g, SceneContext.get());
        }
        ++this.count;
        if (System.nanoTime() - this.time > 1000000000L) {
            double total = (double)(System.nanoTime() - this.time) * 1.0E-9;
            System.out.println(" " + (float)((double)this.count / total) + " fps");
            this.count = 0;
            this.time = System.nanoTime();
        }
        this.repaint();
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("Spring");
        f.setBounds(new Rectangle(1100, 1100));
        f.setDefaultCloseOperation(3);
        CheckDisplayList p = new CheckDisplayList();
        f.setContentPane(p);
        f.validate();
        f.setVisible(true);
    }
}

