/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.hprof;

import com.android.SdkConstants;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.ddms.hprof.ConvertHprofDialog;
import com.android.tools.idea.editors.hprof.HprofCaptureType;
import com.android.tools.idea.profiling.capture.Capture;
import com.android.tools.idea.profiling.capture.CaptureTypeService;
import com.android.tools.idea.profiling.view.CapturesToolWindow;
import com.android.tools.idea.sdk.AndroidSdks;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunHprofConvAndSaveAsAction
extends DumbAwareAction {
    public RunHprofConvAndSaveAsAction() {
        this.getTemplatePresentation().setText(RunHprofConvAndSaveAsAction.getActionName());
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RunHprofConvAndSaveAsAction.$$$reportNull$$$0(0);
        }
        Presentation presentation = e.getPresentation();
        presentation.setText(RunHprofConvAndSaveAsAction.getActionName());
        presentation.setVisible(RunHprofConvAndSaveAsAction.isValidCaptureSelection((Capture[])CapturesToolWindow.CAPTURE_ARRAY.getData(e.getDataContext())));
    }

    @NotNull
    public static String getActionName() {
        String string = AndroidBundle.message("android.profiler.hprof.actions.conv.contextmenu", new Object[0]);
        if (string == null) {
            RunHprofConvAndSaveAsAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            RunHprofConvAndSaveAsAction.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (e == null) {
                RunHprofConvAndSaveAsAction.$$$reportNull$$$0(3);
            }
            if (e.getProject() == null) {
                return;
            }
            ConvertHprofDialog dialog = new ConvertHprofDialog(e.getProject());
            if (!dialog.showAndGet()) {
                return;
            }
            Capture[] captures = (Capture[])CapturesToolWindow.CAPTURE_ARRAY.getData(e.getDataContext());
            if (RunHprofConvAndSaveAsAction.isValidCaptureSelection(captures)) {
                UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.PROFILING).setKind(AndroidStudioEvent.EventKind.PROFILING_CONVERT_HPROF));
                new RunHprofConvAndSaveTask(e.getProject(), captures[0].getFile(), dialog.getHprofFile()).queue();
            }
        });
    }

    private static boolean isValidCaptureSelection(@Nullable Capture[] captures) {
        return captures != null && captures.length == 1 && captures[0].getType() == CaptureTypeService.getInstance().getType(HprofCaptureType.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/ddms/hprof/RunHprofConvAndSaveAsAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/ddms/hprof/RunHprofConvAndSaveAsAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "lambda$actionPerformed$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RunHprofConvAndSaveTask
    extends Task.Backgroundable {
        private final VirtualFile mySource;
        private final File myDestination;
        private Exception myException;

        public RunHprofConvAndSaveTask(@Nullable Project project, @NotNull VirtualFile source, @NotNull File destination) {
            if (source == null) {
                RunHprofConvAndSaveTask.$$$reportNull$$$0(0);
            }
            if (destination == null) {
                RunHprofConvAndSaveTask.$$$reportNull$$$0(1);
            }
            super(project, AndroidBundle.message("android.profiler.hprof.actions.conv", new Object[0]), false);
            this.mySource = source;
            this.myDestination = destination;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                RunHprofConvAndSaveTask.$$$reportNull$$$0(2);
            }
            try {
                this.convertAndSave();
            }
            catch (Exception e) {
                this.myException = e;
            }
        }

        private void convertAndSave() throws IOException, ExecutionException {
            AndroidSdkData sdkData = AndroidSdks.getInstance().tryToChooseAndroidSdk();
            if (sdkData == null) {
                throw new ExecutionException("Unable to find path to SDK.");
            }
            String hprofConvPath = new File(sdkData.getLocation(), AndroidCommonUtils.platformToolPath((String)SdkConstants.FN_HPROF_CONV)).getPath();
            List<String> commandLine = Arrays.asList(hprofConvPath, VfsUtilCore.virtualToIoFile((VirtualFile)this.mySource).getAbsolutePath(), this.myDestination.getAbsolutePath());
            ProcessBuilder pb = new ProcessBuilder(commandLine);
            BaseOSProcessHandler handler = new BaseOSProcessHandler(pb.start(), StringUtil.join(commandLine, (String)" "), null);
            final StringBuilder builder = new StringBuilder();
            handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    builder.append(event.getText());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "outputType";
                            break;
                        }
                    }
                    objectArray[1] = "com/android/tools/idea/ddms/hprof/RunHprofConvAndSaveAsAction$RunHprofConvAndSaveTask$1";
                    objectArray[2] = "onTextAvailable";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            handler.startNotify();
            handler.waitFor();
            int exitCode = handler.getProcess().exitValue();
            if (exitCode != 0) {
                throw new ExecutionException(builder.toString().trim());
            }
        }

        public void onSuccess() {
            if (this.myException != null) {
                Messages.showErrorDialog((String)("Unexpected error while converting heap dump: " + this.myException.getMessage()), (String)AndroidBundle.message("android.profiler.hprof.actions.conv", new Object[0]));
            } else {
                LocalFileSystem.getInstance().refreshAndFindFileByIoFile(this.myDestination);
                Notifications.Bus.notify((Notification)new Notification("Android", AndroidBundle.message("android.profiler.hprof.actions.conv", new Object[0]), AndroidBundle.message("android.profiler.hprof.actions.conv.saved", this.myDestination.getAbsolutePath()), NotificationType.INFORMATION));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "destination";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/ddms/hprof/RunHprofConvAndSaveAsAction$RunHprofConvAndSaveTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

