/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.tools.idea.editors.strings.SelectedEditorFeature;
import com.android.tools.idea.editors.strings.StringPreview;
import com.android.tools.idea.editors.strings.StringResourceViewPanel;
import com.android.tools.idea.editors.strings.StringsVirtualFile;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.content.ContentFactory;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringResourceEditor
extends UserDataHolderBase
implements FileEditor {
    public static final Icon ICON = AndroidIcons.Globe;
    public static final String NAME = "String Resource Editor";
    private static final String TOOL_WINDOW_ID = "StringPreview";
    private StringResourceViewPanel myPanel;
    private final PreviewFeature myPreviewFeature;

    StringResourceEditor(@NotNull StringsVirtualFile file) {
        if (file == null) {
            StringResourceEditor.$$$reportNull$$$0(0);
        }
        AndroidFacet facet = file.getFacet();
        UIUtil.invokeAndWaitIfNeeded(() -> {
            this.myPanel = new StringResourceViewPanel(facet, (Disposable)this);
            return this.myPanel;
        });
        this.myPreviewFeature = new PreviewFeature((FileEditor)this, facet.getModule());
        this.myPanel.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                Document document = event.getDocument();
                try {
                    StringResourceEditor.this.myPreviewFeature.setText(document.getText(0, document.getLength()));
                }
                catch (BadLocationException exception) {
                    StringResourceEditor.this.myPreviewFeature.setText("");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/editors/strings/StringResourceEditor$1", "textChanged"));
            }
        });
        this.myPanel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(@NotNull FocusEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                StringResourceEditor.this.myPreviewFeature.setText(((JTextComponent)event.getSource()).getText());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/editors/strings/StringResourceEditor$2", "focusGained"));
            }
        });
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel.getComponent();
        if (jPanel == null) {
            StringResourceEditor.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myPanel.getPreferredFocusedComponent();
    }

    @NotNull
    public String getName() {
        if (NAME == null) {
            StringResourceEditor.$$$reportNull$$$0(2);
        }
        return NAME;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            StringResourceEditor.$$$reportNull$$$0(3);
        }
        FileEditorState fileEditorState = FileEditorState.INSTANCE;
        if (fileEditorState == null) {
            StringResourceEditor.$$$reportNull$$$0(4);
        }
        return fileEditorState;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            StringResourceEditor.$$$reportNull$$$0(5);
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
        this.myPreviewFeature.selectNotify();
    }

    public void deselectNotify() {
        this.myPreviewFeature.deselectNotify();
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            StringResourceEditor.$$$reportNull$$$0(6);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            StringResourceEditor.$$$reportNull$$$0(7);
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
    }

    @NotNull
    public String toString() {
        String string = "StringResourceEditor " + (Object)((Object)this.myPanel.getFacet()) + " " + System.identityHashCode((Object)this);
        if (string == null) {
            StringResourceEditor.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/strings/StringResourceEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/strings/StringResourceEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class PreviewFeature
    extends SelectedEditorFeature {
        private final Module myModule;
        private StringPreview myPreview;
        private String myPreviewString;

        public PreviewFeature(@NotNull FileEditor editor, @NotNull Module module) {
            if (editor == null) {
                PreviewFeature.$$$reportNull$$$0(0);
            }
            if (module == null) {
                PreviewFeature.$$$reportNull$$$0(1);
            }
            super(editor, module.getProject());
            this.myModule = module;
        }

        @Override
        public boolean isReady() {
            return !DumbService.getInstance((Project)this.myModule.getProject()).isDumb() && !AndroidProjectInfo.getInstance(this.myModule.getProject()).requiredAndroidModelMissing() && ToolWindowManager.getInstance((Project)this.myModule.getProject()).getToolWindow(StringResourceEditor.TOOL_WINDOW_ID) == null;
        }

        @Override
        public void open() {
            this.myPreview = new StringPreview(this.myModule);
            if (this.myPreviewString != null) {
                this.myPreview.setText(this.myPreviewString);
            }
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myModule.getProject()).registerToolWindow(StringResourceEditor.TOOL_WINDOW_ID, false, ToolWindowAnchor.RIGHT, (Disposable)this.myModule.getProject(), true);
            toolWindow.setIcon(AndroidIcons.AndroidPreview);
            toolWindow.setStripeTitle("Preview");
            toolWindow.getContentManager().addContent(ContentFactory.SERVICE.getInstance().createContent(this.myPreview.getComponent(), "", false));
        }

        @Override
        public void close() {
            ToolWindowManager.getInstance((Project)this.myModule.getProject()).unregisterToolWindow(StringResourceEditor.TOOL_WINDOW_ID);
            this.myPreview = null;
        }

        public void setText(@NotNull String text) {
            if (text == null) {
                PreviewFeature.$$$reportNull$$$0(2);
            }
            this.myPreviewString = text;
            if (this.myPreview != null) {
                this.myPreview.setText(text);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/editors/strings/StringResourceEditor$PreviewFeature";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setText";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

