/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.ResourceValueMap;
import com.android.resources.ResourceType;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.attributes.editors.AttributeReferenceRendererEditor;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredThemeEditorStyle;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ResourcesCompletionProvider
implements AttributeReferenceRendererEditor.CompletionProvider,
ThemeEditorContext.ChangeListener {
    private final ArrayList<ResourceValue> myAllResources;

    ResourcesCompletionProvider(@NotNull ThemeEditorContext themeEditorContext) {
        if (themeEditorContext == null) {
            ResourcesCompletionProvider.$$$reportNull$$$0(0);
        }
        this.myAllResources = new ArrayList();
        this.fillResources(themeEditorContext.getResourceResolver());
    }

    @Override
    @NotNull
    public List<String> getCompletions(@NotNull EditedStyleItem value) {
        ConfiguredThemeEditorStyle selectedStyle;
        AttributeDefinition attrDefinition;
        if (value == null) {
            ResourcesCompletionProvider.$$$reportNull$$$0(1);
        }
        if ((attrDefinition = ResolutionUtils.getAttributeDefinition((selectedStyle = value.getSourceStyle()).getConfiguration(), value.getSelectedValue())) == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                ResourcesCompletionProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        EnumSet<ResourceType> acceptedTypes = EnumSet.noneOf(ResourceType.class);
        if (ThemeEditorUtils.acceptsFormat(attrDefinition, AttributeFormat.Color)) {
            acceptedTypes.add(ResourceType.COLOR);
        }
        if (ThemeEditorUtils.acceptsFormat(attrDefinition, AttributeFormat.Dimension)) {
            acceptedTypes.add(ResourceType.DIMEN);
        }
        if (ThemeEditorUtils.acceptsFormat(attrDefinition, AttributeFormat.String)) {
            acceptedTypes.add(ResourceType.STRING);
        }
        if (ThemeEditorUtils.acceptsFormat(attrDefinition, AttributeFormat.Reference)) {
            acceptedTypes.addAll((Collection<ResourceType>)ImmutableList.of((Object)ResourceType.LAYOUT, (Object)ResourceType.COLOR, (Object)ResourceType.DRAWABLE, (Object)ResourceType.MIPMAP, (Object)ResourceType.STYLE, (Object)ResourceType.ATTR, (Object)ResourceType.STRING, (Object)ResourceType.DIMEN, (Object)ResourceType.TRANSITION));
        }
        ArrayList<String> resourceNamesList = new ArrayList<String>(this.myAllResources.size());
        for (ResourceValue resource : this.myAllResources) {
            if (!acceptedTypes.contains(resource.getResourceType())) continue;
            String name = String.format("%1$s%2$s%3$s/%4$s", ResourceType.ATTR == resource.getResourceType() ? "?" : "@", resource.isFramework() ? "android:" : "", resource.getResourceType().getName(), resource.getName());
            resourceNamesList.add(name);
        }
        ArrayList<String> arrayList = resourceNamesList;
        if (arrayList == null) {
            ResourcesCompletionProvider.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private void fillResources(@Nullable ResourceResolver resourceResolver) {
        this.myAllResources.clear();
        if (resourceResolver == null) {
            return;
        }
        for (ResourceValueMap resourceTypeResource : resourceResolver.getFrameworkResources().values()) {
            this.myAllResources.addAll(resourceTypeResource.values());
        }
        for (ResourceValueMap resourceTypeResource : resourceResolver.getProjectResources().values()) {
            this.myAllResources.addAll(resourceTypeResource.values());
        }
    }

    @Override
    public void onNewConfiguration(ThemeEditorContext context) {
        this.fillResources(context.getResourceResolver());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "themeEditorContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/theme/ResourcesCompletionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/theme/ResourcesCompletionProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCompletions";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

