/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd;

import com.android.tools.idea.diagnostics.crash.CrashReporter;
import com.android.tools.idea.fd.BuildMode;
import com.android.tools.idea.fd.BuildSelection;
import com.android.tools.idea.fd.DeployType;
import com.android.tools.idea.fd.InstantRunContext;
import com.android.tools.idea.fd.InstantRunNotificationProvider;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.LaunchOptions;
import com.android.tools.idea.run.tasks.DeployApkTask;
import com.android.tools.idea.run.tasks.HotSwapTask;
import com.android.tools.idea.run.tasks.InstantRunNotificationTask;
import com.android.tools.idea.run.tasks.KillTask;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.tasks.NoChangesTask;
import com.android.tools.idea.run.tasks.SplitApkDeployTask;
import com.android.tools.idea.run.tasks.UpdateAppInfoTask;
import com.android.tools.idea.run.tasks.UpdateInstantRunStateTask;
import com.android.tools.ir.client.InstantRunArtifact;
import com.android.tools.ir.client.InstantRunArtifactType;
import com.android.tools.ir.client.InstantRunBuildInfo;
import com.google.common.collect.ImmutableList;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstantRunBuildAnalyzer {
    private final Project myProject;
    private final InstantRunContext myContext;
    private final ProcessHandler myCurrentSession;
    private final InstantRunBuildInfo myBuildInfo;
    private final boolean myIsRestartActivity;
    private final Collection<ApkInfo> myApks;

    public InstantRunBuildAnalyzer(@NotNull Project project, @NotNull InstantRunContext context, @Nullable ProcessHandler currentSession, boolean isRestartActivity) {
        if (project == null) {
            InstantRunBuildAnalyzer.$$$reportNull$$$0(0);
        }
        if (context == null) {
            InstantRunBuildAnalyzer.$$$reportNull$$$0(1);
        }
        this(project, context, currentSession, Collections.EMPTY_LIST, isRestartActivity);
    }

    public InstantRunBuildAnalyzer(@NotNull Project project, @NotNull InstantRunContext context, @Nullable ProcessHandler currentSession, @NotNull Collection<ApkInfo> apks, boolean isRestartActivity) {
        if (project == null) {
            InstantRunBuildAnalyzer.$$$reportNull$$$0(2);
        }
        if (context == null) {
            InstantRunBuildAnalyzer.$$$reportNull$$$0(3);
        }
        if (apks == null) {
            InstantRunBuildAnalyzer.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.myContext = context;
        this.myCurrentSession = currentSession;
        this.myApks = apks;
        this.myIsRestartActivity = isRestartActivity;
        this.myBuildInfo = this.myContext.getInstantRunBuildInfo();
        if (this.myBuildInfo == null) {
            throw new IllegalArgumentException("Instant Run Build Information must be available post build");
        }
        if (!this.myBuildInfo.isCompatibleFormat()) {
            throw new IllegalStateException("This version of Android Studio is incompatible with the Gradle Plugin used. Try disabling Instant Run (or updating either the IDE or the Gradle plugin to the latest version)");
        }
    }

    public boolean canReuseProcessHandler() {
        if (this.myCurrentSession == null || this.myCurrentSession.isProcessTerminated()) {
            return false;
        }
        BuildSelection buildSelection = this.myContext.getBuildSelection();
        assert (buildSelection != null) : "Build must have completed before results are analyzed";
        return buildSelection.getBuildMode() == BuildMode.HOT && this.myBuildInfo.getBuildMode().equals("HOT_WARM");
    }

    @NotNull
    public List<LaunchTask> getDeployTasks(@NotNull LaunchOptions launchOptions) {
        if (launchOptions == null) {
            InstantRunBuildAnalyzer.$$$reportNull$$$0(5);
        }
        UpdateInstantRunStateTask updateStateTask = new UpdateInstantRunStateTask(this.myContext);
        DeployType deployType = this.getDeployType();
        switch (deployType) {
            case NO_CHANGES: {
                ImmutableList immutableList = ImmutableList.of((Object)new NoChangesTask(this.myProject, this.myContext), (Object)updateStateTask);
                if (immutableList == null) {
                    InstantRunBuildAnalyzer.$$$reportNull$$$0(6);
                }
                return immutableList;
            }
            case RESTART: {
                ImmutableList immutableList = ImmutableList.of((Object)new KillTask(this.myProject, this.myContext), (Object)updateStateTask);
                if (immutableList == null) {
                    InstantRunBuildAnalyzer.$$$reportNull$$$0(7);
                }
                return immutableList;
            }
            case HOTSWAP: 
            case WARMSWAP: {
                ImmutableList.Builder taskBuilder = new ImmutableList.Builder();
                if (this.myBuildInfo.hasOneOf(new InstantRunArtifactType[]{InstantRunArtifactType.SPLIT})) {
                    taskBuilder.add((Object)new SplitApkDeployTask(this.myProject, this.myContext, true));
                    taskBuilder.add((Object)new UpdateAppInfoTask(this.myProject, this.myContext));
                }
                if (this.myBuildInfo.hasOneOf(new InstantRunArtifactType[]{InstantRunArtifactType.RELOAD_DEX}) || this.myBuildInfo.hasHotSwapResources()) {
                    taskBuilder.add((Object)new HotSwapTask(this.myProject, this.myContext, deployType == DeployType.WARMSWAP));
                }
                ImmutableList immutableList = taskBuilder.add((Object)updateStateTask).build();
                if (immutableList == null) {
                    InstantRunBuildAnalyzer.$$$reportNull$$$0(8);
                }
                return immutableList;
            }
            case SPLITAPK: {
                ImmutableList immutableList = ImmutableList.of((Object)new SplitApkDeployTask(this.myProject, this.myContext), (Object)updateStateTask);
                if (immutableList == null) {
                    InstantRunBuildAnalyzer.$$$reportNull$$$0(9);
                }
                return immutableList;
            }
            case FULLAPK: 
            case LEGACY: {
                ImmutableList immutableList = ImmutableList.of((Object)new DeployApkTask(this.myProject, launchOptions, this.myApks, this.myContext));
                if (immutableList == null) {
                    InstantRunBuildAnalyzer.$$$reportNull$$$0(10);
                }
                return immutableList;
            }
        }
        if (StatisticsUploadAssistant.isSendAllowed()) {
            CrashReporter.getInstance().submit(this.getIrDebugSignals(deployType));
        }
        throw new IllegalStateException(AndroidBundle.message("instant.run.build.error", new Object[0]));
    }

    @NotNull
    private Map<String, String> getIrDebugSignals(@NotNull DeployType deployType) {
        InstantRunBuildInfo buildInfo;
        if (deployType == null) {
            InstantRunBuildAnalyzer.$$$reportNull$$$0(11);
        }
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("deployType", deployType.toString());
        m.put("canReuseProcessHandler", Boolean.toString(this.canReuseProcessHandler()));
        m.put("androidGradlePluginVersion", this.myContext.getGradlePluginVersion().toString());
        BuildSelection selection = this.myContext.getBuildSelection();
        if (selection != null) {
            m.put("buildSelection.mode", selection.getBuildMode().toString());
            m.put("buildSelection.why", selection.why.toString());
        }
        if ((buildInfo = this.myContext.getInstantRunBuildInfo()) != null) {
            m.put("buildinfo.buildMode", buildInfo.getBuildMode());
            m.put("buildinfo.verifierStatus", buildInfo.getVerifierStatus());
            m.put("buildinfo.format", Integer.toString(buildInfo.getFormat()));
            List artifacts = buildInfo.getArtifacts();
            m.put("buildinfo.nArtifacts", Integer.toString(artifacts.size()));
            for (int i = 0; i < artifacts.size(); ++i) {
                InstantRunArtifact artifact = (InstantRunArtifact)artifacts.get(i);
                String prefix = "buildInfo.artifact[" + i + "]";
                m.put(prefix + ".type", artifact.type.toString());
                m.put(prefix + ".file", artifact.file.getName());
            }
        }
        HashMap<String, String> hashMap = m;
        if (hashMap == null) {
            InstantRunBuildAnalyzer.$$$reportNull$$$0(12);
        }
        return hashMap;
    }

    @NotNull
    public LaunchTask getNotificationTask() {
        DeployType deployType = this.getDeployType();
        BuildSelection buildSelection = this.myContext.getBuildSelection();
        InstantRunNotificationProvider notificationProvider = new InstantRunNotificationProvider(buildSelection, deployType, this.myBuildInfo.getVerifierStatus());
        InstantRunNotificationTask instantRunNotificationTask = new InstantRunNotificationTask(this.myProject, this.myContext, notificationProvider, buildSelection);
        if (instantRunNotificationTask == null) {
            InstantRunBuildAnalyzer.$$$reportNull$$$0(13);
        }
        return instantRunNotificationTask;
    }

    @NotNull
    DeployType getDeployType() {
        List artifacts;
        if (this.canReuseProcessHandler()) {
            if (this.myBuildInfo.hasNoChanges()) {
                DeployType deployType = DeployType.NO_CHANGES;
                if (deployType == null) {
                    InstantRunBuildAnalyzer.$$$reportNull$$$0(14);
                }
                return deployType;
            }
            if (this.myBuildInfo.canHotswap()) {
                DeployType deployType = this.myIsRestartActivity ? DeployType.WARMSWAP : DeployType.HOTSWAP;
                if (deployType == null) {
                    InstantRunBuildAnalyzer.$$$reportNull$$$0(15);
                }
                return deployType;
            }
        }
        if ((artifacts = this.myBuildInfo.getArtifacts()).isEmpty()) {
            if (this.myBuildInfo.getVerifierStatus().equals(DeployType.NO_CHANGES.toString())) {
                DeployType deployType = DeployType.NO_CHANGES;
                if (deployType == null) {
                    InstantRunBuildAnalyzer.$$$reportNull$$$0(16);
                }
                return deployType;
            }
            DeployType deployType = DeployType.RESTART;
            if (deployType == null) {
                InstantRunBuildAnalyzer.$$$reportNull$$$0(17);
            }
            return deployType;
        }
        if (this.myBuildInfo.hasOneOf(new InstantRunArtifactType[]{InstantRunArtifactType.SPLIT}) || this.myBuildInfo.hasOneOf(new InstantRunArtifactType[]{InstantRunArtifactType.SPLIT_MAIN})) {
            DeployType deployType = DeployType.SPLITAPK;
            if (deployType == null) {
                InstantRunBuildAnalyzer.$$$reportNull$$$0(18);
            }
            return deployType;
        }
        DeployType deployType = DeployType.FULLAPK;
        if (deployType == null) {
            InstantRunBuildAnalyzer.$$$reportNull$$$0(19);
        }
        return deployType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apks";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchOptions";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/fd/InstantRunBuildAnalyzer";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deployType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/fd/InstantRunBuildAnalyzer";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeployTasks";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getIrDebugSignals";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotificationTask";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeployType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDeployTasks";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getIrDebugSignals";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

