/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.tools.idea.gradle.actions.GoToApkLocationTask;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.build.invoker.TestCompileType;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.run.OutputBuildAction;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class BuildApkAction
extends DumbAwareAction {
    private static final String ACTION_TEXT = "Build APK(s)";

    public BuildApkAction() {
        super(ACTION_TEXT);
    }

    public void update(AnActionEvent e) {
        Project project = e.getProject();
        e.getPresentation().setEnabledAndVisible(project != null && GradleProjectInfo.getInstance(project).isBuildWithGradle());
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        if (project != null && GradleProjectInfo.getInstance(project).isBuildWithGradle()) {
            ArrayList<Module> appModules = new ArrayList<Module>();
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                String assembleTaskName;
                AndroidModuleModel androidModel;
                AndroidFacet facet = AndroidFacet.getInstance(module);
                if (facet == null || (androidModel = AndroidModuleModel.get(facet)) == null || androidModel.getAndroidProject().getProjectType() != 0 && androidModel.getAndroidProject().getProjectType() != 4 || !StringUtil.isNotEmpty((String)(assembleTaskName = facet.getProperties().ASSEMBLE_TASK_NAME))) continue;
                appModules.add(module);
            }
            if (!appModules.isEmpty()) {
                GradleBuildInvoker gradleBuildInvoker = GradleBuildInvoker.getInstance(project);
                gradleBuildInvoker.add(new GoToApkLocationTask(appModules, ACTION_TEXT));
                gradleBuildInvoker.assemble(appModules.toArray(new Module[appModules.size()]), TestCompileType.ALL, new OutputBuildAction(BuildApkAction.getModuleGradlePaths(appModules)));
            }
        }
    }

    @NotNull
    private static List<String> getModuleGradlePaths(@NotNull List<Module> modules) {
        if (modules == null) {
            BuildApkAction.$$$reportNull$$$0(0);
        }
        ArrayList<String> gradlePaths = new ArrayList<String>();
        for (Module module : modules) {
            String gradlePath = GradleUtil.getGradlePath(module);
            if (gradlePath == null) continue;
            gradlePaths.add(gradlePath);
        }
        ArrayList<String> arrayList = gradlePaths;
        if (arrayList == null) {
            BuildApkAction.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/actions/BuildApkAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/actions/BuildApkAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleGradlePaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getModuleGradlePaths";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

