/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.model.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.parser.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.GradleResolvedVariable;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.ext.ExtDslElement;
import com.android.tools.idea.gradle.dsl.parser.settings.ProjectPropertiesDslElement;
import com.android.tools.idea.gradle.util.Projects;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public abstract class GradleDslExpression
extends GradleDslElement {
    @NotNull
    private List<GradleResolvedVariable> myResolvedVariables;
    @Nullable
    protected GrExpression myExpression;

    protected GradleDslExpression(@Nullable GradleDslElement parent, @Nullable GroovyPsiElement psiElement, @NotNull String name, @Nullable GrExpression expression) {
        if (name == null) {
            GradleDslExpression.$$$reportNull$$$0(0);
        }
        super(parent, psiElement, name);
        this.myResolvedVariables = ImmutableList.of();
        this.myExpression = expression;
    }

    @Nullable
    public GrExpression getExpression() {
        return this.myExpression;
    }

    @Nullable
    public abstract Object getValue();

    @Nullable
    public abstract <T> T getValue(@NotNull Class<T> var1);

    public abstract void setValue(@NotNull Object var1);

    @Override
    @NotNull
    public List<GradleResolvedVariable> getResolvedVariables() {
        List<GradleResolvedVariable> list = this.myResolvedVariables;
        if (list == null) {
            GradleDslExpression.$$$reportNull$$$0(1);
        }
        return list;
    }

    public void setResolvedVariables(@NotNull List<GradleResolvedVariable> resolvedVariables) {
        if (resolvedVariables == null) {
            GradleDslExpression.$$$reportNull$$$0(2);
        }
        this.myResolvedVariables = ImmutableList.copyOf(resolvedVariables);
    }

    @Nullable
    protected <T> T resolveReference(@NotNull String referenceText, @NotNull Class<T> clazz) {
        GradleDslElement resolvedElement;
        GradleDslFile dslFile;
        int index;
        if (referenceText == null) {
            GradleDslExpression.$$$reportNull$$$0(3);
        }
        if (clazz == null) {
            GradleDslExpression.$$$reportNull$$$0(4);
        }
        GradleDslElement searchStartElement = this;
        String searchReferenceText = referenceText;
        List referenceTextSegments = Splitter.on((char)'.').trimResults().omitEmptyStrings().splitToList((CharSequence)referenceText);
        int segmentCount = referenceTextSegments.size();
        for (index = 0; index < segmentCount && (dslFile = GradleDslExpression.resolveProjectReference(searchStartElement, (String)referenceTextSegments.get(index))) != null; ++index) {
            searchStartElement = dslFile;
        }
        if (index >= segmentCount) {
            resolvedElement = searchStartElement;
        } else {
            searchReferenceText = Joiner.on((char)'.').join(referenceTextSegments.subList(index, segmentCount));
            resolvedElement = GradleDslExpression.resolveReferenceInSameModule(searchStartElement, searchReferenceText);
        }
        GradleDslFile dslFile2 = searchStartElement.getDslFile();
        if (resolvedElement == null) {
            resolvedElement = GradleDslExpression.resolveReferenceInParentModules(dslFile2, searchReferenceText);
        }
        if (resolvedElement != null) {
            T result = null;
            if (clazz.isInstance(resolvedElement)) {
                result = clazz.cast(resolvedElement);
            } else if (resolvedElement instanceof GradleDslExpression) {
                result = ((GradleDslExpression)resolvedElement).getValue(clazz);
            }
            if (result != null) {
                this.setResolvedVariables((List<GradleResolvedVariable>)ImmutableList.of((Object)new GradleResolvedVariable(referenceText, result, resolvedElement)));
                return result;
            }
        }
        if (clazz.isAssignableFrom(String.class)) {
            if ("rootDir".equals(searchReferenceText)) {
                return clazz.cast(Projects.getBaseDirPath(dslFile2.getProject()).getPath());
            }
            if ("projectDir".equals(searchReferenceText)) {
                return clazz.cast(dslFile2.getDirectoryPath().getPath());
            }
            return clazz.cast(referenceText);
        }
        return null;
    }

    @Nullable
    private static GradleDslFile resolveProjectReference(GradleDslElement startElement, @NotNull String projectReference) {
        GradleDslFile dslFile;
        if (projectReference == null) {
            GradleDslExpression.$$$reportNull$$$0(5);
        }
        if ("project".equals(projectReference)) {
            return dslFile;
        }
        if ("parent".equals(projectReference)) {
            return dslFile.getParentModuleDslFile();
        }
        if ("rootProject".equals(projectReference)) {
            for (dslFile = startElement.getDslFile(); dslFile != null && !FileUtil.filesEqual((File)dslFile.getDirectoryPath(), (File)VfsUtilCore.virtualToIoFile((VirtualFile)dslFile.getProject().getBaseDir())); dslFile = dslFile.getParentModuleDslFile()) {
            }
            return dslFile;
        }
        String standardProjectKey = ProjectPropertiesDslElement.getStandardProjectKey(projectReference);
        if (standardProjectKey != null) {
            String modulePath = standardProjectKey.substring(standardProjectKey.indexOf(39) + 1, standardProjectKey.lastIndexOf(39));
            GradleSettingsModel model = GradleSettingsModel.get(dslFile.getProject());
            if (model == null) {
                return null;
            }
            File moduleDirectory = model.moduleDirectory(modulePath);
            if (moduleDirectory == null) {
                return null;
            }
            while (dslFile != null && !FileUtil.filesEqual((File)dslFile.getDirectoryPath(), (File)VfsUtilCore.virtualToIoFile((VirtualFile)dslFile.getProject().getBaseDir()))) {
                dslFile = dslFile.getParentModuleDslFile();
            }
            if (dslFile == null) {
                return null;
            }
            return GradleDslExpression.findDslFile(dslFile, moduleDirectory);
        }
        return null;
    }

    @Nullable
    private static GradleDslElement resolveReferenceInSameModule(GradleDslElement startElement, @NotNull String referenceText) {
        GradleDslFile parentModuleDslFile;
        GradleDslFile dslFile;
        GradleDslElement propertyElement;
        if (referenceText == null) {
            GradleDslExpression.$$$reportNull$$$0(6);
        }
        for (GradleDslElement element = startElement; element != null; element = element.getParent()) {
            GradleDslElement extPropertyElement;
            if (!(element instanceof GradlePropertiesDslElement)) continue;
            GradleDslElement propertyElement2 = ((GradlePropertiesDslElement)element).getPropertyElement(referenceText);
            if (propertyElement2 != null) {
                return propertyElement2;
            }
            if (!(element instanceof GradleDslFile)) continue;
            ExtDslElement extDslElement = ((GradleDslFile)element).getPropertyElement("ext", ExtDslElement.class);
            if (extDslElement == null || (extPropertyElement = extDslElement.getPropertyElement(referenceText)) == null) break;
            return extPropertyElement;
        }
        if ((propertyElement = GradleDslExpression.resolveReferenceInPropertiesFile(dslFile = startElement.getDslFile(), referenceText)) != null) {
            return propertyElement;
        }
        if (dslFile.getParentModuleDslFile() == null) {
            return null;
        }
        GradleDslFile rootProjectDslFile = dslFile;
        while ((parentModuleDslFile = rootProjectDslFile.getParentModuleDslFile()) != null) {
            rootProjectDslFile = parentModuleDslFile;
        }
        return GradleDslExpression.resolveReferenceInPropertiesFile(rootProjectDslFile, referenceText);
    }

    @Nullable
    private static GradleDslElement resolveReferenceInParentModules(@NotNull GradleDslFile dslFile, @NotNull String referenceText) {
        if (dslFile == null) {
            GradleDslExpression.$$$reportNull$$$0(7);
        }
        if (referenceText == null) {
            GradleDslExpression.$$$reportNull$$$0(8);
        }
        for (GradleDslFile parentDslFile = dslFile.getParentModuleDslFile(); parentDslFile != null; parentDslFile = parentDslFile.getParentModuleDslFile()) {
            GradleDslElement extPropertyElement;
            ExtDslElement extDslElement = parentDslFile.getPropertyElement("ext", ExtDslElement.class);
            if (extDslElement != null && (extPropertyElement = extDslElement.getPropertyElement(referenceText)) != null) {
                return extPropertyElement;
            }
            if (parentDslFile.getParentModuleDslFile() == null) {
                return null;
            }
            GradleDslElement propertyElement = GradleDslExpression.resolveReferenceInPropertiesFile(parentDslFile, referenceText);
            if (propertyElement == null) continue;
            return propertyElement;
        }
        return null;
    }

    @Nullable
    private static GradleDslElement resolveReferenceInPropertiesFile(@NotNull GradleDslFile buildDslFile, @NotNull String referenceText) {
        GradleDslFile propertiesDslFile;
        if (buildDslFile == null) {
            GradleDslExpression.$$$reportNull$$$0(9);
        }
        if (referenceText == null) {
            GradleDslExpression.$$$reportNull$$$0(10);
        }
        return (propertiesDslFile = buildDslFile.getSiblingDslFile()) != null ? propertiesDslFile.getPropertyElement(referenceText) : null;
    }

    @Nullable
    private static GradleDslFile findDslFile(GradleDslFile rootModuleDslFile, File moduleDirectory) {
        if (FileUtil.filesEqual((File)rootModuleDslFile.getDirectoryPath(), (File)moduleDirectory)) {
            return rootModuleDslFile;
        }
        for (GradleDslFile dslFile : rootModuleDslFile.getChildModuleDslFiles()) {
            if (FileUtil.filesEqual((File)dslFile.getDirectoryPath(), (File)moduleDirectory)) {
                return dslFile;
            }
            GradleDslFile childDslFile = GradleDslExpression.findDslFile(dslFile, moduleDirectory);
            if (childDslFile == null) continue;
            return dslFile;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslExpression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedVariables";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectReference";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dslFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildDslFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslExpression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedVariables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setResolvedVariables";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveReference";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveProjectReference";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferenceInSameModule";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferenceInParentModules";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferenceInPropertiesFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

