/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.LegacyAndroidProjects;
import com.android.tools.idea.gradle.project.build.GradleBuildContext;
import com.android.tools.idea.gradle.project.build.JpsBuildContext;
import com.android.tools.idea.gradle.project.build.PostProjectBuildTasksExecutor;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.project.AndroidProjectBuildNotifications;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.startup.DelayedInitialization;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.execution.RunConfigurationProducerService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.test.runner.AllInPackageGradleConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.test.runner.TestClassGradleConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.test.runner.TestMethodGradleConfigurationProducer;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class AndroidGradleProjectComponent
extends AbstractProjectComponent {
    @NotNull
    private final LegacyAndroidProjects myLegacyAndroidProjects;
    @Nullable
    private Disposable myDisposable;

    @NotNull
    public static AndroidGradleProjectComponent getInstance(@NotNull Project project) {
        if (project == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(0);
        }
        AndroidGradleProjectComponent component2 = (AndroidGradleProjectComponent)((Object)project.getComponent(AndroidGradleProjectComponent.class));
        assert (component2 != null);
        AndroidGradleProjectComponent androidGradleProjectComponent = component2;
        if (androidGradleProjectComponent == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(1);
        }
        return androidGradleProjectComponent;
    }

    public AndroidGradleProjectComponent(@NotNull Project project) {
        if (project == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(2);
        }
        this(project, new LegacyAndroidProjects(project));
    }

    public AndroidGradleProjectComponent(@NotNull Project project, @NotNull LegacyAndroidProjects legacyAndroidProjects) {
        if (project == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(3);
        }
        if (legacyAndroidProjects == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(4);
        }
        super(project);
        this.myLegacyAndroidProjects = legacyAndroidProjects;
        CompilerManager.getInstance((Project)this.myProject).addAfterTask(context -> {
            if (project == null) {
                AndroidGradleProjectComponent.$$$reportNull$$$0(6);
            }
            if (GradleProjectInfo.getInstance(this.myProject).isBuildWithGradle()) {
                PostProjectBuildTasksExecutor.getInstance(project).onBuildCompletion(context);
                JpsBuildContext newContext = new JpsBuildContext(context);
                AndroidProjectBuildNotifications.getInstance(this.myProject).notifyBuildComplete(newContext);
            }
            return true;
        });
        GradleBuildInvoker.getInstance(this.myProject).add(result -> {
            if (project == null) {
                AndroidGradleProjectComponent.$$$reportNull$$$0(5);
            }
            PostProjectBuildTasksExecutor.getInstance(project).onBuildCompletion(result);
            GradleBuildContext newContext = new GradleBuildContext(result);
            AndroidProjectBuildNotifications.getInstance(this.myProject).notifyBuildComplete(newContext);
        });
        DelayedInitialization.getInstance(this.myProject);
    }

    public void projectOpened() {
        GradleSyncState syncState;
        String error;
        GradleProjectInfo gradleProjectInfo = GradleProjectInfo.getInstance(this.myProject);
        if (this.myProject.isOpen() && StringUtil.isNotEmpty((String)(error = gradleProjectInfo.getProjectCreationError()))) {
            ExternalSystemNotificationManager notificationManager = ExternalSystemNotificationManager.getInstance((Project)this.myProject);
            notificationManager.processExternalProjectRefreshError((Throwable)new ExternalSystemException(error), this.myProject.getName(), GradleConstants.SYSTEM_ID);
            gradleProjectInfo.setProjectCreationError(null);
        }
        if ((syncState = GradleSyncState.getInstance(this.myProject)).isSyncInProgress()) {
            syncState.notifyStateChanged();
        }
        IdeInfo ideInfo = IdeInfo.getInstance();
        AndroidProjectInfo androidProjectInfo = AndroidProjectInfo.getInstance(this.myProject);
        if (ideInfo.isAndroidStudio() && androidProjectInfo.isLegacyIdeaAndroidProject() && !androidProjectInfo.isApkProject()) {
            this.myLegacyAndroidProjects.trackProject();
            this.myLegacyAndroidProjects.showMigrateToGradleWarning();
            return;
        }
        if (gradleProjectInfo.isBuildWithGradle()) {
            this.configureGradleProject();
        } else if (ideInfo.isAndroidStudio() && this.myProject.getBaseDir() != null && Projects.canImportAsGradleProject(this.myProject.getBaseDir())) {
            GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(this.myProject, GradleSyncStats.Trigger.TRIGGER_PROJECT_LOADED, null);
        }
    }

    public void configureGradleProject() {
        if (this.myDisposable != null) {
            return;
        }
        this.myDisposable = Disposer.newDisposable();
        this.myProject.putUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT, (Object)Boolean.TRUE);
        ArrayList<Class<TestMethodGradleConfigurationProducer>> runConfigurationProducerTypes = new ArrayList<Class<TestMethodGradleConfigurationProducer>>();
        runConfigurationProducerTypes.add(AllInPackageGradleConfigurationProducer.class);
        runConfigurationProducerTypes.add(TestClassGradleConfigurationProducer.class);
        runConfigurationProducerTypes.add(TestMethodGradleConfigurationProducer.class);
        RunConfigurationProducerService runConfigurationProducerManager = RunConfigurationProducerService.getInstance((Project)this.myProject);
        if (IdeInfo.getInstance().isAndroidStudio()) {
            for (Class clazz : runConfigurationProducerTypes) {
                runConfigurationProducerManager.getState().ignoredProducers.add(clazz.getName());
            }
        } else {
            for (Class clazz : runConfigurationProducerTypes) {
                runConfigurationProducerManager.getState().ignoredProducers.remove(clazz.getName());
            }
        }
    }

    public void projectClosed() {
        if (this.myDisposable != null) {
            Disposer.dispose((Disposable)this.myDisposable);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/AndroidGradleProjectComponent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "legacyAndroidProjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/AndroidGradleProjectComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$1";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

