/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.importing;

import com.android.tools.idea.gradle.util.FilePaths;
import com.android.tools.idea.gradle.util.Projects;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectType;
import com.intellij.openapi.project.ProjectTypeService;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.pom.java.LanguageLevel;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewProjectSetup {
    public static final ProjectType ANDROID_PROJECT_TYPE = new ProjectType("Android");

    @NotNull
    public Project createProject(@NotNull String projectName, @NotNull String projectPath) throws ConfigurationException {
        ProjectManager projectManager;
        Project newProject;
        if (projectName == null) {
            NewProjectSetup.$$$reportNull$$$0(0);
        }
        if (projectPath == null) {
            NewProjectSetup.$$$reportNull$$$0(1);
        }
        if ((newProject = (projectManager = ProjectManager.getInstance()).createProject(projectName, projectPath)) == null) {
            throw new NullPointerException("Failed to create a new project");
        }
        Project project = newProject;
        if (project == null) {
            NewProjectSetup.$$$reportNull$$$0(2);
        }
        return project;
    }

    @NotNull
    Project openProject(@NotNull String projectPath) throws IOException {
        ProjectManagerEx projectManager;
        Project newProject;
        if (projectPath == null) {
            NewProjectSetup.$$$reportNull$$$0(3);
        }
        if ((newProject = (projectManager = ProjectManagerEx.getInstanceEx()).loadProject(projectPath)) == null) {
            throw new NullPointerException("Failed to open project at '" + projectPath + "'");
        }
        Project project = newProject;
        if (project == null) {
            NewProjectSetup.$$$reportNull$$$0(4);
        }
        return project;
    }

    void prepareProjectForImport(@NotNull Project project, @Nullable LanguageLevel languageLevel) {
        if (project == null) {
            NewProjectSetup.$$$reportNull$$$0(5);
        }
        CommandProcessor.getInstance().executeCommand(project, () -> {
            if (project == null) {
                NewProjectSetup.$$$reportNull$$$0(6);
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                LanguageLevelProjectExtension extension;
                if (project == null) {
                    NewProjectSetup.$$$reportNull$$$0(7);
                }
                if (languageLevel != null && (extension = LanguageLevelProjectExtension.getInstance((Project)project)) != null) {
                    extension.setLanguageLevel(languageLevel);
                }
                File compilerOutputDirPath = new File(Projects.getBaseDirPath(project), FileUtil.join((String[])new String[]{"build", "classes"}));
                String compilerOutputDirUrl = FilePaths.pathToIdeaUrl(compilerOutputDirPath);
                CompilerProjectExtension compilerProjectExt = CompilerProjectExtension.getInstance((Project)project);
                assert (compilerProjectExt != null);
                compilerProjectExt.setCompilerOutputUrl(compilerOutputDirUrl);
                ProjectTypeService.setProjectType((Project)project, (ProjectType)ANDROID_PROJECT_TYPE);
            });
        }, null, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectName";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/importing/NewProjectSetup";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/importing/NewProjectSetup";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createProject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "openProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createProject";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "openProject";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "prepareProjectForImport";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$prepareProjectForImport$1";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

