/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.util.GoogleMavenRepository;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class AddGoogleMavenRepositoryHyperlink
extends NotificationHyperlink {
    @NotNull
    private final VirtualFile myBuildFile;
    private final boolean mySyncAfterFix;

    public AddGoogleMavenRepositoryHyperlink(@NotNull VirtualFile buildFile) {
        if (buildFile == null) {
            AddGoogleMavenRepositoryHyperlink.$$$reportNull$$$0(0);
        }
        this(buildFile, true);
    }

    public AddGoogleMavenRepositoryHyperlink(@NotNull VirtualFile buildFile, boolean syncAfterFix) {
        if (buildFile == null) {
            AddGoogleMavenRepositoryHyperlink.$$$reportNull$$$0(1);
        }
        super("add.google.maven.repository", AddGoogleMavenRepositoryHyperlink.getText(syncAfterFix));
        this.myBuildFile = buildFile;
        this.mySyncAfterFix = syncAfterFix;
    }

    @Override
    protected void execute(@NotNull Project project) {
        if (project == null) {
            AddGoogleMavenRepositoryHyperlink.$$$reportNull$$$0(2);
        }
        GradleBuildModel buildModel = GradleBuildModel.parseBuildFile(this.myBuildFile, project);
        GoogleMavenRepository.addGoogleRepository(buildModel.repositories(), project);
        WriteCommandAction.runWriteCommandAction((Project)project, buildModel::applyChanges);
        GradleBuildModel buildModelProject = GradleBuildModel.get(project);
        if (buildModelProject != null) {
            GoogleMavenRepository.addGoogleRepository(buildModelProject.buildscript().repositories(), project);
            WriteCommandAction.runWriteCommandAction((Project)project, buildModelProject::applyChanges);
        }
        if (this.mySyncAfterFix) {
            GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, GradleSyncStats.Trigger.TRIGGER_PROJECT_MODIFIED, null);
        }
    }

    @NotNull
    private static String getText(boolean syncAfterFix) {
        String text = "Add Google Maven repository";
        if (syncAfterFix) {
            text = text + " and sync project";
        }
        String string = text;
        if (string == null) {
            AddGoogleMavenRepositoryHyperlink.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public VirtualFile getBuildFile() {
        VirtualFile virtualFile = this.myBuildFile;
        if (virtualFile == null) {
            AddGoogleMavenRepositoryHyperlink.$$$reportNull$$$0(4);
        }
        return virtualFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/hyperlink/AddGoogleMavenRepositoryHyperlink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/hyperlink/AddGoogleMavenRepositoryHyperlink";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

