/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues;

import com.android.builder.model.SyncIssue;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.SdkMavenRepository;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoPackage;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.repositories.RepositoriesModel;
import com.android.tools.idea.gradle.dsl.model.util.GoogleMavenRepository;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.hyperlink.AddGoogleMavenRepositoryHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.DisableOfflineModeHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.FixAndroidGradlePluginVersionHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.InstallArtifactHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.InstallRepositoryHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.ShowDependencyInProjectStructureHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.ShowSyncIssuesDetailsHyperlink;
import com.android.tools.idea.gradle.project.sync.issues.BaseSyncIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.ConstraintLayoutFeature;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.PositionInFile;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.StudioSdkUtil;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.NonNavigatable;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyLexer;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;

public class UnresolvedDependenciesReporter
extends BaseSyncIssuesReporter {
    private static final String UNRESOLVED_DEPENDENCIES_GROUP = "Unresolved dependencies";
    private static final String OPEN_FILE_HYPERLINK_TEXT = "Open File";

    @NotNull
    public static UnresolvedDependenciesReporter getInstance() {
        UnresolvedDependenciesReporter unresolvedDependenciesReporter = (UnresolvedDependenciesReporter)ServiceManager.getService(UnresolvedDependenciesReporter.class);
        if (unresolvedDependenciesReporter == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(0);
        }
        return unresolvedDependenciesReporter;
    }

    @Override
    int getSupportedIssueType() {
        return 2;
    }

    @Override
    void report(@NotNull SyncIssue syncIssue, @NotNull Module module, @Nullable VirtualFile buildFile) {
        String dependency;
        if (syncIssue == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(1);
        }
        if (module == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(2);
        }
        if ((dependency = syncIssue.getData()) != null) {
            this.report(dependency, module, buildFile);
        } else {
            this.reportWithoutDependencyInfo(syncIssue, module, buildFile);
        }
    }

    public void report(@NotNull Collection<String> unresolvedDependencies, @NotNull Module module) {
        if (unresolvedDependencies == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(3);
        }
        if (module == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(4);
        }
        if (unresolvedDependencies.isEmpty()) {
            return;
        }
        VirtualFile buildFile = GradleUtil.getGradleBuildFile(module);
        for (String dependency : unresolvedDependencies) {
            this.report(dependency, module, buildFile);
        }
        GradleSyncState.getInstance(module.getProject()).getSummary().setSyncErrorsFound(true);
    }

    private void report(@NotNull String dependency, @NotNull Module module, @Nullable VirtualFile buildFile) {
        SyncMessage message;
        if (dependency == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(5);
        }
        if (module == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(6);
        }
        String group = "Unresolved Android dependencies";
        GradleCoordinate coordinate = GradleCoordinate.parseCoordinateString((String)dependency);
        RepoPackage constraintPackage = null;
        if (coordinate != null) {
            StudioLoggerProgressIndicator indicator = new StudioLoggerProgressIndicator(this.getClass());
            StudioSdkUtil.reloadRemoteSdkWithModalProgress();
            Collection<RemotePackage> remotePackages = UnresolvedDependenciesReporter.getRemotePackages((ProgressIndicator)indicator);
            constraintPackage = SdkMavenRepository.findBestPackageMatching((GradleCoordinate)coordinate, remotePackages);
        }
        ArrayList<NotificationHyperlink> quickFixes = new ArrayList<NotificationHyperlink>();
        if (dependency.startsWith("com.android.support.constraint:constraint-layout:") && !ConstraintLayoutFeature.isSupportedInSdkManager(module)) {
            quickFixes.add(new FixAndroidGradlePluginVersionHyperlink());
        } else if (constraintPackage != null) {
            quickFixes.add(new InstallArtifactHyperlink(constraintPackage.getPath()));
        } else if (dependency.startsWith("com.android.support")) {
            UnresolvedDependenciesReporter.addGoogleMavenRepositoryHyperlink(module, buildFile, quickFixes);
        } else if (dependency.startsWith("com.google.android")) {
            quickFixes.add(new InstallRepositoryHyperlink(SdkMavenRepository.GOOGLE, dependency));
        } else {
            group = UNRESOLVED_DEPENDENCIES_GROUP;
            Project project = module.getProject();
            if (Projects.isOfflineBuildModeEnabled(project)) {
                quickFixes.add(new DisableOfflineModeHyperlink());
            }
        }
        String text = "Failed to resolve: " + dependency;
        if (buildFile != null) {
            PositionInFile position = UnresolvedDependenciesReporter.findDependencyPosition(dependency, buildFile);
            message = new SyncMessage(module.getProject(), group, MessageType.ERROR, position, text);
            String hyperlinkText = position.line > -1 ? "Show in File" : OPEN_FILE_HYPERLINK_TEXT;
            quickFixes.add(new OpenFileHyperlink(buildFile.getPath(), hyperlinkText, position.line, position.column));
        } else {
            message = new SyncMessage(group, MessageType.ERROR, NonNavigatable.INSTANCE, text);
        }
        if (IdeInfo.getInstance().isAndroidStudio() && coordinate != null) {
            quickFixes.add(new ShowDependencyInProjectStructureHyperlink(module, coordinate));
        }
        message.add(quickFixes);
        this.getSyncMessages(module).report(message);
    }

    @NotNull
    private static PositionInFile findDependencyPosition(@NotNull String dependency, @NotNull VirtualFile buildFile) {
        TextRange textRange;
        if (dependency == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(7);
        }
        if (buildFile == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(8);
        }
        int line = -1;
        int column = -1;
        Document document = FileDocumentManager.getInstance().getDocument(buildFile);
        if (document != null && (textRange = UnresolvedDependenciesReporter.findDependency(dependency, document)) != null && (line = document.getLineNumber(textRange.getStartOffset())) > -1) {
            int lineStartOffset = document.getLineStartOffset(line);
            column = textRange.getStartOffset() - lineStartOffset;
        }
        PositionInFile positionInFile = new PositionInFile(buildFile, line, column);
        if (positionInFile == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(9);
        }
        return positionInFile;
    }

    @NotNull
    private static Collection<RemotePackage> getRemotePackages(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(10);
        }
        AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        RepositoryPackages packages = sdkHandler.getSdkManager(indicator).getPackages();
        Collection<RemotePackage> collection = packages.getRemotePackages().values();
        if (collection == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(11);
        }
        return collection;
    }

    @Nullable
    private static TextRange findDependency(@NotNull String dependency, @NotNull Document buildFile) {
        if (dependency == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(12);
        }
        if (buildFile == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(13);
        }
        Function consumer = pair -> {
            GroovyLexer lexer = (GroovyLexer)pair.getSecond();
            return TextRange.create((int)(lexer.getTokenStart() + 1), (int)(lexer.getTokenEnd() - 1));
        };
        GroovyLexer lexer = new GroovyLexer();
        lexer.start((CharSequence)buildFile.getText());
        while (lexer.getTokenType() != null) {
            String text;
            IElementType type = lexer.getTokenType();
            if (type == GroovyTokenTypes.mSTRING_LITERAL && (text = StringUtil.unquoteString((String)lexer.getTokenText())).startsWith(dependency)) {
                return (TextRange)consumer.fun((Object)Pair.create((Object)text, (Object)lexer));
            }
            lexer.advance();
        }
        return null;
    }

    private void reportWithoutDependencyInfo(@NotNull SyncIssue syncIssue, @NotNull Module module, @Nullable VirtualFile buildFile) {
        SyncMessage message;
        if (syncIssue == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(14);
        }
        if (module == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(15);
        }
        String text = syncIssue.getMessage();
        ArrayList<NotificationHyperlink> quickFixes = new ArrayList<NotificationHyperlink>();
        if (buildFile != null) {
            PositionInFile position = new PositionInFile(buildFile, -1, 1);
            message = new SyncMessage(module.getProject(), UNRESOLVED_DEPENDENCIES_GROUP, MessageType.ERROR, position, text);
            quickFixes.add(new OpenFileHyperlink(buildFile.getPath(), OPEN_FILE_HYPERLINK_TEXT, position.line, position.column));
        } else {
            message = new SyncMessage(UNRESOLVED_DEPENDENCIES_GROUP, MessageType.ERROR, NonNavigatable.INSTANCE, text);
        }
        ArrayList<String> extraInfo = new ArrayList<String>();
        try {
            List multiLineMessage = syncIssue.getMultiLineMessage();
            if (multiLineMessage != null) {
                extraInfo.addAll(multiLineMessage);
            }
        }
        catch (UnsupportedMethodException unsupportedMethodException) {
            // empty catch block
        }
        if (!extraInfo.isEmpty()) {
            quickFixes.add(new ShowSyncIssuesDetailsHyperlink(text, extraInfo));
        }
        message.add(quickFixes);
        this.getSyncMessages(module).report(message);
    }

    private static void addGoogleMavenRepositoryHyperlink(@NotNull Module module, @Nullable VirtualFile buildFile, @NotNull List<NotificationHyperlink> fixes) {
        if (module == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(16);
        }
        if (fixes == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(17);
        }
        Project project = module.getProject();
        if (buildFile != null) {
            GradleBuildModel moduleBuildModel = GradleBuildModel.parseBuildFile(buildFile, project, module.getName());
            if (!GoogleMavenRepository.hasGoogleMavenRepository(moduleBuildModel.repositories())) {
                fixes.add(new AddGoogleMavenRepositoryHyperlink(buildFile));
            }
        } else {
            RepositoriesModel repositories;
            GradleBuildModel projectBuildModel = GradleBuildModel.get(project);
            if (projectBuildModel != null && !GoogleMavenRepository.hasGoogleMavenRepository(repositories = projectBuildModel.repositories())) {
                fixes.add(new AddGoogleMavenRepositoryHyperlink(projectBuildModel.getVirtualFile()));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/issues/UnresolvedDependenciesReporter";
                break;
            }
            case 1: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncIssue";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unresolvedDependencies";
                break;
            }
            case 5: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/issues/UnresolvedDependenciesReporter";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findDependencyPosition";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemotePackages";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "report";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findDependencyPosition";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRemotePackages";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findDependency";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "reportWithoutDependencyInfo";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addGoogleMavenRepositoryHyperlink";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

