/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.idea;

import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.ng.SyncAction;
import com.android.tools.idea.gradle.project.sync.setup.Facets;
import com.android.tools.idea.gradle.project.sync.setup.module.idea.JavaModuleSetupStep;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class JavaModuleSetup {
    @NotNull
    private final JavaModuleSetupStep[] mySetupSteps;

    public JavaModuleSetup(JavaModuleSetupStep ... setupSteps) {
        if (setupSteps == null) {
            JavaModuleSetup.$$$reportNull$$$0(0);
        }
        this.mySetupSteps = setupSteps;
    }

    public void setUpModule(@NotNull Module module, @NotNull IdeModifiableModelsProvider ideModelsProvider, @NotNull JavaModuleModel javaModuleModel, SyncAction.ModuleModels models, ProgressIndicator indicator, boolean syncSkipped) {
        if (module == null) {
            JavaModuleSetup.$$$reportNull$$$0(1);
        }
        if (ideModelsProvider == null) {
            JavaModuleSetup.$$$reportNull$$$0(2);
        }
        if (javaModuleModel == null) {
            JavaModuleSetup.$$$reportNull$$$0(3);
        }
        if (javaModuleModel.isAndroidModuleWithoutVariants()) {
            GradleSyncMessages messages = GradleSyncMessages.getInstance(module.getProject());
            String[] text = new String[]{String.format("The module '%1$s' is an Android project without build variants, and cannot be built.", module.getName()), "Please fix the module's configuration in the build.gradle file and sync the project again."};
            messages.report(new SyncMessage("Project Structure Issues", MessageType.ERROR, text));
            JavaModuleSetup.cleanUpAndroidModuleWithoutVariants(module, ideModelsProvider);
            return;
        }
        for (JavaModuleSetupStep step : this.mySetupSteps) {
            if (syncSkipped && !step.invokeOnSkippedSync()) continue;
            step.setUpModule(module, ideModelsProvider, javaModuleModel, models, indicator);
        }
    }

    private static void cleanUpAndroidModuleWithoutVariants(@NotNull Module module, @NotNull IdeModifiableModelsProvider ideModelsProvider) {
        if (module == null) {
            JavaModuleSetup.$$$reportNull$$$0(4);
        }
        if (ideModelsProvider == null) {
            JavaModuleSetup.$$$reportNull$$$0(5);
        }
        Facets.removeAllFacets(ideModelsProvider.getModifiableFacetModel(module), AndroidFacet.ID);
        ModifiableRootModel rootModel = ideModelsProvider.getModifiableRootModel(module);
        for (ContentEntry contentEntry : rootModel.getContentEntries()) {
            contentEntry.clearSourceFolders();
            contentEntry.clearExcludeFolders();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setupSteps";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModelsProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaModuleModel";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/module/idea/JavaModuleSetup";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setUpModule";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "cleanUpAndroidModuleWithoutVariants";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

