/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.structure.configurables.ui.PsUISettings;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.tooling.model.GradleModuleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsArtifactDependencySpec {
    @NotNull
    private final String myName;
    @Nullable
    private final String myGroup;
    @Nullable
    private final String myVersion;
    private static final Pattern ourPattern = Pattern.compile("^(?:([^:@]*):)?([^\\d+:@][^:@]*)(?::([^:@]*))?(?::[^@]*)?(?:@.*)?$");

    @Nullable
    public static PsArtifactDependencySpec create(@NotNull String notation) {
        Matcher matcher;
        if (notation == null) {
            PsArtifactDependencySpec.$$$reportNull$$$0(0);
        }
        if (!(matcher = ourPattern.matcher(notation)).matches()) {
            return null;
        }
        return new PsArtifactDependencySpec(matcher.group(2), matcher.group(1), matcher.group(3));
    }

    @NotNull
    public static PsArtifactDependencySpec create(@NotNull ArtifactDependencyModel dependency) {
        if (dependency == null) {
            PsArtifactDependencySpec.$$$reportNull$$$0(1);
        }
        PsArtifactDependencySpec psArtifactDependencySpec = new PsArtifactDependencySpec(dependency.name().value(), (String)dependency.group().value(), (String)dependency.version().value());
        if (psArtifactDependencySpec == null) {
            PsArtifactDependencySpec.$$$reportNull$$$0(2);
        }
        return psArtifactDependencySpec;
    }

    @NotNull
    public static PsArtifactDependencySpec create(@NotNull GradleCoordinate coordinates) {
        if (coordinates == null) {
            PsArtifactDependencySpec.$$$reportNull$$$0(3);
        }
        PsArtifactDependencySpec psArtifactDependencySpec = new PsArtifactDependencySpec(coordinates.getArtifactId(), coordinates.getGroupId(), coordinates.getRevision());
        if (psArtifactDependencySpec == null) {
            PsArtifactDependencySpec.$$$reportNull$$$0(4);
        }
        return psArtifactDependencySpec;
    }

    @NotNull
    public static PsArtifactDependencySpec create(@NotNull GradleModuleVersion moduleVersion) {
        if (moduleVersion == null) {
            PsArtifactDependencySpec.$$$reportNull$$$0(5);
        }
        PsArtifactDependencySpec psArtifactDependencySpec = new PsArtifactDependencySpec(moduleVersion.getName(), moduleVersion.getGroup(), moduleVersion.getVersion());
        if (psArtifactDependencySpec == null) {
            PsArtifactDependencySpec.$$$reportNull$$$0(6);
        }
        return psArtifactDependencySpec;
    }

    public PsArtifactDependencySpec(@NotNull String name, @Nullable String group, @Nullable String version) {
        if (name == null) {
            PsArtifactDependencySpec.$$$reportNull$$$0(7);
        }
        this.myName = name;
        this.myGroup = Strings.emptyToNull((String)group);
        this.myVersion = Strings.emptyToNull((String)version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsArtifactDependencySpec that = (PsArtifactDependencySpec)o;
        return Objects.equal((Object)this.myName, (Object)that.myName) && Objects.equal((Object)this.myGroup, (Object)that.myGroup) && Objects.equal((Object)this.myVersion, (Object)that.myVersion);
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            PsArtifactDependencySpec.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    public String getGroup() {
        return this.myGroup;
    }

    @Nullable
    public String getVersion() {
        return this.myVersion;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.myName, this.myGroup, this.myVersion});
    }

    public String toString() {
        return this.compactNotation();
    }

    @NotNull
    public String compactNotation() {
        ArrayList segments = Lists.newArrayList((Object[])new String[]{this.myGroup, this.myName, this.myVersion});
        String string = Joiner.on((String)":").skipNulls().join((Iterable)segments);
        if (string == null) {
            PsArtifactDependencySpec.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public String getDisplayText() {
        boolean showGroupId = PsUISettings.getInstance().DECLARED_DEPENDENCIES_SHOW_GROUP_ID;
        StringBuilder text = new StringBuilder();
        if (showGroupId && StringUtil.isNotEmpty((String)this.myGroup)) {
            text.append(this.myGroup).append(":");
        }
        text.append(this.myName);
        if (StringUtil.isNotEmpty((String)this.myVersion)) {
            text.append(":").append(this.myVersion);
        }
        String string = text.toString();
        if (string == null) {
            PsArtifactDependencySpec.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/model/PsArtifactDependencySpec";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coordinates";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleVersion";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/model/PsArtifactDependencySpec";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "compactNotation";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

