/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.android;

import com.android.builder.model.level2.Library;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ModuleDependencyModel;
import com.android.tools.idea.gradle.project.model.ide.android.IdeBaseArtifact;
import com.android.tools.idea.gradle.project.model.ide.android.level2.IdeDependencies;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsDependency;
import com.android.tools.idea.gradle.structure.model.PsModelCollection;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.PsParsedDependencies;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidArtifact;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidDependency;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.android.PsLibraryAndroidDependency;
import com.android.tools.idea.gradle.structure.model.android.PsModuleAndroidDependency;
import com.android.tools.idea.gradle.structure.model.android.PsVariant;
import com.android.tools.idea.gradle.structure.model.pom.MavenPoms;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PsAndroidDependencyCollection
implements PsModelCollection<PsAndroidDependency> {
    @NotNull
    private final PsAndroidModule myParent;
    @NotNull
    private final Map<String, PsModuleAndroidDependency> myModuleDependenciesByGradlePath;
    @NotNull
    private final Map<String, PsLibraryAndroidDependency> myLibraryDependenciesBySpec;

    PsAndroidDependencyCollection(@NotNull PsAndroidModule parent) {
        if (parent == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(0);
        }
        this.myModuleDependenciesByGradlePath = Maps.newHashMap();
        this.myLibraryDependenciesBySpec = Maps.newHashMap();
        this.myParent = parent;
        parent.forEachVariant(this::addDependencies);
    }

    private void addDependencies(@NotNull PsVariant variant) {
        if (variant == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(1);
        }
        variant.forEachArtifact(this::collectDependencies);
    }

    private void collectDependencies(@NotNull PsAndroidArtifact artifact) {
        IdeBaseArtifact resolvedArtifact;
        if (artifact == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(2);
        }
        if ((resolvedArtifact = artifact.getResolvedModel()) == null) {
            return;
        }
        IdeDependencies dependencies2 = resolvedArtifact.getLevel2Dependencies();
        for (Library androidLibrary : dependencies2.getAndroidLibraries()) {
            this.addLibrary(androidLibrary, artifact);
        }
        for (Library moduleLibrary : dependencies2.getModuleDependencies()) {
            String gradlePath = moduleLibrary.getProjectPath();
            if (gradlePath == null) continue;
            this.addModule(gradlePath, artifact, moduleLibrary.getVariant());
        }
        for (Library javaLibrary : dependencies2.getJavaLibraries()) {
            this.addLibrary(javaLibrary, artifact);
        }
    }

    private void addModule(@NotNull String gradlePath, @NotNull PsAndroidArtifact artifact, @Nullable String projectVariant) {
        PsModuleAndroidDependency dependency;
        if (gradlePath == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(3);
        }
        if (artifact == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(4);
        }
        PsParsedDependencies parsedDependencies = this.myParent.getParsedDependencies();
        ModuleDependencyModel matchingParsedDependency = parsedDependencies.findModuleDependency(gradlePath, artifact::contains);
        Module resolvedModule = null;
        PsModule module = this.myParent.getParent().findModuleByGradlePath(gradlePath);
        if (module != null) {
            resolvedModule = module.getResolvedModel();
        }
        if ((dependency = (PsModuleAndroidDependency)this.findElement(gradlePath, PsModuleAndroidDependency.class)) == null) {
            dependency = new PsModuleAndroidDependency(this.myParent, gradlePath, artifact, projectVariant, resolvedModule, matchingParsedDependency);
            this.myModuleDependenciesByGradlePath.put(gradlePath, dependency);
        }
        PsAndroidDependencyCollection.updateDependency(dependency, artifact, matchingParsedDependency);
    }

    @Nullable
    private PsAndroidDependency addLibrary(@NotNull Library library, @NotNull PsAndroidArtifact artifact) {
        if (library == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(5);
        }
        if (artifact == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(6);
        }
        PsParsedDependencies parsedDependencies = this.myParent.getParsedDependencies();
        GradleCoordinate coordinates = GradleCoordinate.parseCoordinateString((String)library.getArtifactAddress());
        if (coordinates != null) {
            PsArtifactDependencySpec spec = PsArtifactDependencySpec.create(coordinates);
            ArtifactDependencyModel matchingParsedDependency = parsedDependencies.findLibraryDependency(coordinates, artifact::contains);
            if (matchingParsedDependency != null) {
                String parsedVersionValue = (String)matchingParsedDependency.version().value();
                if (parsedVersionValue != null) {
                    GradleVersion parsedVersion = GradleVersion.tryParse((String)parsedVersionValue);
                    GradleVersion versionFromGradle = GradleVersion.parse((String)coordinates.getRevision());
                    if (parsedVersion != null && PsAndroidDependencyCollection.compare(parsedVersion, versionFromGradle) == 0) {
                        return this.addLibrary(library, spec, artifact, matchingParsedDependency);
                    }
                    PsLibraryAndroidDependency potentialDuplicate = null;
                    for (PsLibraryAndroidDependency dependency : this.myLibraryDependenciesBySpec.values()) {
                        if (!dependency.getParsedModels().contains((Object)matchingParsedDependency)) continue;
                        potentialDuplicate = dependency;
                        break;
                    }
                    if (potentialDuplicate != null) {
                        // empty if block
                    }
                    this.addLibrary(library, spec, artifact, matchingParsedDependency);
                    return this.addLibrary(library, spec, artifact, null);
                }
            } else {
                return this.addLibrary(library, spec, artifact, null);
            }
        }
        return null;
    }

    @Nullable
    private PsAndroidDependency addLibrary(@NotNull Library library, @NotNull PsArtifactDependencySpec resolvedSpec, @NotNull PsAndroidArtifact artifact, @Nullable ArtifactDependencyModel parsedModel) {
        if (library == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(7);
        }
        if (resolvedSpec == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(8);
        }
        if (artifact == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(9);
        }
        PsAndroidDependency dependency = this.getOrCreateDependency(resolvedSpec, library, artifact, parsedModel);
        PsAndroidDependencyCollection.updateDependency(dependency, artifact, parsedModel);
        return null;
    }

    private void addTransitive(@NotNull Library transitiveDependency, @NotNull PsAndroidArtifact artifact, @NotNull PsAndroidDependency dependency) {
        PsAndroidDependency transitive;
        if (transitiveDependency == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(10);
        }
        if (artifact == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(11);
        }
        if (dependency == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(12);
        }
        if ((transitive = this.addLibrary(transitiveDependency, artifact)) != null && dependency instanceof PsLibraryAndroidDependency) {
            PsLibraryAndroidDependency libraryDependency = (PsLibraryAndroidDependency)dependency;
            libraryDependency.addTransitiveDependency(transitive.toText(PsDependency.TextType.PLAIN_TEXT));
        }
    }

    @VisibleForTesting
    static int compare(@NotNull GradleVersion parsedVersion, @NotNull GradleVersion versionFromGradle) {
        int result;
        if (parsedVersion == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(13);
        }
        if (versionFromGradle == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(14);
        }
        if ((result = versionFromGradle.compareTo(parsedVersion)) == 0) {
            return result;
        }
        if (result < 0) {
            if (parsedVersion.getMajorSegment().acceptsGreaterValue()) {
                return 0;
            }
            if (parsedVersion.getMinorSegment() != null && parsedVersion.getMinorSegment().acceptsGreaterValue()) {
                return parsedVersion.getMajor() - versionFromGradle.getMajor();
            }
            if (parsedVersion.getMicroSegment() != null && parsedVersion.getMicroSegment().acceptsGreaterValue()) {
                result = parsedVersion.getMajor() - versionFromGradle.getMajor();
                if (result != 0) {
                    return result;
                }
                return parsedVersion.getMinor() - versionFromGradle.getMinor();
            }
        }
        return result;
    }

    @NotNull
    private PsAndroidDependency getOrCreateDependency(@NotNull PsArtifactDependencySpec resolvedSpec, @NotNull Library library, @NotNull PsAndroidArtifact artifact, @Nullable ArtifactDependencyModel parsedModel) {
        String compactNotation;
        PsLibraryAndroidDependency dependency;
        if (resolvedSpec == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(15);
        }
        if (library == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(16);
        }
        if (artifact == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(17);
        }
        if ((dependency = this.myLibraryDependenciesBySpec.get(compactNotation = resolvedSpec.toString())) == null) {
            dependency = new PsLibraryAndroidDependency(this.myParent, resolvedSpec, artifact, library, parsedModel);
            this.myLibraryDependenciesBySpec.put(compactNotation, dependency);
            File libraryPath = library.getArtifact();
            List<PsArtifactDependencySpec> pomDependencies = Collections.emptyList();
            if (libraryPath != null) {
                pomDependencies = MavenPoms.findDependenciesInPomFile(libraryPath);
            }
            dependency.setDependenciesFromPomFile(pomDependencies);
        } else if (parsedModel != null) {
            dependency.addParsedModel(parsedModel);
        }
        PsLibraryAndroidDependency psLibraryAndroidDependency = dependency;
        if (psLibraryAndroidDependency == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(18);
        }
        return psLibraryAndroidDependency;
    }

    @Nullable
    PsLibraryAndroidDependency findElement(PsArtifactDependencySpec spec) {
        PsLibraryAndroidDependency dependency = (PsLibraryAndroidDependency)this.findElement(spec.toString(), PsLibraryAndroidDependency.class);
        if (dependency != null) {
            return dependency;
        }
        if (StringUtil.isEmpty((String)spec.getVersion())) {
            ArrayList found = Lists.newArrayList();
            for (String specText : this.myLibraryDependenciesBySpec.keySet()) {
                PsArtifactDependencySpec storedSpec = PsArtifactDependencySpec.create(specText);
                if (storedSpec == null || !Objects.equals(storedSpec.getGroup(), spec.getGroup()) || !Objects.equals(storedSpec.getName(), spec.getName())) continue;
                found.add(specText);
            }
            if (found.size() == 1) {
                return this.myLibraryDependenciesBySpec.get(found.get(0));
            }
        }
        return null;
    }

    @Override
    @Nullable
    public <S extends PsAndroidDependency> S findElement(@NotNull String name, @Nullable Class<S> type) {
        if (name == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(19);
        }
        if (PsModuleAndroidDependency.class.equals(type)) {
            return (S)((PsAndroidDependency)type.cast(this.myModuleDependenciesByGradlePath.get(name)));
        }
        if (PsLibraryAndroidDependency.class.equals(type)) {
            return (S)((PsAndroidDependency)type.cast(this.myLibraryDependenciesBySpec.get(name)));
        }
        return null;
    }

    @Override
    public void forEach(@NotNull Consumer<PsAndroidDependency> consumer) {
        if (consumer == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(20);
        }
        PsAndroidDependencyCollection.forEachDependency(this.myLibraryDependenciesBySpec, consumer);
        PsAndroidDependencyCollection.forEachDependency(this.myModuleDependenciesByGradlePath, consumer);
    }

    private static void forEachDependency(@NotNull Map<String, ? extends PsAndroidDependency> dependenciesBySpec, @NotNull Consumer<PsAndroidDependency> consumer) {
        if (dependenciesBySpec == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(21);
        }
        if (consumer == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(22);
        }
        dependenciesBySpec.values().forEach(consumer);
    }

    void forEachDeclaredDependency(@NotNull Consumer<PsAndroidDependency> consumer) {
        if (consumer == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(23);
        }
        PsAndroidDependencyCollection.forEachDeclaredDependency(this.myLibraryDependenciesBySpec, consumer);
        PsAndroidDependencyCollection.forEachDeclaredDependency(this.myModuleDependenciesByGradlePath, consumer);
    }

    private static void forEachDeclaredDependency(@NotNull Map<String, ? extends PsAndroidDependency> dependenciesBySpec, @NotNull Consumer<PsAndroidDependency> consumer) {
        if (dependenciesBySpec == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(24);
        }
        if (consumer == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(25);
        }
        dependenciesBySpec.values().stream().filter(PsDependency::isDeclared).forEach(consumer);
    }

    void forEachModuleDependency(@NotNull Consumer<PsModuleAndroidDependency> consumer) {
        if (consumer == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(26);
        }
        this.myModuleDependenciesByGradlePath.values().forEach(consumer);
    }

    void addLibraryDependency(@NotNull PsArtifactDependencySpec spec, @NotNull PsAndroidArtifact artifact, @Nullable ArtifactDependencyModel parsedModel) {
        PsLibraryAndroidDependency dependency;
        if (spec == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(27);
        }
        if (artifact == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(28);
        }
        if ((dependency = this.myLibraryDependenciesBySpec.get(spec.toString())) == null) {
            dependency = new PsLibraryAndroidDependency(this.myParent, spec, artifact, null, parsedModel);
            this.myLibraryDependenciesBySpec.put(spec.toString(), dependency);
        } else {
            PsAndroidDependencyCollection.updateDependency(dependency, artifact, parsedModel);
        }
    }

    private static void updateDependency(@NotNull PsAndroidDependency dependency, @NotNull PsAndroidArtifact artifact, @Nullable DependencyModel parsedModel) {
        if (dependency == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(29);
        }
        if (artifact == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(30);
        }
        if (parsedModel != null) {
            dependency.addParsedModel(parsedModel);
        }
        dependency.addContainer(artifact);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 17: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradlePath";
                break;
            }
            case 5: 
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedSpec";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transitiveDependency";
                break;
            }
            case 12: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parsedVersion";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionFromGradle";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/model/android/PsAndroidDependencyCollection";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependenciesBySpec";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spec";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/model/android/PsAndroidDependencyCollection";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateDependency";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addDependencies";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectDependencies";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addModule";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addLibrary";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addTransitive";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateDependency";
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findElement";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "forEach";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "forEachDependency";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "forEachDeclaredDependency";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "forEachModuleDependency";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addLibraryDependency";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "updateDependency";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

