/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.variant.view;

import com.android.builder.model.level2.Library;
import com.android.tools.idea.gradle.project.build.GradleProjectBuilder;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacetConfiguration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.model.ide.android.IdeVariant;
import com.android.tools.idea.gradle.project.sync.setup.module.AndroidModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.setup.module.NdkModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.setup.module.android.CompilerOutputModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.setup.module.android.ContentRootsModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.setup.module.android.DependenciesAndroidModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.setup.module.ndk.ContentRootModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.setup.post.PostSyncProjectSetup;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BuildVariantUpdater {
    @NotNull
    private final IdeModifiableModelsProviderFactory myModifiableModelsProviderFactory;
    @NotNull
    private final List<AndroidModuleSetupStep> myAndroidModuleSetupSteps;
    @NotNull
    private final NdkModuleSetupStep[] myNdkModuleSetupSteps;

    BuildVariantUpdater() {
        this(new IdeModifiableModelsProviderFactory(), Arrays.asList(new ContentRootsModuleSetupStep(), new DependenciesAndroidModuleSetupStep(), new CompilerOutputModuleSetupStep()));
    }

    @VisibleForTesting
    BuildVariantUpdater(@NotNull IdeModifiableModelsProviderFactory modifiableModelsProviderFactory, @NotNull List<AndroidModuleSetupStep> androidModuleSetupSteps) {
        if (modifiableModelsProviderFactory == null) {
            BuildVariantUpdater.$$$reportNull$$$0(0);
        }
        if (androidModuleSetupSteps == null) {
            BuildVariantUpdater.$$$reportNull$$$0(1);
        }
        this.myNdkModuleSetupSteps = new NdkModuleSetupStep[]{new ContentRootModuleSetupStep()};
        this.myModifiableModelsProviderFactory = modifiableModelsProviderFactory;
        this.myAndroidModuleSetupSteps = androidModuleSetupSteps;
    }

    boolean updateSelectedVariant(@NotNull Project project, @NotNull String moduleName, @NotNull String buildVariantName) {
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(2);
        }
        if (moduleName == null) {
            BuildVariantUpdater.$$$reportNull$$$0(3);
        }
        if (buildVariantName == null) {
            BuildVariantUpdater.$$$reportNull$$$0(4);
        }
        ArrayList affectedAndroidFacets = new ArrayList();
        ArrayList affectedNdkFacets = new ArrayList();
        Projects.executeProjectChanges(project, () -> {
            if (project == null) {
                BuildVariantUpdater.$$$reportNull$$$0(37);
            }
            if (moduleName == null) {
                BuildVariantUpdater.$$$reportNull$$$0(38);
            }
            if (buildVariantName == null) {
                BuildVariantUpdater.$$$reportNull$$$0(39);
            }
            this.doUpdate(project, moduleName, buildVariantName, affectedAndroidFacets, affectedNdkFacets);
            PostSyncProjectSetup.Request setupRequest = new PostSyncProjectSetup.Request();
            setupRequest.setGenerateSourcesAfterSync(false).setCleanProjectAfterSync(false);
            PostSyncProjectSetup.getInstance(project).setUpProject(setupRequest, (ProgressIndicator)new EmptyProgressIndicator());
            BuildVariantUpdater.generateSourcesIfNeeded(project, affectedAndroidFacets);
        });
        return !affectedAndroidFacets.isEmpty() || !affectedNdkFacets.isEmpty();
    }

    private void doUpdate(@NotNull Project project, @NotNull String moduleName, @NotNull String variant, @NotNull List<AndroidFacet> affectedAndroidFacets, @NotNull List<NdkFacet> affectedNdkFacets) {
        Module moduleToUpdate;
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(5);
        }
        if (moduleName == null) {
            BuildVariantUpdater.$$$reportNull$$$0(6);
        }
        if (variant == null) {
            BuildVariantUpdater.$$$reportNull$$$0(7);
        }
        if (affectedAndroidFacets == null) {
            BuildVariantUpdater.$$$reportNull$$$0(8);
        }
        if (affectedNdkFacets == null) {
            BuildVariantUpdater.$$$reportNull$$$0(9);
        }
        if ((moduleToUpdate = BuildVariantUpdater.findModule(project, moduleName)) == null) {
            BuildVariantUpdater.logAndShowUpdateFailure(variant, String.format("Cannot find module '%1$s'.", moduleName));
            return;
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance(moduleToUpdate);
        NdkFacet ndkFacet = NdkFacet.getInstance(moduleToUpdate);
        if (androidFacet == null && ndkFacet == null) {
            String msg = String.format("Cannot find 'Android' or 'Native-Android-Gradle' facets in module '%1$s'.", moduleToUpdate.getName());
            BuildVariantUpdater.logAndShowUpdateFailure(variant, msg);
        }
        if (ndkFacet != null) {
            NdkModuleModel ndkModuleModel = BuildVariantUpdater.getNativeAndroidModel(ndkFacet, variant);
            if (ndkModuleModel == null || !this.updateSelectedVariant(ndkFacet, ndkModuleModel, variant)) {
                return;
            }
            affectedNdkFacets.add(ndkFacet);
        }
        if (androidFacet != null) {
            AndroidModuleModel androidModel = BuildVariantUpdater.getAndroidModel(androidFacet, variant);
            if (androidModel == null || !this.updateSelectedVariant(androidFacet, androidModel, variant, affectedAndroidFacets)) {
                return;
            }
            affectedAndroidFacets.add(androidFacet);
        }
    }

    @Nullable
    private static Module findModule(@NotNull Project project, @NotNull String moduleName) {
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(10);
        }
        if (moduleName == null) {
            BuildVariantUpdater.$$$reportNull$$$0(11);
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        return moduleManager.findModuleByName(moduleName);
    }

    private boolean updateSelectedVariant(@NotNull AndroidFacet androidFacet, @NotNull AndroidModuleModel androidModel, @NotNull String variantToSelect, @NotNull List<AndroidFacet> affectedFacets) {
        IdeVariant selectedVariant;
        if (androidFacet == null) {
            BuildVariantUpdater.$$$reportNull$$$0(12);
        }
        if (androidModel == null) {
            BuildVariantUpdater.$$$reportNull$$$0(13);
        }
        if (variantToSelect == null) {
            BuildVariantUpdater.$$$reportNull$$$0(14);
        }
        if (affectedFacets == null) {
            BuildVariantUpdater.$$$reportNull$$$0(15);
        }
        if (variantToSelect.equals((selectedVariant = androidModel.getSelectedVariant()).getName())) {
            return false;
        }
        androidModel.setSelectedVariantName(variantToSelect);
        androidModel.syncSelectedVariantAndTestArtifact(androidFacet);
        Module module = this.setUpModule(androidFacet.getModule(), androidModel);
        for (Library library : androidModel.getSelectedMainCompileLevel2Dependencies().getModuleDependencies()) {
            String projectVariant;
            String gradlePath = library.getProjectPath();
            if (StringUtil.isEmpty((String)gradlePath) || !StringUtil.isNotEmpty((String)(projectVariant = library.getVariant()))) continue;
            this.ensureVariantIsSelected(module.getProject(), gradlePath, projectVariant, affectedFacets);
        }
        return true;
    }

    private boolean updateSelectedVariant(@NotNull NdkFacet ndkFacet, @NotNull NdkModuleModel ndkModuleModel, @NotNull String variantToSelect) {
        NdkModuleModel.NdkVariant selectedVariant;
        if (ndkFacet == null) {
            BuildVariantUpdater.$$$reportNull$$$0(16);
        }
        if (ndkModuleModel == null) {
            BuildVariantUpdater.$$$reportNull$$$0(17);
        }
        if (variantToSelect == null) {
            BuildVariantUpdater.$$$reportNull$$$0(18);
        }
        if (variantToSelect.equals((selectedVariant = ndkModuleModel.getSelectedVariant()).getName())) {
            return false;
        }
        ndkModuleModel.setSelectedVariantName(variantToSelect);
        ((NdkFacetConfiguration)ndkFacet.getConfiguration()).SELECTED_BUILD_VARIANT = ndkModuleModel.getSelectedVariant().getName();
        this.setUpModule(ndkFacet.getModule(), ndkModuleModel);
        return true;
    }

    private static void generateSourcesIfNeeded(@NotNull Project project, @NotNull List<AndroidFacet> affectedFacets) {
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(19);
        }
        if (affectedFacets == null) {
            BuildVariantUpdater.$$$reportNull$$$0(20);
        }
        if (!affectedFacets.isEmpty() && !ApplicationManager.getApplication().isUnitTestMode()) {
            GradleProjectBuilder.getInstance(project).generateSources();
        }
    }

    @NotNull
    private Module setUpModule(@NotNull Module module, @NotNull AndroidModuleModel androidModel) {
        if (module == null) {
            BuildVariantUpdater.$$$reportNull$$$0(21);
        }
        if (androidModel == null) {
            BuildVariantUpdater.$$$reportNull$$$0(22);
        }
        IdeModifiableModelsProvider modelsProvider = this.myModifiableModelsProviderFactory.create(module.getProject());
        try {
            for (AndroidModuleSetupStep setupStep : this.myAndroidModuleSetupSteps) {
                if (!setupStep.invokeOnBuildVariantChange()) continue;
                setupStep.setUpModule(module, modelsProvider, androidModel, null, null);
            }
            modelsProvider.commit();
        }
        catch (Throwable t) {
            modelsProvider.dispose();
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
        }
        Module module2 = module;
        if (module2 == null) {
            BuildVariantUpdater.$$$reportNull$$$0(23);
        }
        return module2;
    }

    private void setUpModule(@NotNull Module module, @NotNull NdkModuleModel ndkModuleModel) {
        if (module == null) {
            BuildVariantUpdater.$$$reportNull$$$0(24);
        }
        if (ndkModuleModel == null) {
            BuildVariantUpdater.$$$reportNull$$$0(25);
        }
        IdeModifiableModelsProviderImpl modelsProvider = new IdeModifiableModelsProviderImpl(module.getProject());
        try {
            for (NdkModuleSetupStep setupStep : this.myNdkModuleSetupSteps) {
                if (!setupStep.invokeOnBuildVariantChange()) continue;
                setupStep.setUpModule(module, (IdeModifiableModelsProvider)modelsProvider, ndkModuleModel, null, null);
            }
            modelsProvider.commit();
        }
        catch (Throwable t) {
            modelsProvider.dispose();
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
        }
    }

    private void ensureVariantIsSelected(@NotNull Project project, @NotNull String moduleGradlePath, @NotNull String variant, @NotNull List<AndroidFacet> affectedFacets) {
        Module module;
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(26);
        }
        if (moduleGradlePath == null) {
            BuildVariantUpdater.$$$reportNull$$$0(27);
        }
        if (variant == null) {
            BuildVariantUpdater.$$$reportNull$$$0(28);
        }
        if (affectedFacets == null) {
            BuildVariantUpdater.$$$reportNull$$$0(29);
        }
        if ((module = GradleUtil.findModuleByGradlePath(project, moduleGradlePath)) == null) {
            BuildVariantUpdater.logAndShowUpdateFailure(variant, String.format("Cannot find module with Gradle path '%1$s'.", moduleGradlePath));
            return;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            BuildVariantUpdater.logAndShowUpdateFailure(variant, String.format("Cannot find 'Android' facet in module '%1$s'.", module.getName()));
            return;
        }
        AndroidModuleModel androidModel = BuildVariantUpdater.getAndroidModel(facet, variant);
        if (androidModel == null) {
            return;
        }
        if (!this.updateSelectedVariant(facet, androidModel, variant, affectedFacets)) {
            return;
        }
        affectedFacets.add(facet);
    }

    @Nullable
    private static AndroidModuleModel getAndroidModel(@NotNull AndroidFacet facet, @NotNull String variantToSelect) {
        AndroidModuleModel androidModel;
        if (facet == null) {
            BuildVariantUpdater.$$$reportNull$$$0(30);
        }
        if (variantToSelect == null) {
            BuildVariantUpdater.$$$reportNull$$$0(31);
        }
        if ((androidModel = AndroidModuleModel.get(facet)) == null) {
            BuildVariantUpdater.logAndShowUpdateFailure(variantToSelect, String.format("Cannot find AndroidProject for module '%1$s'.", facet.getModule().getName()));
        }
        return androidModel;
    }

    @Nullable
    private static NdkModuleModel getNativeAndroidModel(@NotNull NdkFacet facet, @NotNull String variantToSelect) {
        NdkModuleModel ndkModuleModel;
        if (facet == null) {
            BuildVariantUpdater.$$$reportNull$$$0(32);
        }
        if (variantToSelect == null) {
            BuildVariantUpdater.$$$reportNull$$$0(33);
        }
        if ((ndkModuleModel = NdkModuleModel.get(facet)) == null) {
            BuildVariantUpdater.logAndShowUpdateFailure(variantToSelect, String.format("Cannot find NativeAndroidProject for module '%1$s'.", facet.getModule().getName()));
        }
        return ndkModuleModel;
    }

    private static void logAndShowUpdateFailure(@NotNull String buildVariantName, @NotNull String reason) {
        if (buildVariantName == null) {
            BuildVariantUpdater.$$$reportNull$$$0(34);
        }
        if (reason == null) {
            BuildVariantUpdater.$$$reportNull$$$0(35);
        }
        String prefix = String.format("Unable to select build variant '%1$s':\n", buildVariantName);
        String msg = prefix + reason;
        BuildVariantUpdater.getLog().error(msg);
        msg = msg + ".\n\nConsult IDE log for more details (Help | Show Log)";
        Messages.showErrorDialog((String)msg, (String)"Error");
    }

    @NotNull
    private static Logger getLog() {
        Logger logger = Logger.getInstance(BuildVariantUpdater.class);
        if (logger == null) {
            BuildVariantUpdater.$$$reportNull$$$0(36);
        }
        return logger;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 23: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 23: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiableModelsProviderFactory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModuleSetupSteps";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 19: 
            case 26: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 4: 
            case 34: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildVariantName";
                break;
            }
            case 7: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedAndroidFacets";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedNdkFacets";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidFacet";
                break;
            }
            case 13: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModel";
                break;
            }
            case 14: 
            case 18: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variantToSelect";
                break;
            }
            case 15: 
            case 20: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedFacets";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ndkFacet";
                break;
            }
            case 17: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ndkModuleModel";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 23: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleGradlePath";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "setUpModule";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "updateSelectedVariant";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doUpdate";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findModule";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "generateSourcesIfNeeded";
                break;
            }
            case 21: 
            case 22: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setUpModule";
                break;
            }
            case 23: 
            case 36: {
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "ensureVariantIsSelected";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getAndroidModel";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getNativeAndroidModel";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "logAndShowUpdateFailure";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateSelectedVariant$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 23: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    static class IdeModifiableModelsProviderFactory {
        IdeModifiableModelsProviderFactory() {
        }

        @NotNull
        IdeModifiableModelsProvider create(@NotNull Project project) {
            if (project == null) {
                IdeModifiableModelsProviderFactory.$$$reportNull$$$0(0);
            }
            IdeModifiableModelsProviderImpl ideModifiableModelsProviderImpl = new IdeModifiableModelsProviderImpl(project);
            if (ideModifiableModelsProviderImpl == null) {
                IdeModifiableModelsProviderFactory.$$$reportNull$$$0(1);
            }
            return ideModifiableModelsProviderImpl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater$IdeModifiableModelsProviderFactory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater$IdeModifiableModelsProviderFactory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

