/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.instantapp;

import com.android.instantapp.sdk.InstantAppSdkException;
import com.android.instantapp.sdk.Metadata;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.instantapp.InstantApps;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstantAppSdks {
    @NotNull
    private static final String INSTANT_APP_SDK_PATH = "extras;google;instantapps";

    @NotNull
    public static InstantAppSdks getInstance() {
        InstantAppSdks instantAppSdks = (InstantAppSdks)ServiceManager.getService(InstantAppSdks.class);
        if (instantAppSdks == null) {
            InstantAppSdks.$$$reportNull$$$0(0);
        }
        return instantAppSdks;
    }

    @Nullable
    public File getInstantAppSdk(boolean tryToInstall) {
        LocalPackage localPackage = InstantAppSdks.getInstantAppLocalPackage();
        if (localPackage == null && tryToInstall) {
            InstantAppSdks.installSdkIfNeeded();
            localPackage = InstantAppSdks.getInstantAppLocalPackage();
        }
        return localPackage == null ? null : localPackage.getLocation();
    }

    @Nullable
    private static LocalPackage getInstantAppLocalPackage() {
        AndroidSdkHandler androidSdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        return androidSdkHandler.getLocalPackage(INSTANT_APP_SDK_PATH, (ProgressIndicator)new StudioLoggerProgressIndicator(InstantAppSdks.class));
    }

    private static void installSdkIfNeeded() {
        ApplicationManager.getApplication().invokeAndWait(() -> {
            ModelWizardDialog dialog;
            int result = Messages.showYesNoDialog((String)"Required Instant App SDK components not installed. Do you want to install it now?", (String)"Instant Apps", null);
            if (result == 0 && (dialog = SdkQuickfixUtils.createDialogForPaths(null, (Collection<String>)ImmutableList.of((Object)INSTANT_APP_SDK_PATH))) != null) {
                dialog.show();
            }
        });
    }

    public boolean isInstantAppSdkEnabled() {
        return true;
    }

    public int getMinTargetSdk() {
        try {
            File iappSdk = this.getInstantAppSdk(false);
            if (iappSdk != null) {
                return Metadata.getInstance((File)iappSdk).getMinApiLevelSupported();
            }
        }
        catch (InstantAppSdkException ex) {
            InstantAppSdks.getLogger().error((Throwable)ex);
        }
        return 23;
    }

    public long getCompatApiMinVersion() {
        try {
            File iappSdk = this.getInstantAppSdk(false);
            if (iappSdk != null) {
                return Metadata.getInstance((File)iappSdk).getAiaCompatApiMinVersion();
            }
        }
        catch (InstantAppSdkException ex) {
            InstantAppSdks.getLogger().error((Throwable)ex);
        }
        return 1L;
    }

    private static Logger getLogger() {
        return Logger.getInstance(InstantApps.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/instantapp/InstantAppSdks", "getInstance"));
    }
}

