/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lang.databinding.model;

import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.reflection.ModelField;
import android.databinding.tool.reflection.ModelMethod;
import com.android.tools.idea.lang.databinding.model.PsiModelField;
import com.android.tools.idea.lang.databinding.model.PsiModelMethod;
import com.google.common.collect.Lists;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PsiModelClass
extends ModelClass {
    private static final ModelField[] EMPTY_MODEL_FIELD_ARRAY = new ModelField[0];
    private static final ModelMethod[] EMPTY_MODEL_METHOD_ARRAY = new ModelMethod[0];
    @NotNull
    PsiType myType;
    ModelClass myComponentType;

    public PsiModelClass(@NotNull PsiType psiClassType) {
        if (psiClassType == null) {
            PsiModelClass.$$$reportNull$$$0(0);
        }
        this.myType = psiClassType;
    }

    public PsiClass getPsiClass() {
        if (this.myType instanceof PsiClassType) {
            return ((PsiClassType)this.myType).resolve();
        }
        return null;
    }

    public String toJavaCode() {
        throw new UnsupportedOperationException("why generate");
    }

    public boolean isArray() {
        return this.myType instanceof PsiArrayType;
    }

    public ModelClass getComponentType() {
        if (this.myComponentType == null && this.isArray()) {
            this.myComponentType = new PsiModelClass(((PsiArrayType)this.myType).getComponentType());
        }
        return this.myComponentType;
    }

    public boolean isNullable() {
        return !this.isPrimitive();
    }

    public boolean isPrimitive() {
        String canonicalText = this.myType.getCanonicalText(false);
        String boxed = PsiTypesUtil.boxIfPossible((String)canonicalText);
        return boxed != null && !boxed.equals(canonicalText);
    }

    public boolean isBoolean() {
        return PsiType.BOOLEAN.equalsToText(this.myType.getCanonicalText());
    }

    public boolean isChar() {
        return PsiType.CHAR.equalsToText(this.myType.getCanonicalText());
    }

    public boolean isByte() {
        return PsiType.BYTE.equalsToText(this.myType.getCanonicalText());
    }

    public boolean isShort() {
        return PsiType.SHORT.equalsToText(this.myType.getCanonicalText());
    }

    public boolean isInt() {
        return PsiType.INT.equalsToText(this.myType.getCanonicalText());
    }

    public boolean isLong() {
        return PsiType.LONG.equalsToText(this.myType.getCanonicalText());
    }

    public boolean isFloat() {
        return PsiType.FLOAT.equalsToText(this.myType.getCanonicalText());
    }

    public boolean isDouble() {
        return PsiType.DOUBLE.equalsToText(this.myType.getCanonicalText());
    }

    public boolean isGeneric() {
        return this.myType instanceof PsiClassType && ((PsiClassType)this.myType).hasParameters();
    }

    public List<ModelClass> getTypeArguments() {
        if (this.myType instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)this.myType;
            PsiType[] typeParameters = classType.getParameters();
            ArrayList result = Lists.newArrayListWithCapacity((int)typeParameters.length);
            for (PsiType typeParameter : typeParameters) {
                result.add(new PsiModelClass(typeParameter));
            }
            return result;
        }
        return Lists.newArrayList();
    }

    public boolean isTypeVar() {
        return false;
    }

    public boolean isInterface() {
        if (this.myType instanceof PsiClassType) {
            PsiClassType psiClassType = (PsiClassType)this.myType;
            PsiClass resolved = psiClassType.resolve();
            return resolved != null && resolved.isInterface();
        }
        return false;
    }

    public boolean isVoid() {
        return PsiType.VOID.equalsToText(this.myType.getCanonicalText());
    }

    public ModelClass unbox() {
        return this;
    }

    public ModelClass box() {
        return this;
    }

    public boolean isAssignableFrom(ModelClass modelClass) {
        return modelClass instanceof PsiModelClass && this.myType.isAssignableFrom(((PsiModelClass)modelClass).myType);
    }

    public ModelClass getSuperclass() {
        PsiType[] supers = this.myType.getSuperTypes();
        if (supers.length == 0) {
            return null;
        }
        PsiType superClass = supers[0];
        if (superClass == null) {
            return null;
        }
        return new PsiModelClass(superClass);
    }

    public ModelClass erasure() {
        return this;
    }

    public String getJniDescription() {
        return this.getCanonicalName();
    }

    public ModelField[] getDeclaredFields() {
        if (this.myType instanceof PsiClassType) {
            PsiClassType myPsiClassType = (PsiClassType)this.myType;
            PsiClass resolved = myPsiClassType.resolve();
            if (resolved == null) {
                return EMPTY_MODEL_FIELD_ARRAY;
            }
            PsiField[] fields = resolved.getFields();
            ModelField[] result = new ModelField[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                result[i] = new PsiModelField(fields[i]);
            }
            return result;
        }
        return EMPTY_MODEL_FIELD_ARRAY;
    }

    public ModelMethod[] getDeclaredMethods() {
        if (this.myType instanceof PsiClassType) {
            PsiClassType myPsiClassType = (PsiClassType)this.myType;
            PsiClass resolved = myPsiClassType.resolve();
            if (resolved == null) {
                return EMPTY_MODEL_METHOD_ARRAY;
            }
            PsiMethod[] fields = resolved.getMethods();
            ModelMethod[] result = new ModelMethod[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                result[i] = new PsiModelMethod(fields[i]);
            }
            return result;
        }
        return EMPTY_MODEL_METHOD_ARRAY;
    }

    public boolean isWildcard() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClassType", "com/android/tools/idea/lang/databinding/model/PsiModelClass", "<init>"));
    }
}

