/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.idea.lint.DefaultLintQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AddUsesFeatureQuickFix
extends DefaultLintQuickFix {
    private final String myFeatureName;

    public AddUsesFeatureQuickFix(@NotNull String featureName) {
        if (featureName == null) {
            AddUsesFeatureQuickFix.$$$reportNull$$$0(0);
        }
        super("Add uses-feature tag");
        this.myFeatureName = featureName;
    }

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        XmlTag parent;
        if (startElement == null) {
            AddUsesFeatureQuickFix.$$$reportNull$$$0(1);
        }
        if (endElement == null) {
            AddUsesFeatureQuickFix.$$$reportNull$$$0(2);
        }
        if (context == null) {
            AddUsesFeatureQuickFix.$$$reportNull$$$0(3);
        }
        if ((parent = (XmlTag)PsiTreeUtil.getTopmostParentOfType((PsiElement)startElement, XmlTag.class)) == null || !"manifest".equals(parent.getName())) {
            return;
        }
        XmlTag usesFeatureTag = parent.createChildTag("uses-feature", null, null, false);
        XmlTag ancestor = AddUsesFeatureQuickFix.findLocationForUsesFeature(parent);
        usesFeatureTag = ancestor != null ? (XmlTag)parent.addAfter((PsiElement)usesFeatureTag, (PsiElement)ancestor) : parent.addSubTag(usesFeatureTag, true);
        if (usesFeatureTag != null) {
            usesFeatureTag.setAttribute("name", "http://schemas.android.com/apk/res/android", this.myFeatureName);
            usesFeatureTag.setAttribute("required", "http://schemas.android.com/apk/res/android", "false");
        }
    }

    @Nullable
    private static XmlTag findLocationForUsesFeature(XmlTag parent) {
        String[] reverseOrderManifestElements;
        for (String elementName : reverseOrderManifestElements = new String[]{"uses-feature", "uses-configuration", "uses-sdk", "permission"}) {
            XmlTag[] existingTags = parent.findSubTags(elementName);
            int len = existingTags.length;
            if (len <= 0) continue;
            return existingTags[len - 1];
        }
        return null;
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        XmlTag xmlTag;
        if (startElement == null) {
            AddUsesFeatureQuickFix.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            AddUsesFeatureQuickFix.$$$reportNull$$$0(5);
        }
        if (contextType == null) {
            AddUsesFeatureQuickFix.$$$reportNull$$$0(6);
        }
        return (xmlTag = (XmlTag)PsiTreeUtil.getTopmostParentOfType((PsiElement)startElement, XmlTag.class)) != null && "manifest".equals(xmlTag.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureName";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextType";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/lint/AddUsesFeatureQuickFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

