/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import java.awt.Graphics2D;

public class PrimitiveShapesHelper {
    private static final int STROKE_WIDTH = 1;
    private final Graphics2D out;
    private final float scaleFactor;

    public PrimitiveShapesHelper(Graphics2D out, float scaleFactor) {
        this.out = out;
        this.scaleFactor = scaleFactor;
    }

    public void drawRect(int x, int y, int width, int height) {
        this.out.drawRect(this.scaleX(x), this.scaleY(y), this.scaleWidth(x, width), this.scaleHeight(y, height));
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.out.drawRoundRect(this.scaleX(x), this.scaleY(y), this.scaleWidth(x, width), this.scaleHeight(y, height), this.scale(arcWidth), this.scale(arcHeight));
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.out.drawLine(this.scaleX(x1, x1, x2), this.scaleY(y1, y1, y2), this.scaleX(x2, x1, x2), this.scaleY(y2, y1, y2));
    }

    public void drawOval(int x, int y, int width, int height) {
        this.out.drawOval(this.scaleX(x), this.scaleY(y), this.scaleWidth(x, width), this.scaleHeight(y, height));
    }

    public void drawCenteredCircle(int xCenter, int yCenter, int radius) {
        this.drawOval(xCenter - radius, yCenter - radius, radius * 2, radius * 2);
    }

    public int scale(int value) {
        return Math.round((float)value * this.scaleFactor);
    }

    public int scaleWidth(int x, int width) {
        int scaled = Math.round((float)width * this.scaleFactor);
        return scaled - 1;
    }

    public int scaleHeight(int y, int height) {
        int scaled = Math.round((float)height * this.scaleFactor);
        return scaled - 1;
    }

    public int scaleX(int x) {
        return this.scale(x);
    }

    public int scaleX(int x, int x1, int x2) {
        int scaled = this.scale(x);
        int max = Math.max(x1, x2);
        if (x == max) {
            return scaled - 1;
        }
        return scaled;
    }

    public int scaleY(int y) {
        return this.scale(y);
    }

    public int scaleY(int y, int y1, int y2) {
        int scaled = this.scale(y);
        int max = Math.max(y1, y2);
        if (y == max) {
            return scaled - 1;
        }
        return scaled;
    }
}

