/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.icon;

import com.android.tools.idea.npw.assetstudio.GeneratedIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedImageIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedXmlResource;
import com.android.tools.idea.npw.assetstudio.GraphicGenerator;
import com.android.tools.idea.npw.assetstudio.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.IconCategory;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.icon.CategoryIconMap;
import com.android.tools.idea.npw.assetstudio.icon.IconGeneratorResult;
import com.android.tools.idea.npw.project.AndroidProjectPaths;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.NotNull;

public abstract class AndroidIconGenerator
implements Disposable {
    private final OptionalProperty<BaseAsset> mySourceAsset;
    private final StringProperty myName;
    private final int myMinSdkVersion;
    @NotNull
    private final GraphicGeneratorContext myContext;
    @NotNull
    private final GraphicGenerator myGraphicGenerator;

    public AndroidIconGenerator(int minSdkVersion, @NotNull GraphicGenerator graphicGenerator) {
        if (graphicGenerator == null) {
            AndroidIconGenerator.$$$reportNull$$$0(0);
        }
        this(minSdkVersion, graphicGenerator, new GraphicGeneratorContext(40));
    }

    public AndroidIconGenerator(int minSdkVersion, @NotNull GraphicGenerator graphicGenerator, @NotNull GraphicGeneratorContext context) {
        if (graphicGenerator == null) {
            AndroidIconGenerator.$$$reportNull$$$0(1);
        }
        if (context == null) {
            AndroidIconGenerator.$$$reportNull$$$0(2);
        }
        this.mySourceAsset = new OptionalValueProperty<BaseAsset>();
        this.myName = new StringValueProperty();
        this.myMinSdkVersion = minSdkVersion;
        this.myContext = context;
        this.myGraphicGenerator = graphicGenerator;
    }

    public void dispose() {
        this.myContext.dispose();
    }

    @NotNull
    public GraphicGeneratorContext getGraphicGeneratorContext() {
        GraphicGeneratorContext graphicGeneratorContext = this.myContext;
        if (graphicGeneratorContext == null) {
            AndroidIconGenerator.$$$reportNull$$$0(3);
        }
        return graphicGeneratorContext;
    }

    @NotNull
    private static Logger getLog() {
        Logger logger = Logger.getInstance(AndroidIconGenerator.class);
        if (logger == null) {
            AndroidIconGenerator.$$$reportNull$$$0(4);
        }
        return logger;
    }

    @NotNull
    private static Map<String, Map<String, BufferedImage>> newAssetMap() {
        HashMap<String, Map<String, BufferedImage>> hashMap = new HashMap<String, Map<String, BufferedImage>>();
        if (hashMap == null) {
            AndroidIconGenerator.$$$reportNull$$$0(5);
        }
        return hashMap;
    }

    @NotNull
    public final OptionalProperty<BaseAsset> sourceAsset() {
        OptionalProperty<BaseAsset> optionalProperty = this.mySourceAsset;
        if (optionalProperty == null) {
            AndroidIconGenerator.$$$reportNull$$$0(6);
        }
        return optionalProperty;
    }

    @NotNull
    public final StringProperty name() {
        StringProperty stringProperty = this.myName;
        if (stringProperty == null) {
            AndroidIconGenerator.$$$reportNull$$$0(7);
        }
        return stringProperty;
    }

    public int getMinSdkVersion() {
        return this.myMinSdkVersion;
    }

    @NotNull
    public IconGeneratorResult generateIcons(GraphicGenerator.Options options) {
        IconGeneratorResult iconGeneratorResult = new IconGeneratorResult(this.myGraphicGenerator.generateIcons(this.myContext, options, (String)this.myName.get()), options);
        if (iconGeneratorResult == null) {
            AndroidIconGenerator.$$$reportNull$$$0(8);
        }
        return iconGeneratorResult;
    }

    @NotNull
    public final CategoryIconMap generateIntoMemory() {
        if (!((Optional)this.mySourceAsset.get()).isPresent()) {
            throw new IllegalStateException("Can't generate icons without a source asset set first");
        }
        GraphicGenerator.Options options = this.createOptions(false);
        CategoryIconMap categoryIconMap = this.generateIntoMemory(options);
        if (categoryIconMap == null) {
            AndroidIconGenerator.$$$reportNull$$$0(9);
        }
        return categoryIconMap;
    }

    @NotNull
    private CategoryIconMap generateIntoMemory(GraphicGenerator.Options options) {
        Map<String, Map<String, BufferedImage>> categoryMap = AndroidIconGenerator.newAssetMap();
        this.myGraphicGenerator.generate(null, categoryMap, this.myContext, options, (String)this.myName.get());
        CategoryIconMap categoryIconMap = new CategoryIconMap(categoryMap);
        if (categoryIconMap == null) {
            AndroidIconGenerator.$$$reportNull$$$0(10);
        }
        return categoryIconMap;
    }

    @NotNull
    public final Map<File, BufferedImage> generateIntoFileMap(@NotNull AndroidProjectPaths paths) {
        if (paths == null) {
            AndroidIconGenerator.$$$reportNull$$$0(11);
        }
        if (((String)this.myName.get()).isEmpty()) {
            throw new IllegalStateException("Can't save icons to disk if a filename isn't set first");
        }
        File resDirectory = paths.getResDirectory();
        if (resDirectory == null || resDirectory.getParentFile() == null) {
            throw new IllegalArgumentException("Invalid paths used when trying to generate an icon");
        }
        CategoryIconMap categoryIconMap = this.generateIntoMemory();
        Map<File, BufferedImage> map = categoryIconMap.toFileMap(resDirectory.getParentFile());
        if (map == null) {
            AndroidIconGenerator.$$$reportNull$$$0(12);
        }
        return map;
    }

    @NotNull
    public final Map<File, GeneratedIcon> generateIntoIconMap(@NotNull AndroidProjectPaths paths) {
        if (paths == null) {
            AndroidIconGenerator.$$$reportNull$$$0(13);
        }
        GraphicGenerator.Options options = this.createOptions(false);
        Map<File, GeneratedIcon> map = this.generateIntoIconMap(paths, options);
        if (map == null) {
            AndroidIconGenerator.$$$reportNull$$$0(14);
        }
        return map;
    }

    @NotNull
    public final Map<File, GeneratedIcon> generateIconPlaceholders(@NotNull AndroidProjectPaths paths) {
        if (paths == null) {
            AndroidIconGenerator.$$$reportNull$$$0(15);
        }
        GraphicGenerator.Options options = this.createOptions(false);
        options.usePlaceholders = true;
        Map<File, GeneratedIcon> map = this.generateIntoIconMap(paths, options);
        if (map == null) {
            AndroidIconGenerator.$$$reportNull$$$0(16);
        }
        return map;
    }

    @NotNull
    public final Map<File, GeneratedIcon> generateIntoIconMap(@NotNull AndroidProjectPaths paths, GraphicGenerator.Options options) {
        if (paths == null) {
            AndroidIconGenerator.$$$reportNull$$$0(17);
        }
        if (((String)this.myName.get()).isEmpty()) {
            throw new IllegalStateException("Can't save icons to disk if a filename isn't set first");
        }
        File resDirectory = paths.getResDirectory();
        if (resDirectory == null || resDirectory.getParentFile() == null) {
            throw new IllegalArgumentException("Invalid paths used when trying to generate an icon");
        }
        IconGeneratorResult icons = this.generateIcons(options);
        HashMap<File, GeneratedIcon> outputMap = new HashMap<File, GeneratedIcon>();
        icons.getIcons().getList().forEach(icon -> {
            if (icon.getOutputPath() != null && icon.getCategory() != IconCategory.PREVIEW) {
                File path = new File(resDirectory.getParentFile(), icon.getOutputPath().toString());
                outputMap.put(path, (GeneratedIcon)icon);
            }
        });
        HashMap<File, GeneratedIcon> hashMap = outputMap;
        if (hashMap == null) {
            AndroidIconGenerator.$$$reportNull$$$0(18);
        }
        return hashMap;
    }

    public final void generateImageIconsIntoPath(@NotNull AndroidProjectPaths paths) {
        if (paths == null) {
            AndroidIconGenerator.$$$reportNull$$$0(19);
        }
        Map<File, GeneratedIcon> pathIconMap = this.generateIntoIconMap(paths);
        ApplicationManager.getApplication().runWriteAction(() -> {
            for (Map.Entry fileImageEntry : pathIconMap.entrySet()) {
                File file = (File)fileImageEntry.getKey();
                GeneratedIcon icon = (GeneratedIcon)fileImageEntry.getValue();
                if (icon instanceof GeneratedImageIcon) {
                    if (FileUtilRt.extensionEquals((String)file.getName(), (String)"png")) {
                        this.writePngToDisk(file, ((GeneratedImageIcon)icon).getImage());
                        continue;
                    }
                    AndroidIconGenerator.getLog().error("Please report this error. Unable to create icon for invalid file: " + file.getAbsolutePath());
                    continue;
                }
                if (icon instanceof GeneratedXmlResource) {
                    if (FileUtilRt.extensionEquals((String)file.getName(), (String)"xml")) {
                        this.writeTextToDisk(file, ((GeneratedXmlResource)icon).getXmlText());
                        continue;
                    }
                    AndroidIconGenerator.getLog().error("Please report this error. Unable to create icon for invalid file: " + file.getAbsolutePath());
                    continue;
                }
                AndroidIconGenerator.getLog().error("Please report this error. Unable to create icon for invalid file: " + file.getAbsolutePath());
            }
        });
    }

    @NotNull
    public abstract GraphicGenerator.Options createOptions(boolean var1);

    private void writePngToDisk(@NotNull File file, @NotNull BufferedImage image) {
        if (file == null) {
            AndroidIconGenerator.$$$reportNull$$$0(20);
        }
        if (image == null) {
            AndroidIconGenerator.$$$reportNull$$$0(21);
        }
        try {
            VirtualFile directory = VfsUtil.createDirectories((String)file.getParentFile().getAbsolutePath());
            VirtualFile imageFile = directory.findChild(file.getName());
            if (imageFile == null || !imageFile.exists()) {
                imageFile = directory.createChildData((Object)this, file.getName());
            }
            try (OutputStream outputStream = imageFile.getOutputStream((Object)this);){
                ImageIO.write((RenderedImage)image, "PNG", outputStream);
            }
        }
        catch (IOException e) {
            AndroidIconGenerator.getLog().error((Throwable)e);
        }
    }

    private void writeTextToDisk(@NotNull File file, @NotNull String text) {
        if (file == null) {
            AndroidIconGenerator.$$$reportNull$$$0(22);
        }
        if (text == null) {
            AndroidIconGenerator.$$$reportNull$$$0(23);
        }
        try {
            VirtualFile directory = VfsUtil.createDirectories((String)file.getParentFile().getAbsolutePath());
            VirtualFile imageFile = directory.findChild(file.getName());
            if (imageFile == null || !imageFile.exists()) {
                imageFile = directory.createChildData((Object)this, file.getName());
            }
            try (OutputStream outputStream = imageFile.getOutputStream((Object)this);){
                byte[] bytes = text.getBytes(StandardCharsets.UTF_8);
                outputStream.write(bytes);
            }
        }
        catch (IOException e) {
            AndroidIconGenerator.getLog().error((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphicGenerator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/icon/AndroidIconGenerator";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/icon/AndroidIconGenerator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphicGeneratorContext";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "newAssetMap";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "sourceAsset";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "name";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "generateIcons";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "generateIntoMemory";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "generateIntoFileMap";
                break;
            }
            case 14: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "generateIntoIconMap";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "generateIconPlaceholders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "generateIntoFileMap";
                break;
            }
            case 13: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "generateIntoIconMap";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "generateIconPlaceholders";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "generateImageIconsIntoPath";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "writePngToDisk";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "writeTextToDisk";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

