/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.template;

import com.android.builder.model.SourceProvider;
import com.android.tools.adtui.LabelWithEditButton;
import com.android.tools.adtui.TooltipLabel;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.npw.assetstudio.icon.AndroidIconType;
import com.android.tools.idea.npw.platform.Language;
import com.android.tools.idea.npw.project.AndroidPackageUtils;
import com.android.tools.idea.npw.project.AndroidProjectPaths;
import com.android.tools.idea.npw.project.AndroidSourceSet;
import com.android.tools.idea.npw.project.NewProjectModel;
import com.android.tools.idea.npw.template.GenerateIconsStep;
import com.android.tools.idea.npw.template.IconLoader;
import com.android.tools.idea.npw.template.RenderTemplateModel;
import com.android.tools.idea.npw.template.TemplateHandle;
import com.android.tools.idea.npw.template.TemplateValueInjector;
import com.android.tools.idea.npw.template.components.ActivityComboProvider;
import com.android.tools.idea.npw.template.components.CheckboxProvider;
import com.android.tools.idea.npw.template.components.ComponentProvider;
import com.android.tools.idea.npw.template.components.EnumComboProvider;
import com.android.tools.idea.npw.template.components.LabelWithEditButtonProvider;
import com.android.tools.idea.npw.template.components.LanguageComboProvider;
import com.android.tools.idea.npw.template.components.PackageComboProvider;
import com.android.tools.idea.npw.template.components.ParameterComponentProvider;
import com.android.tools.idea.npw.template.components.SeparatorProvider;
import com.android.tools.idea.npw.template.components.SourceSetComboProvider;
import com.android.tools.idea.npw.template.components.TextFieldProvider;
import com.android.tools.idea.observable.AbstractProperty;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.adapters.OptionalToValuePropertyAdapter;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.observable.expressions.Expression;
import com.android.tools.idea.observable.ui.IconProperty;
import com.android.tools.idea.observable.ui.SelectedItemProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.observable.ui.VisibleProperty;
import com.android.tools.idea.templates.CircularParameterDependencyException;
import com.android.tools.idea.templates.Parameter;
import com.android.tools.idea.templates.ParameterValueResolver;
import com.android.tools.idea.templates.StringEvaluator;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.ui.wizard.StudioWizardStepPanel;
import com.android.tools.idea.ui.wizard.WizardUtils;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ReferenceEditorComboWithBrowseButton;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfigureTemplateParametersStep
extends ModelWizardStep<RenderTemplateModel> {
    private final List<AndroidSourceSet> mySourceSets;
    private final StringProperty myPackageName;
    private final BindingsManager myBindings;
    private final LoadingCache<File, Optional<Icon>> myThumbnailsCache;
    private final Map<Parameter, RowEntry> myParameterRows;
    private final Map<Parameter, Object> myUserValues;
    private final StringEvaluator myEvaluator;
    private final StringProperty myThumbPath;
    private final StudioWizardStepPanel myStudioPanel;
    @Nullable
    private final AndroidFacet myFacet;
    private final StringProperty myInvalidParameterMessage;
    private final ValidatorPanel myValidatorPanel;
    private JPanel myRootPanel;
    private JLabel myTemplateThumbLabel;
    private JPanel myParametersPanel;
    private JSeparator myFooterSeparator;
    private TooltipLabel myParameterDescriptionLabel;
    private JBScrollPane myParametersScrollPane;
    private JLabel myTemplateDescriptionLabel;
    private EvaluationState myEvaluationState;

    public ConfigureTemplateParametersStep(@NotNull RenderTemplateModel model, @NotNull String title, @NotNull List<AndroidSourceSet> sourceSets, @Nullable AndroidFacet facet) {
        if (model == null) {
            ConfigureTemplateParametersStep.$$$reportNull$$$0(0);
        }
        if (title == null) {
            ConfigureTemplateParametersStep.$$$reportNull$$$0(1);
        }
        if (sourceSets == null) {
            ConfigureTemplateParametersStep.$$$reportNull$$$0(2);
        }
        super(model, title);
        this.$$$setupUI$$$();
        this.myBindings = new BindingsManager();
        this.myThumbnailsCache = IconLoader.createLoadingCache();
        this.myParameterRows = Maps.newHashMap();
        this.myUserValues = Maps.newHashMap();
        this.myEvaluator = new StringEvaluator();
        this.myThumbPath = new StringValueProperty();
        this.myInvalidParameterMessage = new StringValueProperty();
        this.myEvaluationState = EvaluationState.NOT_EVALUATING;
        this.myFacet = facet;
        this.mySourceSets = sourceSets;
        this.myPackageName = model.packageName();
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)this.myRootPanel);
        this.myStudioPanel = new StudioWizardStepPanel((JPanel)this.myValidatorPanel);
        this.myParameterDescriptionLabel.setScope((Container)this.myParametersPanel);
        this.myParametersScrollPane.setBorder(IdeBorderFactory.createEmptyBorder());
        this.myTemplateDescriptionLabel.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)0, (int)this.myTemplateDescriptionLabel.getFont().getSize(), (int)0));
    }

    private static Logger getLog() {
        return Logger.getInstance(ConfigureTemplateParametersStep.class);
    }

    @NotNull
    private static String getRecentsKeyForParameter(@NotNull Parameter parameter) {
        if (parameter == null) {
            ConfigureTemplateParametersStep.$$$reportNull$$$0(3);
        }
        String string = "android.template." + parameter.id;
        if (string == null) {
            ConfigureTemplateParametersStep.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    protected Collection<? extends ModelWizardStep> createDependentSteps() {
        TemplateHandle template = ((RenderTemplateModel)this.getModel()).getTemplateHandle();
        if (template != null && template.getMetadata().getIconType() == AndroidIconType.NOTIFICATION) {
            assert (this.myFacet != null);
            int minSdkVersion = AndroidModuleInfo.getInstance(this.myFacet).getMinSdkVersion().getApiLevel();
            List<GenerateIconsStep> list = Collections.singletonList(new GenerateIconsStep((RenderTemplateModel)this.getModel(), minSdkVersion));
            if (list == null) {
                ConfigureTemplateParametersStep.$$$reportNull$$$0(5);
            }
            return list;
        }
        Collection<ModelWizardStep> collection = super.createDependentSteps();
        if (collection == null) {
            ConfigureTemplateParametersStep.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @Override
    protected boolean shouldShow() {
        return ((RenderTemplateModel)this.getModel()).getTemplateHandle() != null;
    }

    @Override
    protected void onEntering() {
        RowEntry<JComboBox> row;
        this.resetPanel();
        final TemplateHandle templateHandle = ((RenderTemplateModel)this.getModel()).getTemplateHandle();
        TemplateMetadata templateMetadata = templateHandle.getMetadata();
        ApplicationManager.getApplication().invokeLater(() -> this.myTemplateDescriptionLabel.setText(WizardUtils.toHtmlString(Strings.nullToEmpty((String)templateMetadata.getDescription()))), ModalityState.any());
        if (templateMetadata.getFormFactor() != null) {
            this.setIcon(FormFactor.get(templateMetadata.getFormFactor()).getIcon());
        }
        final IconProperty thumb = new IconProperty(this.myTemplateThumbLabel);
        VisibleProperty thumbVisibility = new VisibleProperty(this.myTemplateThumbLabel);
        this.myBindings.bind(thumb, new Expression<Optional<Icon>>(new ObservableValue[]{this.myThumbPath}){

            @Override
            @NotNull
            public Optional<Icon> get() {
                Optional optional = (Optional)ConfigureTemplateParametersStep.this.myThumbnailsCache.getUnchecked((Object)new File(templateHandle.getRootPath(), (String)ConfigureTemplateParametersStep.this.myThumbPath.get()));
                if (optional == null) {
                    1.$$$reportNull$$$0(0);
                }
                return optional;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/template/ConfigureTemplateParametersStep$1", "get"));
            }
        });
        this.myBindings.bind(thumbVisibility, new Expression<Boolean>(new ObservableValue[]{thumb}){

            @Override
            @NotNull
            public Boolean get() {
                Boolean bl = ((Optional)thumb.get()).isPresent();
                if (bl == null) {
                    2.$$$reportNull$$$0(0);
                }
                return bl;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/template/ConfigureTemplateParametersStep$2", "get"));
            }
        });
        this.myThumbPath.set(this.getDefaultThumbnailPath());
        final TextProperty parameterDescription = new TextProperty((JLabel)this.myParameterDescriptionLabel);
        this.myBindings.bind(new VisibleProperty(this.myFooterSeparator), new Expression<Boolean>(new ObservableValue[]{parameterDescription}){

            @Override
            @NotNull
            public Boolean get() {
                Boolean bl = !parameterDescription.get().isEmpty();
                if (bl == null) {
                    3.$$$reportNull$$$0(0);
                }
                return bl;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/template/ConfigureTemplateParametersStep$3", "get"));
            }
        });
        Module module = this.myFacet == null ? null : this.myFacet.getModule();
        for (final Parameter parameter : templateMetadata.getParameters()) {
            RowEntry<?> row2 = this.createRowForParameter(module, parameter);
            ObservableValue<?> property = row2.getProperty();
            if (property != null) {
                property.addListener(sender -> {
                    if (this.myEvaluationState != EvaluationState.EVALUATING) {
                        this.myUserValues.put(parameter, property.get());
                        this.enqueueEvaluateParameters();
                    }
                });
                final ActionGroup resetParameterGroup = new ActionGroup(){

                    @NotNull
                    public AnAction[] getChildren(@Nullable AnActionEvent e) {
                        AnAction[] anActionArray = new AnAction[]{new ResetParameterAction(parameter)};
                        if (anActionArray == null) {
                            4.$$$reportNull$$$0(0);
                        }
                        return anActionArray;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/template/ConfigureTemplateParametersStep$4", "getChildren"));
                    }
                };
                row2.getComponent().addMouseListener((MouseListener)new PopupHandler(){

                    public void invokePopup(Component comp, int x, int y) {
                        ActionManager.getInstance().createActionPopupMenu("unknown", resetParameterGroup).getComponent().show(comp, x, y);
                    }
                });
            }
            this.myParameterRows.put(parameter, row2);
            row2.addToPanel(this.myParametersPanel);
        }
        if (this.displayLanguageChoice(templateMetadata)) {
            row = new RowEntry<JComboBox>("Source Language", new LanguageComboProvider());
            row.addToPanel(this.myParametersPanel);
            SelectedItemProperty language = (SelectedItemProperty)row.getProperty();
            assert (language != null);
            this.myBindings.bindTwoWay(new OptionalToValuePropertyAdapter(language), ((RenderTemplateModel)this.getModel()).getLanguage());
        }
        if (this.mySourceSets.size() > 1) {
            row = new RowEntry<JComboBox>("Target Source Set", new SourceSetComboProvider(this.mySourceSets));
            row.setEnabled(this.mySourceSets.size() > 1);
            row.addToPanel(this.myParametersPanel);
            SelectedItemProperty sourceSet = (SelectedItemProperty)row.getProperty();
            assert (sourceSet != null);
            this.myBindings.bind(((RenderTemplateModel)this.getModel()).getSourceSet(), new OptionalToValuePropertyAdapter(sourceSet));
            sourceSet.addListener(sender -> this.enqueueEvaluateParameters());
        }
        this.myValidatorPanel.registerMessageSource((ObservableValue)this.myInvalidParameterMessage);
        this.evaluateParameters();
    }

    private boolean displayLanguageChoice(TemplateMetadata templateMetadata) {
        if (!StudioFlags.NPW_KOTLIN.get().booleanValue()) {
            return false;
        }
        if (((RenderTemplateModel)this.getModel()).getProject().getValueOrNull() == null) {
            return false;
        }
        return templateMetadata.getFormFactor() != null || templateMetadata.getParameter("className") != null || templateMetadata.getParameter("packageName") != null;
    }

    private RowEntry<?> createRowForParameter(@Nullable Module module, @NotNull Parameter parameter) {
        if (parameter == null) {
            ConfigureTemplateParametersStep.$$$reportNull$$$0(7);
        }
        if ("packageName".equals(parameter.id)) {
            assert (parameter.name != null);
            RowEntry<Object> rowEntry = module != null ? new RowEntry<EditorComboBox>(parameter.name, new PackageComboProvider(module.getProject(), parameter, (String)this.myPackageName.get(), ConfigureTemplateParametersStep.getRecentsKeyForParameter(parameter))) : new RowEntry<LabelWithEditButton>(parameter.name, new LabelWithEditButtonProvider(parameter));
            StringProperty packageName = (StringProperty)rowEntry.getProperty();
            assert (packageName != null);
            this.myBindings.bindTwoWay(packageName, this.myPackageName);
            return rowEntry;
        }
        if ("parentActivityClass".equals(parameter.id) && module != null) {
            assert (parameter.name != null);
            return new RowEntry<ReferenceEditorComboWithBrowseButton>(parameter.name, new ActivityComboProvider(module, parameter, ConfigureTemplateParametersStep.getRecentsKeyForParameter(parameter)));
        }
        switch (parameter.type) {
            case STRING: {
                assert (parameter.name != null);
                return new RowEntry<JTextField>(parameter.name, new TextFieldProvider(parameter));
            }
            case BOOLEAN: {
                return new RowEntry<JCheckBox>(new CheckboxProvider(parameter));
            }
            case SEPARATOR: {
                return new RowEntry<JSeparator>(new SeparatorProvider(parameter));
            }
            case ENUM: {
                assert (parameter.name != null);
                return new RowEntry<JComboBox>(parameter.name, new EnumComboProvider(parameter));
            }
        }
        throw new IllegalStateException(String.format("Can't create UI for unknown component type: %1$s (%2$s)", new Object[]{parameter.type, parameter.id}));
    }

    private void enqueueEvaluateParameters() {
        if (this.myEvaluationState == EvaluationState.REQUEST_ENQUEUED) {
            return;
        }
        this.myEvaluationState = EvaluationState.REQUEST_ENQUEUED;
        ApplicationManager.getApplication().invokeLater(this::evaluateParameters, ModalityState.any());
    }

    private boolean isNewModule() {
        return this.myFacet == null;
    }

    private boolean isParameterVisible(Parameter parameter) {
        return !this.isNewModule() || !"packageName".equals(parameter.id) && !"isLauncher".equals(parameter.id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evaluateParameters() {
        this.myEvaluationState = EvaluationState.EVALUATING;
        Collection<Parameter> parameters = ((RenderTemplateModel)this.getModel()).getTemplateHandle().getMetadata().getParameters();
        HashSet excludedParameters = Sets.newHashSet();
        try {
            HashMap additionalValues = Maps.newHashMap();
            additionalValues.put("packageName", this.myPackageName.get());
            ObjectProperty<AndroidSourceSet> sourceSet = ((RenderTemplateModel)this.getModel()).getSourceSet();
            additionalValues.put("sourceProviderName", ((AndroidSourceSet)sourceSet.get()).getName());
            additionalValues.put("isInstantApp", this.myFacet != null && this.myFacet.getProjectType() == 5 || (Boolean)((RenderTemplateModel)this.getModel()).instantApp().get() != false);
            additionalValues.put("companyDomain", NewProjectModel.getInitialDomain(false));
            HashMap allValues = Maps.newHashMap((Map)additionalValues);
            Map<Parameter, Object> parameterValues = ParameterValueResolver.resolve(parameters, this.myUserValues, additionalValues, new ParameterDeduplicator());
            for (Parameter parameter : parameters) {
                Object value = parameterValues.get(parameter);
                if (value == null) continue;
                this.myParameterRows.get(parameter).setValue(value);
                allValues.put(parameter.id, value);
            }
            for (Parameter parameter : parameters) {
                String enabledStr = Strings.nullToEmpty((String)parameter.enabled);
                if (!enabledStr.isEmpty()) {
                    boolean enabled = this.myEvaluator.evaluateBooleanExpression(enabledStr, allValues, true);
                    this.myParameterRows.get(parameter).setEnabled(enabled);
                    if (!enabled) {
                        excludedParameters.add(parameter.id);
                    }
                }
                if (!this.isParameterVisible(parameter)) {
                    this.myParameterRows.get(parameter).setVisible(false);
                    excludedParameters.add(parameter.id);
                    continue;
                }
                String visibilityStr = Strings.nullToEmpty((String)parameter.visibility);
                if (visibilityStr.isEmpty()) continue;
                boolean visible = this.myEvaluator.evaluateBooleanExpression(visibilityStr, allValues, true);
                this.myParameterRows.get(parameter).setVisible(visible);
                if (visible) continue;
                excludedParameters.add(parameter.id);
            }
            this.myThumbPath.set(this.getCurrentThumbnailPath());
        }
        catch (CircularParameterDependencyException e) {
            ConfigureTemplateParametersStep.getLog().error("Circular dependency between parameters in template %1$s", (Throwable)e, new String[]{((RenderTemplateModel)this.getModel()).getTemplateHandle().getMetadata().getTitle()});
        }
        finally {
            this.myEvaluationState = EvaluationState.NOT_EVALUATING;
        }
        this.myInvalidParameterMessage.set(Strings.nullToEmpty((String)this.validateAllParametersExcept(excludedParameters)));
    }

    @NotNull
    private String getDefaultThumbnailPath() {
        String string = Strings.nullToEmpty((String)((RenderTemplateModel)this.getModel()).getTemplateHandle().getMetadata().getThumbnailPath());
        if (string == null) {
            ConfigureTemplateParametersStep.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private String getCurrentThumbnailPath() {
        String string = Strings.nullToEmpty((String)((RenderTemplateModel)this.getModel()).getTemplateHandle().getMetadata().getThumbnailPath((Function<String, Object>)((Function)parameterId -> {
            Parameter parameter = ((RenderTemplateModel)this.getModel()).getTemplateHandle().getMetadata().getParameter((String)parameterId);
            ObservableValue<?> property = this.myParameterRows.get(parameter).getProperty();
            return property != null ? property.get() : null;
        })));
        if (string == null) {
            ConfigureTemplateParametersStep.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    private String validateAllParametersExcept(@NotNull Set<String> excludedParameters) {
        if (excludedParameters == null) {
            ConfigureTemplateParametersStep.$$$reportNull$$$0(10);
        }
        String message = null;
        Collection<Parameter> parameters = ((RenderTemplateModel)this.getModel()).getTemplateHandle().getMetadata().getParameters();
        Module module = this.myFacet == null ? null : this.myFacet.getModule();
        Project project = ((RenderTemplateModel)this.getModel()).getProject().getValueOrNull();
        SourceProvider sourceProvider = ((AndroidSourceSet)((RenderTemplateModel)this.getModel()).getSourceSet().get()).toSourceProvider();
        for (Parameter parameter : parameters) {
            ObservableValue<?> property = this.myParameterRows.get(parameter).getProperty();
            if (property == null || excludedParameters.contains(parameter.id)) continue;
            Set<Object> relatedValues = this.getRelatedValues(parameter);
            message = parameter.validate(project, module, sourceProvider, (String)this.myPackageName.get(), property.get(), relatedValues);
            if (message == null) continue;
            break;
        }
        return message;
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        StudioWizardStepPanel studioWizardStepPanel = this.myStudioPanel;
        if (studioWizardStepPanel == null) {
            ConfigureTemplateParametersStep.$$$reportNull$$$0(11);
        }
        return studioWizardStepPanel;
    }

    @Override
    @Nullable
    protected JComponent getPreferredFocusComponent() {
        Component[] children = this.myParametersPanel.getComponents();
        for (int i = 0; i < children.length; ++i) {
            boolean isContainer;
            JComponent child = (JComponent)children[i];
            boolean bl = isContainer = child.getComponentCount() > 0;
            if (isContainer || !child.isFocusable() || !child.isVisible()) continue;
            return child;
        }
        return null;
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        ObservableBool observableBool = this.myValidatorPanel.hasErrors().not();
        if (observableBool == null) {
            ConfigureTemplateParametersStep.$$$reportNull$$$0(12);
        }
        return observableBool;
    }

    private void createUIComponents() {
        this.myParametersPanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 10));
    }

    private void resetPanel() {
        this.myParametersPanel.removeAll();
        this.myParameterRows.clear();
        this.dispose();
    }

    @Override
    public void dispose() {
        this.myBindings.releaseAll();
        this.myThumbnailsCache.invalidateAll();
    }

    @Override
    protected void onProceeding() {
        AndroidSourceSet sourceSet = (AndroidSourceSet)((RenderTemplateModel)this.getModel()).getSourceSet().get();
        AndroidProjectPaths paths = sourceSet.getPaths();
        File moduleRoot = paths.getModuleRoot();
        if (moduleRoot == null) {
            ConfigureTemplateParametersStep.getLog().error(String.format("%s failure: can't create files because module root is not found. Please report this error.", this.getTitle()));
            return;
        }
        for (RowEntry rowEntry : this.myParameterRows.values()) {
            rowEntry.accept();
        }
        Map<String, Object> templateValues = ((RenderTemplateModel)this.getModel()).getTemplateValues();
        templateValues.clear();
        for (Parameter parameter : this.myParameterRows.keySet()) {
            ObservableValue<?> property = this.myParameterRows.get(parameter).getProperty();
            if (property == null) continue;
            templateValues.put(parameter.id, property.get());
        }
        if (this.displayLanguageChoice(((RenderTemplateModel)this.getModel()).getTemplateHandle().getMetadata())) {
            Language language = (Language)((Object)((RenderTemplateModel)this.getModel()).getLanguage().get());
            templateValues.put("language", (Object)language);
            templateValues.put("includeKotlinSupport", language == Language.KOTLIN);
        }
        templateValues.put("sourceProviderName", sourceSet.getName());
        if (this.isNewModule()) {
            templateValues.put("isLauncher", true);
        }
        TemplateValueInjector templateValueInjector = new TemplateValueInjector(templateValues).setModuleRoots(paths, (String)this.myPackageName.get());
        if (this.myFacet == null) {
            templateValueInjector.setBuildVersion(((RenderTemplateModel)this.getModel()).androidSdkInfo().getValue(), ((RenderTemplateModel)this.getModel()).getProject().getValueOrNull());
        } else {
            templateValueInjector.setFacet(this.myFacet);
            String applicationPackage = AndroidPackageUtils.getPackageForApplication(this.myFacet);
            if (!((String)this.myPackageName.get()).equals(applicationPackage)) {
                templateValues.put("applicationPackage", AndroidPackageUtils.getPackageForApplication(this.myFacet));
            }
        }
    }

    private Set<Object> getRelatedValues(@NotNull Parameter parameter) {
        if (parameter == null) {
            ConfigureTemplateParametersStep.$$$reportNull$$$0(13);
        }
        HashSet relatedValues = Sets.newHashSet();
        for (Parameter related : parameter.template.getRelatedParams(parameter)) {
            ObservableValue<?> property = this.myParameterRows.get(related).getProperty();
            if (property == null) continue;
            relatedValues.add(property.get());
        }
        return relatedValues;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSets";
                break;
            }
            case 3: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/template/ConfigureTemplateParametersStep";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/template/ConfigureTemplateParametersStep";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecentsKeyForParameter";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createDependentSteps";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultThumbnailPath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentThumbnailPath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "canGoForward";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRecentsKeyForParameter";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createRowForParameter";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "validateAllParametersExcept";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRelatedValues";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JBScrollPane jBScrollPane;
        JLabel jLabel2;
        TooltipLabel tooltipLabel;
        JSeparator jSeparator;
        JPanel jPanel;
        this.createUIComponents();
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myFooterSeparator = jSeparator = new JSeparator();
        jPanel.add((Component)jSeparator, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myParameterDescriptionLabel = tooltipLabel = new TooltipLabel();
        tooltipLabel.setText("");
        jPanel.add((Component)tooltipLabel, new GridConstraints(3, 1, 1, 1, 8, 0, 1, 2, null, null, null));
        this.myTemplateThumbLabel = jLabel2 = new JLabel();
        jLabel2.setHorizontalTextPosition(0);
        jLabel2.setVerticalAlignment(1);
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        this.myParametersScrollPane = jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 1, 1, 2, 0, 3, 3, 7, null, null, null));
        JPanel jPanel2 = this.myParametersPanel;
        jPanel2.setOpaque(true);
        jBScrollPane.setViewportView(jPanel2);
        this.myTemplateDescriptionLabel = jLabel = new JLabel();
        Font font = this.$$$getFont$$$(null, 1, 14, jLabel.getFont());
        if (font != null) {
            jLabel.setFont(font);
        }
        jLabel.setText("Label");
        jPanel.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        return new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
    }

    private final class ResetParameterAction
    extends AnAction {
        @NotNull
        private final Parameter myParameter;

        public ResetParameterAction(Parameter parameter) {
            if (parameter == null) {
                ResetParameterAction.$$$reportNull$$$0(0);
            }
            super("Restore default value", "Discards any user modifications made to this parameter", AllIcons.General.Reset);
            this.myParameter = parameter;
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(ConfigureTemplateParametersStep.this.myUserValues.containsKey(this.myParameter));
        }

        public void actionPerformed(AnActionEvent e) {
            ConfigureTemplateParametersStep.this.myUserValues.remove(this.myParameter);
            ConfigureTemplateParametersStep.this.evaluateParameters();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/android/tools/idea/npw/template/ConfigureTemplateParametersStep$ResetParameterAction", "<init>"));
        }
    }

    private final class ParameterDeduplicator
    implements ParameterValueResolver.Deduplicator {
        private ParameterDeduplicator() {
        }

        @Override
        @Nullable
        public String deduplicate(@NotNull Parameter parameter, @Nullable String value) {
            if (parameter == null) {
                ParameterDeduplicator.$$$reportNull$$$0(0);
            }
            if (Strings.isNullOrEmpty((String)value) || !parameter.constraints.contains((Object)Parameter.Constraint.UNIQUE)) {
                return value;
            }
            String suggested = value;
            String extPart = Strings.emptyToNull((String)Files.getFileExtension((String)value));
            String namePart = value.replace("." + extPart, "");
            namePart = namePart.replaceAll("\\d*$", "");
            Joiner filenameJoiner = Joiner.on((char)'.').skipNulls();
            int suffix = 2;
            Module module = ConfigureTemplateParametersStep.this.myFacet != null ? ConfigureTemplateParametersStep.this.myFacet.getModule() : null;
            Project project = ((RenderTemplateModel)ConfigureTemplateParametersStep.this.getModel()).getProject().getValueOrNull();
            Set relatedValues = ConfigureTemplateParametersStep.this.getRelatedValues(parameter);
            SourceProvider sourceProvider = ((AndroidSourceSet)((RenderTemplateModel)ConfigureTemplateParametersStep.this.getModel()).getSourceSet().get()).toSourceProvider();
            while (!parameter.uniquenessSatisfied(project, module, sourceProvider, (String)ConfigureTemplateParametersStep.this.myPackageName.get(), suggested, relatedValues)) {
                suggested = filenameJoiner.join((Object)(namePart + suffix), (Object)extPart, new Object[0]);
                ++suffix;
            }
            return suggested;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/android/tools/idea/npw/template/ConfigureTemplateParametersStep$ParameterDeduplicator", "deduplicate"));
        }
    }

    private static final class RowEntry<T extends JComponent> {
        @NotNull
        private final Component myStrut;
        @Nullable
        private final JBLabel myHeader;
        @NotNull
        private final ComponentProvider<T> myComponentProvider;
        @NotNull
        private final T myComponent;
        @Nullable
        private final AbstractProperty<?> myProperty;

        public RowEntry(@NotNull String headerText, @NotNull ComponentProvider<T> componentProvider) {
            if (headerText == null) {
                RowEntry.$$$reportNull$$$0(0);
            }
            if (componentProvider == null) {
                RowEntry.$$$reportNull$$$0(1);
            }
            this.myStrut = Box.createVerticalStrut(8);
            this.myHeader = new JBLabel(headerText);
            this.myHeader.setFont(this.myHeader.getFont().deriveFont(1));
            this.myComponentProvider = componentProvider;
            this.myComponent = componentProvider.createComponent();
            this.myProperty = componentProvider.createProperty(this.myComponent);
            this.myHeader.setLabelFor(this.myComponent);
        }

        public RowEntry(@NotNull ParameterComponentProvider<T> componentProvider) {
            if (componentProvider == null) {
                RowEntry.$$$reportNull$$$0(2);
            }
            this.myStrut = Box.createVerticalStrut(8);
            this.myHeader = null;
            this.myComponentProvider = componentProvider;
            this.myComponent = componentProvider.createComponent();
            this.myProperty = componentProvider.createProperty(this.myComponent);
        }

        @Nullable
        public ObservableValue<?> getProperty() {
            return this.myProperty;
        }

        public void addToPanel(@NotNull JPanel panel) {
            if (panel == null) {
                RowEntry.$$$reportNull$$$0(3);
            }
            if (panel.getComponentCount() != 0) {
                panel.add(this.myStrut);
            }
            if (this.myHeader != null) {
                panel.add((Component)this.myHeader);
            }
            panel.add((Component)this.myComponent);
        }

        public void setEnabled(boolean enabled) {
            if (this.myHeader != null) {
                this.myHeader.setEnabled(enabled);
            }
            ((JComponent)this.myComponent).setEnabled(enabled);
        }

        public void setVisible(boolean visible) {
            if (this.myHeader != null) {
                this.myHeader.setVisible(visible);
            }
            this.myStrut.setVisible(visible);
            ((JComponent)this.myComponent).setVisible(visible);
        }

        public <V> void setValue(@NotNull V value) {
            if (value == null) {
                RowEntry.$$$reportNull$$$0(4);
            }
            assert (this.myProperty != null);
            this.myProperty.set(value);
        }

        @NotNull
        public JComponent getComponent() {
            T t = this.myComponent;
            if (t == null) {
                RowEntry.$$$reportNull$$$0(5);
            }
            return t;
        }

        public void accept() {
            this.myComponentProvider.accept(this.myComponent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "headerText";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "componentProvider";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "panel";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/npw/template/ConfigureTemplateParametersStep$RowEntry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/npw/template/ConfigureTemplateParametersStep$RowEntry";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addToPanel";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setValue";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static enum EvaluationState {
        NOT_EVALUATING,
        REQUEST_ENQUEUED,
        EVALUATING;

    }
}

