/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.template;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class MultiTemplateRenderer {
    private final List<TemplateRenderer> myTemplateRenderers = new ArrayList<TemplateRenderer>();
    private int myRequestCount = 1;

    public void increment() {
        ++this.myRequestCount;
    }

    private void countDown() {
        if (this.myRequestCount == 0) {
            throw new IllegalStateException("Invalid extra call to MultiTemplateRenderer#countDown");
        }
        --this.myRequestCount;
        if (this.myRequestCount == 0) {
            for (TemplateRenderer renderer : this.myTemplateRenderers) {
                if (renderer.doDryRun()) continue;
                return;
            }
            for (TemplateRenderer renderer : this.myTemplateRenderers) {
                renderer.render();
            }
        }
    }

    public void requestRender(@NotNull TemplateRenderer templateRenderer) {
        if (templateRenderer == null) {
            MultiTemplateRenderer.$$$reportNull$$$0(0);
        }
        this.myTemplateRenderers.add(templateRenderer);
        this.countDown();
    }

    public void skipRender() {
        this.countDown();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateRenderer", "com/android/tools/idea/npw/template/MultiTemplateRenderer", "requestRender"));
    }

    public static interface TemplateRenderer {
        public boolean doDryRun();

        public void render();
    }
}

