/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.profilers.AndroidProfilerToolWindowFactory;
import com.android.tools.idea.profilers.IntellijProfilerComponents;
import com.android.tools.idea.profilers.IntellijProfilerServices;
import com.android.tools.idea.profilers.ProfilerService;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.ProfilerMode;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.StudioProfilersView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidProfilerToolWindow
extends AspectObserver
implements Disposable {
    @NotNull
    private final StudioProfilersView myView;
    @NotNull
    private final StudioProfilers myProfilers;
    @NotNull
    private final Project myProject;

    public AndroidProfilerToolWindow(@NotNull Project project) {
        if (project == null) {
            AndroidProfilerToolWindow.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        ProfilerService service = ProfilerService.getInstance(this.myProject);
        ProfilerClient client = service.getProfilerClient();
        this.myProfilers = new StudioProfilers(client, (IdeProfilerServices)new IntellijProfilerServices(this.myProject));
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> this.myProfilers.setPreferredProcessName(this.getPreferredProcessName(this.myProject)));
        this.myView = new StudioProfilersView(this.myProfilers, (IdeProfilerComponents)new IntellijProfilerComponents(this.myProject));
        this.myProfilers.addDependency((AspectObserver)this).onChange((Enum)ProfilerAspect.MODE, this::updateToolWindow).onChange((Enum)ProfilerAspect.STAGE, this::updateToolWindow);
    }

    public void updateToolWindow() {
        boolean maximize;
        ToolWindowManager manager = ToolWindowManager.getInstance((Project)this.myProject);
        ToolWindow window = manager.getToolWindow("Android Profiler");
        boolean bl = maximize = this.myProfilers.getMode() == ProfilerMode.EXPANDED;
        if (maximize != manager.isMaximized(window)) {
            manager.setMaximized(window, maximize);
        }
        if (this.myProfilers.isStopped()) {
            AndroidProfilerToolWindowFactory.removeContent(this.myProject, window);
        }
    }

    public void dispose() {
        this.myProfilers.removeDependencies((AspectObserver)this);
        this.myProfilers.stop();
    }

    public JComponent getComponent() {
        return this.myView.getComponent();
    }

    @Nullable
    private String getPreferredProcessName(Project project) {
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            String pkg;
            AndroidModuleInfo moduleInfo = AndroidModuleInfo.getInstance(module);
            if (moduleInfo == null || (pkg = moduleInfo.getPackage()) == null) continue;
            return pkg;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/profilers/AndroidProfilerToolWindow", "<init>"));
    }
}

