/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.res2.ResourceNamespaces;
import com.android.ide.common.res2.ResourceTable;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.DataBindingInfo;
import com.android.tools.idea.res.LocalResourceRepository;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.SmartHashSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MultiResourceRepository
extends LocalResourceRepository {
    @GuardedBy(value="ITEM_MAP_LOCK")
    private List<? extends LocalResourceRepository> myChildren;
    @GuardedBy(value="ITEM_MAP_LOCK")
    private long[] myModificationCounts;
    @GuardedBy(value="ITEM_MAP_LOCK")
    private ResourceTable myFullTable;
    @GuardedBy(value="ITEM_MAP_LOCK")
    private Set<String> myCachedNamespaces;
    @GuardedBy(value="ITEM_MAP_LOCK")
    private final ResourceTable myCachedMaps;
    @GuardedBy(value="ITEM_MAP_LOCK")
    private final Map<ResourceType, Boolean> myCachedHasResourcesOfType;
    @GuardedBy(value="ITEM_MAP_LOCK")
    private Map<String, DataBindingInfo> myDataBindingResourceFiles;
    @GuardedBy(value="ITEM_MAP_LOCK")
    private long myDataBindingResourceFilesModificationCount;

    MultiResourceRepository(@NotNull String displayName, @NotNull List<? extends LocalResourceRepository> children) {
        if (displayName == null) {
            MultiResourceRepository.$$$reportNull$$$0(0);
        }
        if (children == null) {
            MultiResourceRepository.$$$reportNull$$$0(1);
        }
        super(displayName);
        this.myCachedMaps = new ResourceTable();
        this.myCachedHasResourcesOfType = Maps.newEnumMap(ResourceType.class);
        this.myDataBindingResourceFiles = Maps.newHashMap();
        this.myDataBindingResourceFilesModificationCount = Long.MIN_VALUE;
        this.setChildren(children);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setChildren(@NotNull List<? extends LocalResourceRepository> children) {
        if (children == null) {
            MultiResourceRepository.$$$reportNull$$$0(2);
        }
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            LocalResourceRepository resources;
            int i;
            if (this.myChildren != null) {
                for (i = this.myChildren.size() - 1; i >= 0; --i) {
                    resources = this.myChildren.get(i);
                    resources.removeParent(this);
                }
            }
            this.setModificationCount(ourModificationCounter.incrementAndGet());
            this.myChildren = children;
            this.myModificationCounts = new long[children.size()];
            if (children.size() == 1) {
                LocalResourceRepository child = children.get(0);
                child.setModificationCount(this.getModificationCount());
            }
            for (i = this.myChildren.size() - 1; i >= 0; --i) {
                resources = this.myChildren.get(i);
                resources.addParent(this);
                this.myModificationCounts[i] = resources.getModificationCount();
            }
            this.myFullTable = null;
            this.myCachedMaps.clear();
            this.myCachedHasResourcesOfType.clear();
        }
        this.invalidateParentCaches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<? extends LocalResourceRepository> getChildren() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            return ImmutableList.copyOf(this.myChildren);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getModificationCount() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            if (this.myChildren.size() == 1) {
                return this.myChildren.get(0).getModificationCount();
            }
            boolean changed = false;
            for (int i = this.myChildren.size() - 1; i >= 0; --i) {
                LocalResourceRepository resources = this.myChildren.get(i);
                long rev = resources.getModificationCount();
                if (rev == this.myModificationCounts[i]) continue;
                this.myModificationCounts[i] = rev;
                changed = true;
            }
            if (changed) {
                this.setModificationCount(ourModificationCounter.incrementAndGet());
            }
            return super.getModificationCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public DataBindingInfo getDataBindingInfoForLayout(String layoutName) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            for (LocalResourceRepository localResourceRepository : this.myChildren) {
                DataBindingInfo info = localResourceRepository.getDataBindingInfoForLayout(layoutName);
                if (info == null) continue;
                return info;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public Map<String, DataBindingInfo> getDataBindingResourceFiles() {
        Object object = ITEM_MAP_LOCK;
        // MONITORENTER : object
        long modificationCount = this.getModificationCount();
        if (this.myDataBindingResourceFilesModificationCount == modificationCount) {
            Map<String, DataBindingInfo> map = this.myDataBindingResourceFiles;
            // MONITOREXIT : object
            if (map != null) return map;
            MultiResourceRepository.$$$reportNull$$$0(3);
            return map;
        }
        HashMap selected = Maps.newHashMap();
        Iterator<? extends LocalResourceRepository> iterator = this.myChildren.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.myDataBindingResourceFiles = Collections.unmodifiableMap(selected);
                this.myDataBindingResourceFilesModificationCount = modificationCount;
                Map<String, DataBindingInfo> map = this.myDataBindingResourceFiles;
                // MONITOREXIT : object
                if (map != null) return map;
                MultiResourceRepository.$$$reportNull$$$0(4);
                return map;
            }
            LocalResourceRepository localResourceRepository = iterator.next();
            Map<String, DataBindingInfo> childFiles = localResourceRepository.getDataBindingResourceFiles();
            if (childFiles == null) continue;
            selected.putAll(childFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public synchronized Set<String> getNamespaces() {
        Object object = ITEM_MAP_LOCK;
        // MONITORENTER : object
        if (this.myCachedNamespaces == null) {
            if (this.myChildren.size() == 1) {
                this.myCachedNamespaces = this.myChildren.get(0).getNamespaces();
            } else {
                this.myCachedNamespaces = new SmartHashSet();
                for (LocalResourceRepository localResourceRepository : this.myChildren) {
                    for (String namespace : localResourceRepository.getNamespaces()) {
                        this.myCachedNamespaces.add(ResourceNamespaces.normalizeNamespace((String)namespace));
                    }
                }
            }
        }
        Set<String> set = this.myCachedNamespaces;
        // MONITOREXIT : object
        if (set != null) return set;
        MultiResourceRepository.$$$reportNull$$$0(5);
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourceTable getFullTable() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            if (this.myFullTable == null) {
                if (this.myChildren.size() == 1) {
                    this.myFullTable = this.myChildren.get(0).getItems();
                } else {
                    this.myFullTable = new ResourceTable();
                    for (String namespace : this.getNamespaces()) {
                        for (ResourceType type : ResourceType.values()) {
                            ListMultimap<String, ResourceItem> map = this.getMap(namespace, type, false);
                            if (map == null) continue;
                            this.myFullTable.put(namespace, (Object)type, map);
                        }
                    }
                }
            }
            return this.myFullTable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected ListMultimap<String, ResourceItem> getMap(@Nullable String namespace, ResourceType type, boolean create) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            ListMultimap map = (ListMultimap)this.myCachedMaps.get((Object)namespace, (Object)type);
            if (map != null) {
                return map;
            }
            if (this.myChildren.size() == 1) {
                LocalResourceRepository child = this.myChildren.get(0);
                if (child instanceof MultiResourceRepository) {
                    return ((MultiResourceRepository)child).getMap(namespace, type);
                }
                return (ListMultimap)child.getItems().get((Object)namespace, (Object)type);
            }
            map = ArrayListMultimap.create();
            HashSet visited = Sets.newHashSet();
            HashMultimap seenQualifiers = HashMultimap.create();
            this.merge(visited, namespace, type, (SetMultimap<String, String>)seenQualifiers, (ListMultimap<String, ResourceItem>)map);
            this.myCachedMaps.put(namespace, (Object)type, (Object)map);
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doMerge(@NotNull Set<LocalResourceRepository> visited, @Nullable String namespace, @NotNull ResourceType type, @NotNull SetMultimap<String, String> seenQualifiers, @NotNull ListMultimap<String, ResourceItem> result) {
        if (visited == null) {
            MultiResourceRepository.$$$reportNull$$$0(6);
        }
        if (type == null) {
            MultiResourceRepository.$$$reportNull$$$0(7);
        }
        if (seenQualifiers == null) {
            MultiResourceRepository.$$$reportNull$$$0(8);
        }
        if (result == null) {
            MultiResourceRepository.$$$reportNull$$$0(9);
        }
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            for (int i = this.myChildren.size() - 1; i >= 0; --i) {
                this.myChildren.get(i).merge(visited, namespace, type, seenQualifiers, result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasResourcesOfType(@NotNull ResourceType type) {
        if (type == null) {
            MultiResourceRepository.$$$reportNull$$$0(10);
        }
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            if (this.myChildren.size() == 1) {
                return this.myChildren.get(0).hasResourcesOfType(type);
            }
            Boolean cachedResult = this.myCachedHasResourcesOfType.get(type);
            if (cachedResult != null) {
                return cachedResult;
            }
            HashSet visited = Sets.newHashSet();
            boolean result = this.computeHasResourcesOfType(type, visited);
            this.myCachedHasResourcesOfType.put(type, result);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean computeHasResourcesOfType(@NotNull ResourceType type, @NotNull Set<LocalResourceRepository> visited) {
        if (type == null) {
            MultiResourceRepository.$$$reportNull$$$0(11);
        }
        if (visited == null) {
            MultiResourceRepository.$$$reportNull$$$0(12);
        }
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            if (!visited.add(this)) {
                return false;
            }
            for (LocalResourceRepository localResourceRepository : this.myChildren) {
                if (!localResourceRepository.computeHasResourcesOfType(type, visited)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            for (int i = this.myChildren.size() - 1; i >= 0; --i) {
                LocalResourceRepository resources = this.myChildren.get(i);
                resources.removeParent(this);
                Disposer.dispose((Disposable)resources);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateCache(@NotNull LocalResourceRepository repository) {
        if (repository == null) {
            MultiResourceRepository.$$$reportNull$$$0(13);
        }
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            assert (this.myChildren.contains((Object)repository)) : repository;
            this.myCachedNamespaces = null;
            this.myCachedMaps.clear();
            this.myCachedHasResourcesOfType.clear();
            this.myFullTable = null;
            this.setModificationCount(ourModificationCounter.incrementAndGet());
            this.invalidateParentCaches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateCache(@NotNull LocalResourceRepository repository, @Nullable String namespace, ResourceType ... types) {
        if (repository == null) {
            MultiResourceRepository.$$$reportNull$$$0(14);
        }
        if (types == null) {
            MultiResourceRepository.$$$reportNull$$$0(15);
        }
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            assert (this.myChildren.contains((Object)repository)) : repository;
            for (ResourceType type : types) {
                this.myCachedNamespaces = null;
                this.myCachedMaps.remove((Object)namespace, (Object)type);
                if (!ResourceNamespaces.isDefaultNamespace((String)namespace)) continue;
                this.myCachedHasResourcesOfType.remove(type);
            }
            this.myFullTable = null;
            this.setModificationCount(ourModificationCounter.incrementAndGet());
            this.invalidateParentCaches(namespace, types);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isScanPending(PsiFile psiFile) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            assert (ApplicationManager.getApplication().isUnitTestMode());
            for (int i = this.myChildren.size() - 1; i >= 0; --i) {
                LocalResourceRepository resources = this.myChildren.get(i);
                if (!resources.isScanPending(psiFile)) continue;
                return true;
            }
            return false;
        }
    }

    @Override
    public void sync() {
        super.sync();
        for (LocalResourceRepository localResourceRepository : this.getChildren()) {
            localResourceRepository.sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    protected Set<VirtualFile> computeResourceDirs() {
        Object object = ITEM_MAP_LOCK;
        // MONITORENTER : object
        HashSet result = Sets.newHashSet();
        Iterator<? extends LocalResourceRepository> iterator = this.myChildren.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                HashSet hashSet = result;
                // MONITOREXIT : object
                if (hashSet != null) return hashSet;
                MultiResourceRepository.$$$reportNull$$$0(16);
                return hashSet;
            }
            LocalResourceRepository localResourceRepository = iterator.next();
            result.addAll(localResourceRepository.computeResourceDirs());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/MultiResourceRepository";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "seenQualifiers";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/MultiResourceRepository";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataBindingResourceFiles";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaces";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "computeResourceDirs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setChildren";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 16: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doMerge";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasResourcesOfType";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "computeHasResourcesOfType";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "invalidateCache";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

