/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.SdkConstants;
import com.android.ide.common.rendering.api.ArrayResourceValue;
import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.DeclareStyleableResourceValue;
import com.android.ide.common.rendering.api.DensityBasedResourceValue;
import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.rendering.api.PluralsResourceValue;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.rendering.api.TextResourceValue;
import com.android.ide.common.res2.DataFile;
import com.android.ide.common.res2.ResourceFile;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.res2.ValueXmlHelper;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.Density;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.res.PsiResourceFile;
import com.android.tools.idea.res.ResourceHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import java.util.Collections;
import org.jetbrains.annotations.Nullable;

class PsiResourceItem
extends ResourceItem {
    private final XmlTag myTag;
    private PsiFile myFile;

    PsiResourceItem(String name, ResourceType type, @Nullable String namespace, @Nullable XmlTag tag, PsiFile file) {
        super(name, namespace, type, null, null);
        this.myTag = tag;
        this.myFile = file;
    }

    public FolderConfiguration getConfiguration() {
        PsiResourceFile source = (PsiResourceFile)super.getSource();
        if (source == null) {
            String name;
            FolderConfiguration configuration;
            PsiDirectory parent;
            if (this.myFile != null && (parent = this.myFile.getParent()) != null && (configuration = FolderConfiguration.getConfigForFolder((String)(name = parent.getName()))) != null) {
                return configuration;
            }
            String qualifiers = this.getQualifiers();
            FolderConfiguration fromQualifiers = FolderConfiguration.getConfigForQualifierString((String)qualifiers);
            if (fromQualifiers == null) {
                return new FolderConfiguration();
            }
            return fromQualifiers;
        }
        return source.getFolderConfiguration();
    }

    @Nullable
    public ResourceFile getSource() {
        PsiElement parent;
        ResourceFile source = (ResourceFile)super.getSource();
        PsiElement psiElement = parent = source == null && this.myFile != null ? AndroidPsiUtils.getPsiParentSafely((PsiElement)this.myFile) : null;
        if (parent == null || !(parent instanceof PsiDirectory)) {
            return source;
        }
        String name = ((PsiDirectory)parent).getName();
        ResourceFolderType folderType = ResourceFolderType.getFolderType((String)name);
        FolderConfiguration configuration = FolderConfiguration.getConfigForFolder((String)name);
        int index = name.indexOf(45);
        String qualifiers = index == -1 ? "" : name.substring(index + 1);
        source = new PsiResourceFile(this.myFile, Collections.singletonList(this), qualifiers, folderType, configuration);
        this.setSource((DataFile)source);
        return source;
    }

    @Nullable
    public ResourceValue getResourceValue(boolean isFrameworks) {
        if (this.mResourceValue == null) {
            if (this.myTag == null) {
                Density density;
                ResourceType type = this.getType();
                Object object = density = type == ResourceType.DRAWABLE || type == ResourceType.MIPMAP ? this.getFolderDensity() : null;
                this.mResourceValue = density != null ? new DensityBasedResourceValue(this.getResourceUrl(isFrameworks), this.getSource().getFile().getAbsolutePath(), density, null) : new ResourceValue(this.getResourceUrl(isFrameworks), this.getSource().getFile().getAbsolutePath(), null);
            } else {
                this.mResourceValue = this.parseXmlToResourceValue(isFrameworks);
            }
        }
        return this.mResourceValue;
    }

    @Nullable
    private Density getFolderDensity() {
        DensityQualifier densityQualifier;
        FolderConfiguration configuration = this.getConfiguration();
        if (configuration != null && (densityQualifier = configuration.getDensityQualifier()) != null) {
            return densityQualifier.getValue();
        }
        return null;
    }

    @Nullable
    private ResourceValue parseXmlToResourceValue(boolean isFrameworks) {
        Object value;
        assert (this.myTag != null);
        if (!this.myTag.isValid()) {
            return null;
        }
        ResourceType type = this.getType();
        String name = this.getName();
        switch (type) {
            case STYLE: {
                String parent = PsiResourceItem.getAttributeValue(this.myTag, "parent");
                value = this.parseStyleValue(new StyleResourceValue(this.getResourceUrl(isFrameworks), parent, null));
                break;
            }
            case DECLARE_STYLEABLE: {
                value = this.parseDeclareStyleable(new DeclareStyleableResourceValue(this.getResourceUrl(isFrameworks), null, null));
                break;
            }
            case ATTR: {
                value = this.parseAttrValue(new AttrResourceValue(this.getResourceUrl(isFrameworks), null));
                break;
            }
            case ARRAY: {
                value = this.parseArrayValue(new ArrayResourceValue(this.getResourceUrl(isFrameworks), null){

                    protected int getDefaultIndex() {
                        String index = PsiResourceItem.this.myTag.getAttributeValue("index", "http://schemas.android.com/tools");
                        if (index != null) {
                            return Integer.parseInt(index);
                        }
                        return super.getDefaultIndex();
                    }
                });
                break;
            }
            case PLURALS: {
                value = this.parsePluralsValue(new PluralsResourceValue(this.getResourceUrl(isFrameworks), null, null){

                    public String getValue() {
                        String value;
                        String quantity = PsiResourceItem.this.myTag.getAttributeValue("quantity", "http://schemas.android.com/tools");
                        if (quantity != null && (value = this.getValue(quantity)) != null) {
                            return value;
                        }
                        return super.getValue();
                    }
                });
                break;
            }
            case STRING: {
                value = this.parseTextValue(new PsiTextResourceValue(this.getResourceUrl(isFrameworks), null, null, null));
                break;
            }
            default: {
                value = this.parseValue(new ResourceValue(this.getResourceUrl(isFrameworks), null));
            }
        }
        return value;
    }

    @Nullable
    private static String getAttributeValue(XmlTag tag, String attributeName) {
        return tag.getAttributeValue(attributeName);
    }

    private ResourceValue parseDeclareStyleable(DeclareStyleableResourceValue declareStyleable) {
        assert (this.myTag != null);
        for (XmlTag child : this.myTag.getSubTags()) {
            String name = PsiResourceItem.getAttributeValue(child, "name");
            if (StringUtil.isEmpty((String)name)) continue;
            boolean isFrameworkAttr = declareStyleable.isFramework();
            if (name.startsWith("android:")) {
                name = name.substring(SdkConstants.ANDROID_NS_NAME_PREFIX_LEN);
                isFrameworkAttr = true;
            }
            AttrResourceValue attr = PsiResourceItem.parseAttrValue(child, new AttrResourceValue(ResourceUrl.create((ResourceType)ResourceType.ATTR, (String)name, (boolean)isFrameworkAttr), null));
            declareStyleable.addValue(attr);
        }
        return declareStyleable;
    }

    private ResourceValue parseStyleValue(StyleResourceValue styleValue) {
        assert (this.myTag != null);
        for (XmlTag child : this.myTag.getSubTags()) {
            String name = PsiResourceItem.getAttributeValue(child, "name");
            if (StringUtil.isEmpty((String)name)) continue;
            boolean isFrameworkAttr = styleValue.isFramework();
            if (name.startsWith("android:")) {
                name = name.substring(SdkConstants.ANDROID_NS_NAME_PREFIX_LEN);
                isFrameworkAttr = true;
            }
            String value = ValueXmlHelper.unescapeResourceString((String)ResourceHelper.getTextContent(child), (boolean)true, (boolean)true);
            ItemResourceValue resValue = new ItemResourceValue(name, isFrameworkAttr, value, styleValue.isFramework(), styleValue.getLibraryName());
            styleValue.addItem(resValue);
        }
        return styleValue;
    }

    private AttrResourceValue parseAttrValue(AttrResourceValue attrValue) {
        assert (this.myTag != null);
        return PsiResourceItem.parseAttrValue(this.myTag, attrValue);
    }

    private static AttrResourceValue parseAttrValue(XmlTag myTag, AttrResourceValue attrValue) {
        for (XmlTag child : myTag.getSubTags()) {
            String value;
            String name = PsiResourceItem.getAttributeValue(child, "name");
            if (name == null || (value = PsiResourceItem.getAttributeValue(child, "value")) == null) continue;
            try {
                attrValue.addValue(name, Integer.valueOf((int)Long.decode(value).longValue()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return attrValue;
    }

    private ResourceValue parseArrayValue(ArrayResourceValue arrayValue) {
        assert (this.myTag != null);
        for (XmlTag child : this.myTag.getSubTags()) {
            String text = ValueXmlHelper.unescapeResourceString((String)ResourceHelper.getTextContent(child), (boolean)true, (boolean)true);
            arrayValue.addElement(text);
        }
        return arrayValue;
    }

    private ResourceValue parsePluralsValue(PluralsResourceValue value) {
        assert (this.myTag != null);
        for (XmlTag child : this.myTag.getSubTags()) {
            String quantity = child.getAttributeValue("quantity");
            if (quantity == null) continue;
            String text = ValueXmlHelper.unescapeResourceString((String)ResourceHelper.getTextContent(child), (boolean)true, (boolean)true);
            value.addPlural(quantity, text);
        }
        return value;
    }

    private ResourceValue parseValue(ResourceValue value) {
        assert (this.myTag != null);
        String text = ResourceHelper.getTextContent(this.myTag);
        text = ValueXmlHelper.unescapeResourceString((String)text, (boolean)true, (boolean)true);
        value.setValue(text);
        return value;
    }

    private PsiTextResourceValue parseTextValue(PsiTextResourceValue value) {
        assert (this.myTag != null);
        String text = ResourceHelper.getTextContent(this.myTag);
        text = ValueXmlHelper.unescapeResourceString((String)text, (boolean)true, (boolean)true);
        value.setValue(text);
        return value;
    }

    PsiFile getPsiFile() {
        return this.myFile;
    }

    public boolean recomputeValue() {
        if (this.mResourceValue != null) {
            this.mResourceValue = null;
            return true;
        }
        return false;
    }

    @Nullable
    public XmlTag getTag() {
        return this.myTag;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return super.toString() + ": " + (this.myTag != null ? ResourceHelper.getTextContent(this.myTag) : "null" + (this.myFile != null ? ":" + this.myFile.getName() : ""));
    }

    private class PsiTextResourceValue
    extends TextResourceValue {
        public PsiTextResourceValue(ResourceUrl url, String textValue, String rawXmlValue, String libraryName) {
            super(url, textValue, rawXmlValue, libraryName);
        }

        public String getRawXmlValue() {
            if (PsiResourceItem.this.myTag != null && PsiResourceItem.this.myTag.isValid()) {
                if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
                    return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                        public String compute() {
                            return PsiResourceItem.this.myTag.getValue().getText();
                        }
                    });
                }
                return PsiResourceItem.this.myTag.getValue().getText();
            }
            return this.getValue();
        }
    }
}

