/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.builder.model.InstantAppProjectBuildOutput;
import com.android.builder.model.InstantAppVariantBuildOutput;
import com.android.builder.model.TestedTargetVariant;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.ide.android.IdeVariant;
import com.android.tools.idea.gradle.run.PostBuildModel;
import com.android.tools.idea.gradle.run.PostBuildModelProvider;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.run.ApkProviderUtil;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import java.util.Collection;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleApplicationIdProvider
implements ApplicationIdProvider {
    private static final String DEFAULT_TEST_PACKAGE_SUFFIX = ".test";
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    private final PostBuildModelProvider myOutputModelProvider;

    public GradleApplicationIdProvider(@NotNull AndroidFacet facet) {
        if (facet == null) {
            GradleApplicationIdProvider.$$$reportNull$$$0(0);
        }
        this(facet, () -> null);
    }

    public GradleApplicationIdProvider(@NotNull AndroidFacet facet, @NotNull PostBuildModelProvider outputModelProvider) {
        if (facet == null) {
            GradleApplicationIdProvider.$$$reportNull$$$0(1);
        }
        if (outputModelProvider == null) {
            GradleApplicationIdProvider.$$$reportNull$$$0(2);
        }
        this.myFacet = facet;
        this.myOutputModelProvider = outputModelProvider;
    }

    @Override
    @NotNull
    public String getPackageName() throws ApkProvisionException {
        if (this.myFacet.getProjectType() == 2) {
            AndroidFacet targetFacet = this.getTargetFacet();
            if (targetFacet != null) {
                GradleApplicationIdProvider targetApplicationProvider = new GradleApplicationIdProvider(targetFacet, this.myOutputModelProvider);
                String string = targetApplicationProvider.getPackageName();
                if (string == null) {
                    GradleApplicationIdProvider.$$$reportNull$$$0(3);
                }
                return string;
            }
            GradleApplicationIdProvider.getLogger().warn("Could not get applicationId for tested module.");
        }
        if (this.myFacet.getProjectType() == 4) {
            String applicationId = this.tryToGetInstantAppApplicationId();
            if (applicationId != null) {
                String string = applicationId;
                if (string == null) {
                    GradleApplicationIdProvider.$$$reportNull$$$0(4);
                }
                return string;
            }
            GradleApplicationIdProvider.getLogger().warn("Could not get instant app applicationId from post build model.");
        }
        String string = ApkProviderUtil.computePackageName(this.myFacet);
        if (string == null) {
            GradleApplicationIdProvider.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    private String tryToGetInstantAppApplicationId() {
        AndroidModuleModel androidModel = AndroidModuleModel.get(this.myFacet);
        if (androidModel == null || !androidModel.getFeatures().isPostBuildSyncSupported() || androidModel.getAndroidProject().getProjectType() != 4) {
            return null;
        }
        PostBuildModel postBuildModel = this.myOutputModelProvider.getPostBuildModel();
        if (postBuildModel == null) {
            return null;
        }
        InstantAppProjectBuildOutput projectBuildOutput = postBuildModel.findInstantAppProjectBuildOutput(this.myFacet);
        if (projectBuildOutput == null) {
            return null;
        }
        for (InstantAppVariantBuildOutput variantBuildOutput : projectBuildOutput.getInstantAppVariantsBuildOutput()) {
            if (!variantBuildOutput.getName().equals(androidModel.getSelectedVariant().getName())) continue;
            return variantBuildOutput.getApplicationId();
        }
        return null;
    }

    @Override
    public String getTestPackageName() throws ApkProvisionException {
        if (this.myFacet.getProjectType() == 2) {
            return ApkProviderUtil.computePackageName(this.myFacet);
        }
        AndroidModuleModel androidModel = AndroidModuleModel.get(this.myFacet);
        assert (androidModel != null);
        IdeVariant selectedVariant = androidModel.getSelectedVariant();
        String testPackageName = selectedVariant.getMergedFlavor().getTestApplicationId();
        return testPackageName != null ? testPackageName : this.getPackageName() + DEFAULT_TEST_PACKAGE_SUFFIX;
    }

    @Nullable
    private AndroidFacet getTargetFacet() {
        AndroidModuleModel androidModel = AndroidModuleModel.get(this.myFacet);
        if (androidModel == null) {
            return null;
        }
        Collection targetVariants = androidModel.getSelectedVariant().getTestedTargetVariants();
        if (targetVariants.size() != 1) {
            return null;
        }
        TestedTargetVariant targetVariant = (TestedTargetVariant)targetVariants.iterator().next();
        Module targetModule = GradleUtil.findModuleByGradlePath(this.myFacet.getModule().getProject(), targetVariant.getTargetProjectPath());
        if (targetModule == null) {
            return null;
        }
        return AndroidFacet.getInstance(targetModule);
    }

    private static Logger getLogger() {
        return Logger.getInstance(GradleApplicationIdProvider.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputModelProvider";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/GradleApplicationIdProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/GradleApplicationIdProvider";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

