/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.relative;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.graphics.NlDrawingStyle;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.handlers.relative.ConstraintPainter;
import com.android.tools.idea.uibuilder.handlers.relative.DependencyGraph;
import com.android.tools.idea.uibuilder.handlers.relative.GuidelineHandler;
import com.android.tools.idea.uibuilder.handlers.relative.Match;
import com.android.tools.idea.uibuilder.handlers.relative.RelativeDragHandler;
import com.android.tools.idea.uibuilder.model.Insets;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import java.awt.AlphaComposite;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class GuidelinePainter {
    private static final AlphaComposite ALPHA_COMPOSITE = AlphaComposite.getInstance(10, 0.5f);

    public static void paint(@NotNull NlGraphics g, GuidelineHandler myState) {
        if (g == null) {
            GuidelinePainter.$$$reportNull$$$0(0);
        }
        g.useStyle(NlDrawingStyle.DRAGGED);
        for (NlComponent dragged : myState.myDraggedNodes) {
            if (NlComponentHelperKt.getW(dragged) <= 0 || NlComponentHelperKt.getH(dragged) <= 0) continue;
            g.fillRect(NlComponentHelperKt.getX(dragged), NlComponentHelperKt.getY(dragged), NlComponentHelperKt.getW(dragged), NlComponentHelperKt.getH(dragged));
        }
        Set<NlComponent> horizontalDeps = myState.myHorizontalDeps;
        Set<NlComponent> verticalDeps = myState.myVerticalDeps;
        HashSet<NlComponent> deps = new HashSet<NlComponent>(horizontalDeps.size() + verticalDeps.size());
        deps.addAll(horizontalDeps);
        deps.addAll(verticalDeps);
        if (!deps.isEmpty()) {
            g.useStyle(NlDrawingStyle.DEPENDENCY);
            for (NlComponent n : deps) {
                if (myState.myDraggedNodes.contains(n)) continue;
                g.fillRect(NlComponentHelperKt.getX(n), NlComponentHelperKt.getY(n), NlComponentHelperKt.getW(n), NlComponentHelperKt.getH(n));
            }
        }
        if (!NlComponentHelperKt.getPadding(myState.layout).isEmpty() || !NlComponentHelperKt.getMargins(myState.layout).isEmpty()) {
            g.useStyle(NlDrawingStyle.PADDING_BOUNDS);
            NlComponent layout = myState.layout;
            Insets padding = NlComponentHelperKt.getPadding(layout);
            g.drawRect(NlComponentHelperKt.getX(layout) + padding.left, NlComponentHelperKt.getY(layout) + padding.top, Math.max(0, NlComponentHelperKt.getW(layout) - padding.left - padding.right), Math.max(0, NlComponentHelperKt.getH(layout) - padding.top - padding.bottom));
        }
        if (myState.myBounds != null) {
            Rectangle bounds = myState.myBounds;
            if (myState instanceof RelativeDragHandler) {
                g.useStyle(NlDrawingStyle.DROP_PREVIEW);
            } else if (myState.haveSuggestions()) {
                g.useStyle(NlDrawingStyle.RESIZE_PREVIEW);
            } else {
                g.useStyle(NlDrawingStyle.RESIZE_FAIL);
            }
            g.drawRect(bounds.x, bounds.y, bounds.width, bounds.height);
        }
        GuidelinePainter.showMatch(g, myState.getCurrentLeftMatch(), myState);
        GuidelinePainter.showMatch(g, myState.getCurrentRightMatch(), myState);
        GuidelinePainter.showMatch(g, myState.getCurrentTopMatch(), myState);
        GuidelinePainter.showMatch(g, myState.getCurrentBottomMatch(), myState);
        if (myState.myHorizontalCycle != null) {
            GuidelinePainter.paintCycle(myState, g, myState.myHorizontalCycle);
        }
        if (myState.myVerticalCycle != null) {
            GuidelinePainter.paintCycle(myState, g, myState.myVerticalCycle);
        }
    }

    private static void showMatch(NlGraphics g, Match m, GuidelineHandler state) {
        if (m == null) {
            return;
        }
        ConstraintPainter.paintConstraint(g, state, m);
    }

    private static Point center(Rectangle rectangle) {
        return new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
    }

    private static void paintCycle(GuidelineHandler myState, NlGraphics g, List<DependencyGraph.Constraint> cycle) {
        assert (!cycle.isEmpty());
        NlComponent from = cycle.get((int)0).from.node;
        assert (from != null);
        Rectangle fromBounds = new Rectangle(NlComponentHelperKt.getX(from), NlComponentHelperKt.getY(from), NlComponentHelperKt.getW(from), NlComponentHelperKt.getH(from));
        if (myState.myDraggedNodes.contains(from)) {
            fromBounds = myState.myBounds;
        }
        Point fromCenter = GuidelinePainter.center(fromBounds);
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(fromCenter);
        for (DependencyGraph.Constraint constraint : cycle) {
            assert (constraint.from.node == from);
            NlComponent to = constraint.to.node;
            assert (to != null);
            Point toCenter = new Point(NlComponentHelperKt.getX(to) + NlComponentHelperKt.getW(to) / 2, NlComponentHelperKt.getY(to) + NlComponentHelperKt.getH(to) / 2);
            points.add(toCenter);
            boolean isDragged = myState.myDraggedNodes.contains(to);
            if (isDragged) {
                toCenter = GuidelinePainter.center(myState.myBounds);
                points.add(toCenter);
            }
            from = to;
            fromCenter = toCenter;
        }
        points.add(fromCenter);
        points.add((Point)points.get(0));
        g.useStyle(NlDrawingStyle.CYCLE);
        int n = points.size();
        for (int i = 1; i < n; ++i) {
            Point a = (Point)points.get(i - 1);
            Point b = (Point)points.get(i);
            g.drawLine(a.x, a.y, b.x, b.y);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/android/tools/idea/uibuilder/handlers/relative/GuidelinePainter", "paint"));
    }
}

