/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.tools.adtui.ptable.PTableItem;
import com.android.tools.idea.uibuilder.property.EmptyProperty;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.google.common.collect.Table;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddPropertyItem
extends PTableItem {
    private final Table<String, String, NlPropertyItem> myProperties;
    private String myName;
    private NlProperty myProperty;

    public AddPropertyItem(@NotNull Table<String, String, NlPropertyItem> properties) {
        if (properties == null) {
            AddPropertyItem.$$$reportNull$$$0(0);
        }
        this.myName = "";
        this.myProperty = EmptyProperty.INSTANCE;
        this.myProperties = properties;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            AddPropertyItem.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public String getValue() {
        return this.myProperty.getValue();
    }

    @NotNull
    public NlProperty getProperty() {
        NlProperty nlProperty = this.myProperty;
        if (nlProperty == null) {
            AddPropertyItem.$$$reportNull$$$0(2);
        }
        return nlProperty;
    }

    @NotNull
    public List<String> getUnspecifiedProperties() {
        ArrayList<String> items = new ArrayList<String>();
        for (String namespace : this.myProperties.rowKeySet()) {
            if (namespace.equals("http://schemas.android.com/tools")) continue;
            for (NlPropertyItem property : this.myProperties.row((Object)namespace).values()) {
                NlProperty designProperty;
                if (property.getValue() == null) {
                    AddPropertyItem.addProperty(items, namespace, property.getName());
                }
                if ((designProperty = (NlProperty)this.myProperties.get((Object)"http://schemas.android.com/tools", (Object)property.getName())) != null && designProperty.getValue() != null) continue;
                AddPropertyItem.addProperty(items, "http://schemas.android.com/tools", property.getName());
            }
        }
        ArrayList<String> arrayList = items;
        if (arrayList == null) {
            AddPropertyItem.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static void addProperty(@NotNull List<String> items, @NotNull String namespace, @NotNull String name) {
        if (items == null) {
            AddPropertyItem.$$$reportNull$$$0(4);
        }
        if (namespace == null) {
            AddPropertyItem.$$$reportNull$$$0(5);
        }
        if (name == null) {
            AddPropertyItem.$$$reportNull$$$0(6);
        }
        String prefix = "";
        switch (namespace) {
            case "http://schemas.android.com/apk/res/android": {
                prefix = "android:";
                break;
            }
            case "http://schemas.android.com/apk/res-auto": {
                prefix = "app:";
                break;
            }
            case "http://schemas.android.com/tools": {
                prefix = "tools:";
            }
        }
        items.add(prefix + name);
    }

    @NotNull
    public NlProperty findPropertyByQualifiedName(@NotNull String name) {
        NlProperty property;
        if (name == null) {
            AddPropertyItem.$$$reportNull$$$0(7);
        }
        String namespace = "";
        String propertyName = name;
        List names = StringUtil.split((String)name, (String)":", (boolean)false);
        if (names.size() > 1) {
            namespace = AddPropertyItem.convertNamespacePrefix((String)names.get(0));
            propertyName = (String)names.get(1);
        }
        if ((property = (NlProperty)this.myProperties.get((Object)namespace, (Object)propertyName)) == null && namespace.equals("http://schemas.android.com/tools")) {
            property = (NlProperty)this.myProperties.get((Object)"http://schemas.android.com/apk/res-auto", (Object)propertyName);
            if (property == null) {
                property = (NlProperty)this.myProperties.get((Object)"http://schemas.android.com/apk/res/android", (Object)propertyName);
            }
            NlProperty nlProperty = property != null ? property.getDesignTimeProperty() : EmptyProperty.INSTANCE;
            if (nlProperty == null) {
                AddPropertyItem.$$$reportNull$$$0(8);
            }
            return nlProperty;
        }
        NlProperty nlProperty = property != null && property.getValue() == null ? property : EmptyProperty.INSTANCE;
        if (nlProperty == null) {
            AddPropertyItem.$$$reportNull$$$0(9);
        }
        return nlProperty;
    }

    private static String convertNamespacePrefix(@NotNull String prefix) {
        if (prefix == null) {
            AddPropertyItem.$$$reportNull$$$0(10);
        }
        switch (prefix) {
            case "android:": {
                return "http://schemas.android.com/apk/res/android";
            }
            case "app:": {
                return "http://schemas.android.com/apk/res-auto";
            }
            case "tools:": {
                return "http://schemas.android.com/tools";
            }
        }
        return "";
    }

    public boolean isEditable(int column) {
        return column == 0 || this.isPropertyNameSelected();
    }

    public int getColumnToEdit() {
        return this.isPropertyNameSelected() ? 1 : 0;
    }

    public void setValue(@Nullable Object value) {
        if (!this.isPropertyNameSelected()) {
            this.myName = value == null ? "" : value.toString().trim();
        } else {
            this.myProperty.setValue(value);
        }
    }

    public void updateProperty() {
        this.myProperty = this.findPropertyByQualifiedName(this.myName);
    }

    public boolean isPropertyNameSelected() {
        return this.myProperty != EmptyProperty.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/property/AddPropertyItem";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/property/AddPropertyItem";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperty";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnspecifiedProperties";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findPropertyByQualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addProperty";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findPropertyByQualifiedName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "convertNamespacePrefix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

